/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11TokenInfo {
    public static final int RNG = 1;
    public static final int WRITE_PROTECTED = 2;
    public static final int LOGIN_REQUIRED = 4;
    public static final int USER_PIN_INITIALIZED = 8;
    public static final int EXCLUSIVE_EXISTS = 16;
    public static final int RESTORE_KEY_NOT_NEEDED = 32;
    public static final int CLOCK_ON_TOKEN = 64;
    public static final int SUPPORTS_PARALLEL = 128;
    public static final int PROTECTED_AUTHENTICATION_PATH = 256;
    public static final int DUAL_CRYPTO_OPERATIONS = 512;
    public static final int TOKEN_INITIALIZED = 1024;
    public static final int SECONDARY_AUTHENTICATION = 2048;
    public static final int USER_PIN_COUNT_LOW = 65536;
    public static final int USER_PIN_FINAL_TRY = 131072;
    public static final int USER_PIN_LOCKED = 262144;
    public static final int USER_PIN_TO_BE_CHANGED = 524288;
    public static final int SO_PIN_COUNT_LOW = 0x100000;
    public static final int SO_PIN_FINAL_TRY = 0x200000;
    public static final int SO_PIN_LOCKED = 0x400000;
    public static final int SO_PIN_TO_BE_CHANGED = 0x800000;
    public static final int UNAVAILABLE_INFORMATION = -1;
    public static final int EFFECTIVELY_INFINITE = 0;
    static final int[] flagList = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000};
    static final String[] flagNames = new String[]{"RNG", "WRITE_PROTECTED", "LOGIN_REQUIRED", "USER_PIN_INITIALIZED", "EXCLUSIVE_EXISTS", "RESTORE_KEY_NOT_NEEDED", "CLOCK_ON_TOKEN", "SUPPORTS_PARALLEL", "PROTECTED_AUTHENTICATION_PATH", "DUAL_CRYPTO_OPERATIONS", "TOKEN_INITIALIZED", "SECONDARY_AUTHENTICATION", "USER_PIN_COUNT_LOW", "USER_PIN_FINAL_TRY", "USER_PIN_LOCKED", "USER_PIN_TO_BE_CHANGED", "SO_PIN_COUNT_LOW", "SO_PIN_FINAL_TRY", "SO_PIN_LOCKED", "SO_PIN_TO_BE_CHANGED"};
    private String label;
    private String manufacturer;
    private String model;
    private String serialNumber;
    private int flags;
    private int maxSessionCount;
    private int sessionCount;
    private int maxRwSessionCount;
    private int rwSessionCount;
    private int maxPinLen;
    private int minPinLen;
    private int totalPublicMemory;
    private int freePublicMemory;
    private int totalPrivateMemory;
    private int freePrivateMemory;
    private int hardwareVersion;
    private int firmwareVersion;
    private String utcTime;

    public PKCS11TokenInfo(String label, String manufacturer, String model, String serialNumber, int flags, int maxSessionCount, int sessionCount, int maxRwSessionCount, int rwSessionCount, int maxPinLen, int minPinLen, int totalPublicMemory, int freePublicMemory, int totalPrivateMemory, int freePrivateMemory, int hardwareVersion, int firmwareVersion, String utcTime) {
        this.label = label;
        this.manufacturer = manufacturer;
        this.model = model;
        this.serialNumber = serialNumber;
        this.flags = flags;
        this.maxSessionCount = maxSessionCount;
        this.sessionCount = sessionCount;
        this.maxRwSessionCount = maxRwSessionCount;
        this.rwSessionCount = rwSessionCount;
        this.maxPinLen = maxPinLen;
        this.minPinLen = minPinLen;
        this.totalPublicMemory = totalPublicMemory;
        this.freePublicMemory = freePublicMemory;
        this.totalPrivateMemory = totalPrivateMemory;
        this.freePrivateMemory = freePrivateMemory;
        this.hardwareVersion = hardwareVersion;
        this.firmwareVersion = firmwareVersion;
        this.utcTime = utcTime;
    }

    public String label() {
        return this.label;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public int flags() {
        return this.flags;
    }

    public int maxSessionCount() {
        return this.maxSessionCount;
    }

    public int sessionCount() {
        return this.sessionCount;
    }

    public int maxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public int rwSessionCount() {
        return this.rwSessionCount;
    }

    public int maxPinLen() {
        return this.maxPinLen;
    }

    public int minPinLen() {
        return this.minPinLen;
    }

    public int totalPublicMemory() {
        return this.totalPublicMemory;
    }

    public int freePublicMemory() {
        return this.freePublicMemory;
    }

    public int totalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public int freePrivateMemory() {
        return this.freePrivateMemory;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public String utcTime() {
        return this.utcTime;
    }

    public String toString() {
        return "PKCS11TokenInfo:\n    Label:             " + this.label + "\n    Manufacturer:      " + this.manufacturer + "\n    Model:             " + this.model + "\n    Serial:            " + this.serialNumber + "\n    Flags:             " + this.flagsToString(" | ") + "\n    Max sessions:      " + this.infinite(this.maxSessionCount) + "\n    Sessions:          " + this.unavailable(this.sessionCount) + "\n    Max RW sessions:   " + this.infinite(this.maxRwSessionCount) + "\n    RW sessions:       " + this.unavailable(this.rwSessionCount) + "\n    Max PIN len:       " + this.maxPinLen + "\n    Min PIN len:       " + this.minPinLen + "\n    Total public mem:  " + this.unavailable(this.totalPublicMemory) + "\n    Free public mem:   " + this.unavailable(this.freePublicMemory) + "\n    Total private mem: " + this.unavailable(this.totalPrivateMemory) + "\n    Free private mem:  " + this.unavailable(this.freePrivateMemory) + "\n    Hardware version:  " + PKCS11.versionString(this.hardwareVersion) + "\n    Firmware version:  " + PKCS11.versionString(this.firmwareVersion) + (this.utcTime != null ? "\n    UTC time:          " + this.utcTime : "");
    }

    public String flagsToString(String separator) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, separator);
    }

    String infinite(int val) {
        return val == 0 ? "EFFECTIVELY_INFINITE" : this.unavailable(val);
    }

    String unavailable(int val) {
        return val == -1 ? "UNAVAILABLE_INFORMATION" : Integer.toString(val);
    }
}

