/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertConstants;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.Pk10CertificateRequest;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.certclient.util.PkUtils;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public final class Pk10CertReqFactory
implements PkConstants {
    private Pk10CertReqFactory() {
        throw new UnsupportedOperationException();
    }

    public static Pk10CertificateRequest newCertRequest(int keySize, String subject, int numValidDays, String keyType, String signatureAlgorithm, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String provider) throws PkException {
        return new CertRequestImpl(keySize, subject, numValidDays, keyType, signatureAlgorithm, useShortSubjectKId, subjectAltNames, kUsage, extkUsage, provider, null);
    }

    public static Pk10CertificateRequest newCertRequest(int keySize, String subject, int numValidDays, String keyType, String signatureAlgorithm, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String provider, KeyPair keyPair) throws PkException {
        return new CertRequestImpl(keySize, subject, numValidDays, keyType, signatureAlgorithm, useShortSubjectKId, subjectAltNames, kUsage, extkUsage, provider, keyPair);
    }

    public static Pk10CertificateRequest newCertRequest(String subject, String provider) throws PkException {
        return new CertRequestImpl(subject, provider);
    }

    private static final class CertRequestImpl
    implements Pk10CertificateRequest {
        private static Debug debug = Debug.getInstance("keycertmanage");
        private final Object className = this.toString();
        private String subject;
        private int keySize;
        private int numValidDays;
        private String provider;
        private String keyType;
        private String signatureAlgorithm;
        private boolean iskIdShortForm;
        private ArrayList<String> keyUsage = new ArrayList(10);
        private ArrayList<String> extKeyUsage = new ArrayList(10);
        private ArrayList<String> subjectAltNames = new ArrayList(5);
        private KeyPair keypair;
        private CertificationRequest certreq;

        CertRequestImpl(String subjectDN, String provider) throws PkException {
            this.setSubject(subjectDN);
            this.setKeyType("RSA");
            this.setKeySize(1024);
            this.setValidity(365);
            this.setkIdform(false);
            this.setSignatureAlgorithm("SHA1withRSA");
            this.setSubjectAltNames(null);
            this.setKeyUsage(null);
            this.setExtKeyUsage(null);
            this.setProvider(provider);
            this.generatePKCS10CertReq();
        }

        CertRequestImpl(int keySize, String subjectDN, int numValidDays, String keyType, String signatureAlgorithm, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String provider, KeyPair keyPair) throws PkException {
            this.setKeyType(keyType);
            this.setKeySize(keySize);
            this.setSubject(subjectDN);
            this.setValidity(numValidDays);
            this.setSignatureAlgorithm(signatureAlgorithm);
            this.setkIdform(useShortSubjectKId);
            this.setSubjectAltNames(subjectAltNames);
            this.setKeyUsage(kUsage);
            this.setExtKeyUsage(extkUsage);
            this.setKeyPair(keyPair);
            this.setProvider(provider);
            this.generatePKCS10CertReq();
        }

        protected void setSubject(String subject) throws PkException {
            if (subject == null || subject.length() == 0) {
                throw new PkException(PkNLSConstants.INVALID_SUBJECT_NAME);
            }
            this.subject = subject;
        }

        protected void setKeySize(int keySize) throws PkException {
            if ("DSA".equalsIgnoreCase(this.keyType) ? keySize != 512 && keySize != 1024 && keySize != 2048 : ("EC".equalsIgnoreCase(this.keyType) ? keySize != 192 && keySize != 224 && keySize != 256 && keySize != 384 && keySize != 521 : "RSA".equalsIgnoreCase(this.keyType) && keySize < 512)) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + keySize);
            }
            this.keySize = keySize;
        }

        protected void setValidity(int numValidDays) throws PkException {
            if (numValidDays <= 0) {
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_CERT_VALIDITY + numValidDays);
            }
            this.numValidDays = numValidDays;
        }

        protected void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        protected void setProvider(String provider) {
            this.provider = provider;
        }

        protected void setSignatureAlgorithm(String signatureAlgorithm) throws PkException {
            boolean ex = false;
            if ("RSA".equalsIgnoreCase(this.keyType)) {
                if (signatureAlgorithm.indexOf("RSA") < 0) {
                    ex = true;
                }
            } else if ("DSA".equalsIgnoreCase(this.keyType)) {
                if (signatureAlgorithm.indexOf("DSA") < 0) {
                    ex = true;
                }
            } else if ("EC".equalsIgnoreCase(this.keyType) && signatureAlgorithm.indexOf("EC") < 0) {
                ex = true;
            }
            if (ex) {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_SIGNATURE_ALGORITHM + signatureAlgorithm);
            }
            this.signatureAlgorithm = signatureAlgorithm;
        }

        protected void setkIdform(boolean useShortSubjectKId) {
            this.iskIdShortForm = useShortSubjectKId;
        }

        protected void setKeyUsage(List<String> kUsage) {
            if (kUsage != null && kUsage.size() > 0) {
                this.keyUsage.addAll(kUsage);
            }
        }

        protected void setKeyPair(KeyPair pair) {
            if (pair != null) {
                this.keypair = pair;
            }
        }

        protected void setExtKeyUsage(List<String> kUsage) {
            if (kUsage != null && kUsage.size() > 0) {
                this.extKeyUsage.addAll(kUsage);
            }
        }

        protected void setSubjectAltNames(List<String> subjectAltName) {
            if (subjectAltName != null && subjectAltName.size() > 0) {
                this.subjectAltNames = new ArrayList<String>(subjectAltName);
            }
        }

        private KeyPair generateLocalKey(String keyType, int keySz, String randomNoGenerator, String provider) throws PkRejectionException {
            KeyPair keyPair;
            int locKeySz;
            String locKeyType = keyType == null || keyType.length() == 0 ? "RSA" : keyType;
            String locProvider = provider == null || provider.length() == 0 ? "IBMJCE" : provider;
            int n2 = locKeySz = keySz == 0 ? 1024 : keySz;
            if (debug != null) {
                debug.text(0L, this.className, "generateLocalKey", "Keytype is {0}", locKeyType);
                debug.text(0L, this.className, "generateLocalKey", "Provider is {0}", locProvider);
                debug.text(0L, this.className, "generateLocalKey", "KeySize is {0}", new Integer(locKeySz));
            }
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(locKeyType, provider);
                SecureRandom secureRandom = randomNoGenerator == null || randomNoGenerator.length() == 0 ? SecureRandom.getInstance(locProvider) : SecureRandom.getInstance(randomNoGenerator, locProvider);
                if (debug != null) {
                    debug.text(0L, this.className, "generateLocalKey", "RNG is {0}", secureRandom);
                }
                keyPairGenerator.initialize(keySz, secureRandom);
                keyPair = keyPairGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION, nsae);
            }
            catch (NoSuchProviderException nspe) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PROVIDER, nspe);
            }
            catch (InvalidParameterException e2) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + keySz, e2);
            }
            return keyPair;
        }

        private PkAttrs initialCertRequest(String[] values, String[] subjectAltNames, String[] kUsage, String[] extkUsage, PublicKey pubKey, PrivateKey privateKey, String signatureAlgorithm) throws Exception {
            int i2;
            if (values == null || values.length < 4) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_ARRAY_SIZE_WRONG);
            }
            if (debug != null) {
                for (int o2 = 0; o2 < values.length; ++o2) {
                    debug.text(1L, this.className, "initialCertRequest", "Processing {0}", values[o2]);
                }
            }
            for (i2 = 0; i2 < values.length; ++i2) {
                if (values[i2] != null) continue;
                throw new PkRejectionException("" + i2 + " " + PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
            }
            if (pubKey == null) {
                throw new PkRejectionException(PkNLSConstants.INVALID_PARMS_VALUE_CANNOT_BE_NULL);
            }
            if (kUsage != null) {
                for (i2 = 0; i2 < kUsage.length; ++i2) {
                    if (debug == null) continue;
                    debug.text(1L, this.className, "initialCertRequest", "Processing {0}", kUsage[i2]);
                }
            }
            if (extkUsage != null && debug != null) {
                for (i2 = 0; i2 < extkUsage.length; ++i2) {
                    debug.text(1L, this.className, "initialCertRequest", "Processing {0}", extkUsage[i2]);
                }
            }
            X509Key publicKey = (X509Key)pubKey;
            String subject = values[0];
            Integer version = new Integer(values[1]);
            if (version != 3) {
                throw new PkRejectionException(PkNLSConstants.X509_CERT_VERSION_MUST_BE3);
            }
            version = PkCertConstants.CERT_VERSION_3;
            PkAttrs attrs = new PkAttrs();
            int approved = 3;
            if (kUsage != null && kUsage.length > 0) {
                KeyUsageExtension keyUsage = this.setKeyUsageExt(kUsage);
                ExtKeyUsageExtension kuext = null;
                if (extkUsage != null) {
                    kuext = this.setextKeyUsageExt(extkUsage);
                }
                attrs.add("x509.info.extensions.KeyUsage", approved, keyUsage);
                if (kuext != null) {
                    attrs.add("x509.info.extensions.ExtKeyUsage", approved, kuext);
                }
            }
            attrs.add("x509.info.version", approved, version);
            attrs.add("x509.info.algorithmID", approved, AlgorithmId.get(signatureAlgorithm));
            attrs.add("x509.info.algorithmName", 2, signatureAlgorithm);
            attrs.add("cert.oper.PROVIDER", 2, this.provider);
            long notBefore = new Long(values[2]);
            Date dtNotBefore = new Date(notBefore);
            attrs.add("x509.info.validity.notBefore", approved, dtNotBefore);
            Date dt = new Date();
            dt.setTime(dtNotBefore.getTime());
            long notAfter = new Long(values[3]);
            dt.setTime(notAfter += dt.getTime());
            if (debug != null) {
                debug.text(1L, this.className, "initialCertRequest", "notAfter {0}", dt);
            }
            attrs.add("x509.info.validity.notAfter", approved, dt);
            attrs.add("x509.info.subject", approved, new X500Name(subject));
            attrs.add("x509.info.key", approved, publicKey);
            SubjectAlternativeNameExtension sub = this.createSubjectAltName(subjectAltNames);
            if (sub != null) {
                attrs.add("x509.info.extensions.SubjectAlternativeName", approved, sub);
            }
            if (debug != null) {
                debug.text(1L, this.className, "initialCertRequest", "process complete attrs {0}", attrs);
            }
            return attrs;
        }

        private boolean keyUsageWrong(boolean rsaKeyType, KeyUsageExtension keyUsage) throws Exception {
            boolean bad;
            block6: {
                int i2;
                boolean[] ba;
                block5: {
                    ba = keyUsage.getBits();
                    bad = false;
                    if (!rsaKeyType) break block5;
                    for (int i3 = 0; i3 < ba.length; ++i3) {
                        if (debug == null) continue;
                        debug.text(1L, this.className, "keyUsageWrong", "ba ={0}", new Boolean(ba[i3]));
                    }
                    if (ba.length <= 5) break block6;
                    int j2 = ba.length >= 7 ? 7 : ba.length;
                    for (int i4 = 5; i4 < j2; ++i4) {
                        bad = bad || ba[i4];
                    }
                    break block6;
                }
                for (i2 = 0; i2 < ba.length; ++i2) {
                    if (debug == null) continue;
                    debug.text(1L, this.className, "keyUsageWrong", "ba ={0}", new Boolean(ba[i2]));
                }
                if (ba.length > 2) {
                    for (i2 = 2; i2 < ba.length; ++i2) {
                        bad = bad || ba[i2];
                    }
                }
            }
            return bad;
        }

        private SubjectAlternativeNameExtension createSubjectAltName(String[] subjectAltNames) throws Exception {
            SubjectAlternativeNameExtension sub = null;
            if (subjectAltNames != null) {
                GeneralNames gen = new GeneralNames();
                boolean altnameSpecified = false;
                int length = subjectAltNames.length;
                if (subjectAltNames[0] != null) {
                    gen.addElement(new RFC822Name(subjectAltNames[0]));
                    altnameSpecified = true;
                }
                if (length > 1 && subjectAltNames[1] != null) {
                    gen.addElement(new DNSName(subjectAltNames[1]));
                    altnameSpecified = true;
                }
                if (length > 2 && subjectAltNames[2] != null) {
                    gen.addElement(new URIName(subjectAltNames[2]));
                    altnameSpecified = true;
                }
                if (length > 3 && subjectAltNames[3] != null) {
                    gen.addElement(new IPAddressName(this.getIPAddress(subjectAltNames[3])));
                    altnameSpecified = true;
                }
                if (altnameSpecified) {
                    sub = new SubjectAlternativeNameExtension(gen);
                }
            }
            return sub;
        }

        private byte[] getIPAddress(String ipString) {
            String[] splitString = PkString.split(ipString, ".");
            byte[] ipAddress = new byte[]{new Integer(splitString[0]).byteValue(), new Integer(splitString[1]).byteValue(), new Integer(splitString[2]).byteValue(), new Integer(splitString[3]).byteValue()};
            return ipAddress;
        }

        private KeyUsageExtension setKeyUsageExt(String[] kUsage) throws IOException, PkRejectionException {
            KeyUsageExtension keyUsage = new KeyUsageExtension();
            for (int index = 0; index < kUsage.length && kUsage[index] != null; ++index) {
                if (kUsage[index].equalsIgnoreCase("digital_signature")) {
                    keyUsage.set("digital_signature", Boolean.TRUE);
                    continue;
                }
                if (kUsage[index].equalsIgnoreCase("data_encipherment")) {
                    keyUsage.set("data_encipherment", Boolean.TRUE);
                    continue;
                }
                if (kUsage[index].equalsIgnoreCase("encipher_only")) {
                    keyUsage.set("encipher_only", Boolean.TRUE);
                    continue;
                }
                if (kUsage[index].equalsIgnoreCase("decipher_only")) {
                    keyUsage.set("decipher_only", Boolean.TRUE);
                    continue;
                }
                if (kUsage[index].equalsIgnoreCase("non_repudiation")) {
                    keyUsage.set("non_repudiation", Boolean.TRUE);
                    continue;
                }
                if (kUsage[index].equalsIgnoreCase("key_encipherment")) {
                    keyUsage.set("key_encipherment", Boolean.TRUE);
                    continue;
                }
                if (kUsage[index].equalsIgnoreCase("key_agreement")) {
                    keyUsage.set("key_agreement", Boolean.TRUE);
                    continue;
                }
                if (debug != null) {
                    debug.text(1L, this.className, "setKeyUsageExt", "Key usage {0} is not valid", kUsage[index]);
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            return keyUsage;
        }

        private ExtKeyUsageExtension setextKeyUsageExt(String[] extkUsage) throws IOException, PkRejectionException {
            ExtKeyUsageExtension extkeyUsage = null;
            Vector<ObjectIdentifier> v2 = new Vector<ObjectIdentifier>();
            for (int index = 0; index < extkUsage.length && extkUsage[index] != null; ++index) {
                if (extkUsage[index].equalsIgnoreCase("ServerAuth_Id")) {
                    v2.add(index, PKIXExtensions.ServerAuth_Id);
                    continue;
                }
                if (extkUsage[index].equalsIgnoreCase("ClientAuth_Id")) {
                    v2.add(index, PKIXExtensions.ClientAuth_Id);
                    continue;
                }
                if (extkUsage[index].equalsIgnoreCase("CodeSigning_Id")) {
                    v2.add(index, PKIXExtensions.CodeSigning_Id);
                    continue;
                }
                if (extkUsage[index].equalsIgnoreCase("EmailProtection_Id")) {
                    v2.add(index, PKIXExtensions.EmailProtection_Id);
                    continue;
                }
                if (extkUsage[index].equalsIgnoreCase("IPSecEndSystem_Id")) {
                    v2.add(index, PKIXExtensions.IPSecEndSystem_Id);
                    continue;
                }
                if (extkUsage[index].equalsIgnoreCase("IPSecTunnel_Id")) {
                    v2.add(index, PKIXExtensions.IPSecTunnel_Id);
                    continue;
                }
                if (extkUsage[index].equalsIgnoreCase("IPSecUser_Id")) {
                    v2.add(index, PKIXExtensions.IPSecUser_Id);
                    continue;
                }
                if (extkUsage[index].equalsIgnoreCase("TimeStamping_Id")) {
                    v2.add(index, PKIXExtensions.TimeStamping_Id);
                    continue;
                }
                if (debug != null) {
                    debug.text(1L, this.className, "extsetKeyUsageExt", "Key usage {0} is not valid", extkUsage[index]);
                }
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
            }
            if (v2.size() > 0) {
                extkeyUsage = new ExtKeyUsageExtension(v2);
            }
            return extkeyUsage;
        }

        private PkAttrs getAttrs() throws PkRejectionException {
            String notBefore = new Long(new Date().getTime()).toString();
            long tmp1 = (long)this.numValidDays * 24L * 60L * 60L * 1000L;
            String issuedCertValidity = new Long(tmp1).toString();
            if (debug != null) {
                debug.text(1L, this.className, "makeCertReq", "issuedCertValidity {0}", issuedCertValidity);
            }
            Object localKeyPair = null;
            if (this.keypair == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "getAttrs", "keyPair is null");
                }
                try {
                    this.keypair = this.generateLocalKey(this.keyType, this.keySize, "IBMSecureRandom", this.provider);
                }
                catch (Exception e2) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "getAttrs", e2);
                    }
                    throw new PkRejectionException(PkNLSConstants.KEY_PAIR_CREATION_FAILED, e2);
                }
            }
            PkAttrs attrs = new PkAttrs();
            String[] values = new String[]{this.subject, "3", notBefore, issuedCertValidity};
            try {
                String[] san = null;
                String[] ku = null;
                String[] xku = null;
                this.subjectAltNames.trimToSize();
                this.keyUsage.trimToSize();
                this.extKeyUsage.trimToSize();
                if (this.subjectAltNames.size() > 0) {
                    san = this.subjectAltNames.toArray(new String[0]);
                }
                if (this.keyUsage.size() > 0) {
                    ku = this.keyUsage.toArray(new String[0]);
                }
                if (this.extKeyUsage.size() > 0) {
                    xku = this.extKeyUsage.toArray(new String[0]);
                }
                attrs = this.initialCertRequest(values, san, ku, xku, this.keypair.getPublic(), this.keypair.getPrivate(), this.signatureAlgorithm);
                SubjectKeyIdentifierExtension ski = null;
                byte[] kIDTmp = PkUtils.computeKID(this.keypair.getPublic(), this.iskIdShortForm);
                ski = new SubjectKeyIdentifierExtension(kIDTmp);
                attrs.repOrAdd("x509.info.extensions.SubjectKeyIdentifier", 3, ski);
            }
            catch (Exception e3) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getAttrs", e3);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_CERTREQ_FAILED, e3);
            }
            return attrs;
        }

        private void generatePKCS10CertReq() throws PkRejectionException {
            try {
                CertificationRequest cr;
                PkAttrs attrs = this.getAttrs();
                X500Name name = (X500Name)attrs.get("x509.info.subject").getValue();
                PublicKey key = (PublicKey)attrs.get("x509.info.key").getValue();
                CertificateExtensions cext = new CertificateExtensions();
                if (attrs.has("x509.info.extensions.KeyUsage")) {
                    KeyUsageExtension kue = (KeyUsageExtension)attrs.get("x509.info.extensions.KeyUsage").getValue();
                    cext.set("x509.info.extensions.KeyUsage", kue);
                }
                if (attrs.has("x509.info.extensions.ExtKeyUsage")) {
                    ExtKeyUsageExtension ekue = (ExtKeyUsageExtension)attrs.get("x509.info.extensions.ExtKeyUsage").getValue();
                    cext.set("x509.info.extensions.ExtKeyUsage", ekue);
                }
                if (attrs.has("x509.info.extensions.SubjectAlternativeName")) {
                    SubjectAlternativeNameExtension sane = (SubjectAlternativeNameExtension)attrs.get("x509.info.extensions.SubjectAlternativeName").getValue();
                    cext.set("x509.info.extensions.SubjectAlternativeName", sane);
                }
                if (attrs.has("x509.info.extensions.SubjectKeyIdentifier")) {
                    SubjectKeyIdentifierExtension skie = (SubjectKeyIdentifierExtension)attrs.get("x509.info.extensions.SubjectKeyIdentifier").getValue();
                    cext.set("x509.info.extensions.SubjectKeyIdentifier", skie);
                }
                DerOutputStream extOut = new DerOutputStream();
                cext.encode(extOut, true);
                PKCSAttributes pkAttrs = null;
                if (extOut.size() > 0) {
                    PKCSAttribute pkcsa = new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, cext);
                    pkAttrs = new PKCSAttributes(new PKCSAttribute[]{pkcsa});
                }
                CertificationRequestInfo cri = new CertificationRequestInfo(name, key, pkAttrs, this.provider);
                this.certreq = cr = new CertificationRequest(cri, this.keypair.getPrivate(), this.signatureAlgorithm, this.provider);
            }
            catch (IOException ioe) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", ioe);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, ioe);
            }
            catch (CertificateException ce) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", ce);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, ce);
            }
            catch (PKCSException pex) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", pex);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, pex);
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", nsae);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, nsae);
            }
        }

        @Override
        public PrivateKey getPrivateKey() {
            return this.keypair.getPrivate();
        }

        @Override
        public PublicKey getPublicKey() {
            return this.keypair.getPublic();
        }

        @Override
        public byte[] getPKCS10CertReq() throws IOException {
            return this.certreq.encode();
        }
    }
}

