/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public class PkUtils {
    private static Debug debug = Debug.getInstance("keycertmanage");
    private static final Object className = "PkUtils";

    public static byte[] computeKID(PublicKey key, boolean shortValue) throws NoSuchAlgorithmException {
        byte[] k2 = key.getEncoded();
        if (k2 == null) {
            return null;
        }
        int off = PkUtils.getOff(k2) + 1;
        if (off >= k2.length) {
            return null;
        }
        MessageDigest dig = MessageDigest.getInstance("SHA1");
        dig.update(k2, off, k2.length - off);
        if (shortValue) {
            byte[] d2 = dig.digest();
            byte[] r2 = new byte[8];
            for (int j2 = 0; j2 < 8; ++j2) {
                r2[j2] = d2[j2 + d2.length - 8];
            }
            r2[0] = (byte)(r2[0] & 0xF | 0x40);
            return r2;
        }
        return dig.digest();
    }

    private static int getOff(byte[] k2) {
        if (k2 == null) {
            return 0;
        }
        if (k2.length < 2) {
            return k2.length;
        }
        if ((k2[1] & 0x80) == 0) {
            return 2;
        }
        return (k2[1] & 0x7F) + 2;
    }
}

