/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.TCPMsgRfc2510;
import com.ibm.security.cmp.TCPMsgV10;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public final class TCPMessage {
    public static final int TCP_MESSAGE_V10 = 10;
    public static final int TCP_MESSAGE_RFC_2510 = 0;
    private int version;
    private Object TcpObject;

    public TCPMessage(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public TCPMessage(Object object) {
        this.setTCPMessage(object);
    }

    public Object getMessage() {
        return this.TcpObject;
    }

    public int getVersion() {
        return this.version;
    }

    private void read(InputStream inputStream) throws IOException {
        inputStream.mark(10);
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        int n2 = new BigInteger(1, byArray).intValue();
        byte[] byArray2 = new byte[1];
        inputStream.read(byArray2);
        if (byArray2[0] == 10) {
            this.version = 10;
            inputStream.reset();
            this.TcpObject = new TCPMsgV10(inputStream);
        } else if (byArray2[0] < 10) {
            this.version = 0;
            inputStream.reset();
            this.TcpObject = new TCPMsgRfc2510(inputStream);
        } else {
            this.version = byArray2[0];
            throw new IOException("TCPMessage read error : TCP message protocol version " + new String(byArray2) + " not supported");
        }
    }

    private void setTCPMessage(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("TCPMessage error : TCP message object not specified");
        }
        if (object instanceof TCPMsgV10) {
            this.version = 10;
        } else if (object instanceof TCPMsgRfc2510) {
            this.version = 0;
        } else {
            throw new IllegalArgumentException("TCPMessage error : not a valid TCPMessage object");
        }
        this.TcpObject = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(OutputStream outputStream) throws IOException {
        if (this.TcpObject == null) {
            throw new IOException("TCPMessage write error : TCP Message Object not specified");
        }
        if (this.version == 10) {
            if (!(this.TcpObject instanceof TCPMsgV10)) throw new IOException("TCPMessage write error : invalid TCP Message object");
            ((TCPMsgV10)this.TcpObject).write(outputStream);
            return;
        } else {
            if (this.version != 0) throw new IOException("TCPMessage write error : invalid version number");
            if (!(this.TcpObject instanceof TCPMsgRfc2510)) throw new IOException("TCPMessage write error : invalid TCP Message object");
            ((TCPMsgRfc2510)this.TcpObject).write(outputStream);
        }
    }
}

