/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.AttributeTypeAndValue;
import com.ibm.security.crmf.CertRequest;
import com.ibm.security.crmf.POPOSigningKey;
import com.ibm.security.crmf.ProofOfPossession;
import com.ibm.security.crmf.RegistrationInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Vector;

public final class CertReqMsg
extends CMPDerObject {
    private CertRequest certReq;
    private ProofOfPossession pop;
    private RegistrationInfo[] regInfo;
    private static final String IBM_JCE_PROVIDER = "IBMJCE";
    private static final String IBM_JCA_PROVIDER = "IBMJCA";

    public CertReqMsg(CertRequest certRequest, ProofOfPossession proofOfPossession, AttributeTypeAndValue[] attributeTypeAndValueArray) {
        if (certRequest == null) {
            throw new IllegalArgumentException("CertRequest must be specified");
        }
        this.certReq = certRequest;
        this.pop = proofOfPossession;
        this.regInfo = (RegistrationInfo[])attributeTypeAndValueArray;
    }

    public CertReqMsg(byte[] byArray) throws IOException {
        super(byArray);
    }

    public CertReqMsg addRegInfo(RegistrationInfo[] registrationInfoArray) throws IOException {
        CertReqMsg certReqMsg = (CertReqMsg)this.clone();
        if (registrationInfoArray == null || registrationInfoArray.length == 0) {
            return certReqMsg;
        }
        if (certReqMsg.regInfo == null) {
            certReqMsg.regInfo = registrationInfoArray;
        } else {
            int n2 = certReqMsg.regInfo.length + registrationInfoArray.length;
            RegistrationInfo[] registrationInfoArray2 = new RegistrationInfo[n2];
            int n3 = 0;
            while (n3 < certReqMsg.regInfo.length) {
                registrationInfoArray2[n3] = certReqMsg.regInfo[n3];
                ++n3;
            }
            int n4 = n3;
            int n5 = 0;
            while (n4 < n2) {
                registrationInfoArray2[n4] = registrationInfoArray[n5];
                ++n4;
                ++n5;
            }
            certReqMsg.regInfo = registrationInfoArray2;
        }
        return certReqMsg;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new CertReqMsg(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void decode(DerValue var1_1) throws IOException {
        if (var1_1.getTag() != 48) {
            throw new IOException("CertReqMsg parsing error, invalid tag");
        }
        if (var1_1.getData().available() == 0) {
            throw new IOException("CertReqMsg parsing error, missing data");
        }
        this.certReq = null;
        this.pop = null;
        this.regInfo = null;
        this.certReq = new CertRequest(var1_1.getData().getDerValue().toByteArray());
        if (var1_1.getData().available() == 0) {
            return;
        }
        var2_2 = var1_1.getData().getDerValue();
        if (var2_2.getTag() != 48) {
            this.pop = new ProofOfPossession(var2_2.toByteArray());
            if (var1_1.getData().available() != 0) {
                var2_2 = var1_1.getData().getDerValue();
            } else {
                return;
            }
        }
        var3_3 = new Vector<RegistrationInfo>();
        if (var2_2.getTag() == 48) ** GOTO lbl25
        throw new IOException("CertReqMsg parsing error");
lbl-1000:
        // 1 sources

        {
            var4_4 = var2_2.getData().getDerValue();
            var5_6 = new RegistrationInfo(var4_4.toByteArray());
            var3_3.add(var5_6);
lbl25:
            // 2 sources

            ** while (var2_2.getData().available() != 0)
        }
lbl26:
        // 1 sources

        if (var3_3.size() > 0) {
            this.regInfo = new RegistrationInfo[var3_3.size()];
            var4_5 = 0;
            while (var4_5 < var3_3.size()) {
                this.regInfo[var4_5] = (RegistrationInfo)var3_3.elementAt(var4_5);
                ++var4_5;
            }
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.certReq == null) {
            throw new IOException("CertRequest not specified");
        }
        this.certReq.encode(derOutputStream);
        if (this.pop != null) {
            this.pop.encode(derOutputStream);
        }
        if (this.regInfo != null) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            int n2 = 0;
            while (n2 < this.regInfo.length) {
                this.regInfo[n2].encode(derOutputStream3);
                ++n2;
            }
            derOutputStream.write((byte)48, derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(CertReqMsg certReqMsg) {
        DerValue derValue;
        DerValue derValue2;
        if (certReqMsg == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certReqMsg.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof CertReqMsg) {
            return this.equals((CertReqMsg)object);
        }
        return false;
    }

    public CertRequest getCertReq() {
        return (CertRequest)this.certReq.clone();
    }

    public ProofOfPossession getPOP() {
        if (this.pop == null) {
            return null;
        }
        return (ProofOfPossession)this.pop.clone();
    }

    public RegistrationInfo[] getRegInfo() {
        if (this.regInfo == null) {
            return null;
        }
        return (RegistrationInfo[])this.regInfo.clone();
    }

    public CertReqMsg prove(PrivateKeyInfo privateKeyInfo) throws IOException, NoSuchAlgorithmException, KeyException, SignatureException {
        if (privateKeyInfo == null) {
            throw new IllegalArgumentException("CertReqMsg error, private key info not specified");
        }
        X500Name x500Name = this.certReq.getCertTemplate().getSubject();
        PublicKey publicKey = this.certReq.getCertTemplate().getPublicKey();
        if (x500Name == null || publicKey == null) {
            throw new IOException("CertReqMsg error, missing data for signing for ProofOfPossesion");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.certReq.encode(derOutputStream);
        }
        catch (IOException iOException) {
            throw new IOException("CertReqMsg error, unable to encode");
        }
        byte[] byArray = derOutputStream.toByteArray();
        AlgorithmId algorithmId = privateKeyInfo.getAlgorithmId();
        String string = algorithmId.getName();
        Signature signature = null;
        try {
            signature = Signature.getInstance(string, IBM_JCE_PROVIDER);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            try {
                signature = Signature.getInstance(string, IBM_JCA_PROVIDER);
            }
            catch (NoSuchProviderException noSuchProviderException2) {
                signature = Signature.getInstance(string);
            }
        }
        signature.initSign(privateKeyInfo);
        byte[] byArray2 = null;
        signature.update(byArray);
        byArray2 = signature.sign();
        POPOSigningKey pOPOSigningKey = new POPOSigningKey(null, algorithmId, byArray2);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        pOPOSigningKey.encode(derOutputStream2);
        ProofOfPossession proofOfPossession = new ProofOfPossession(1, pOPOSigningKey);
        CertReqMsg certReqMsg = (CertReqMsg)this.clone();
        certReqMsg.pop = proofOfPossession;
        return certReqMsg;
    }

    public String toString() {
        String string = "CertReqMsg:";
        string = String.valueOf(string) + "\r\n\tcert request: " + this.certReq.toString();
        string = this.pop == null ? String.valueOf(string) + "\r\n\tno pop" : String.valueOf(string) + "\r\n\tpop: " + this.pop.toString();
        if (this.regInfo == null || this.regInfo.length == 0) {
            string = String.valueOf(string) + "\r\n\tNo registration info";
        } else {
            int n2 = 0;
            while (n2 < this.regInfo.length) {
                string = String.valueOf(string) + "\r\n\treg info[" + n2 + "]: " + this.regInfo[n2];
                ++n2;
            }
        }
        return string;
    }

    public boolean verify() throws IOException, NoSuchAlgorithmException, KeyException, SignatureException {
        if (this.pop == null) {
            throw new IOException("CertReqMsg error, pop not specified");
        }
        if (this.pop.getPOPType() == 1) {
            if (this.pop.getPOP() instanceof POPOSigningKey) {
                POPOSigningKey pOPOSigningKey = (POPOSigningKey)this.pop.getPOP();
                AlgorithmId algorithmId = pOPOSigningKey.getAlgorithmId();
                byte[] byArray = pOPOSigningKey.getSignature();
                Signature signature = null;
                try {
                    signature = Signature.getInstance(algorithmId.getName(), IBM_JCE_PROVIDER);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    try {
                        signature = Signature.getInstance(algorithmId.getName(), IBM_JCA_PROVIDER);
                    }
                    catch (NoSuchProviderException noSuchProviderException2) {
                        signature = Signature.getInstance(algorithmId.getName());
                    }
                }
                if (this.certReq.getCertTemplate().getPublicKey() == null) {
                    throw new IOException("CertReqMsg error, public key not specified");
                }
                signature.initVerify(this.certReq.getCertTemplate().getPublicKey());
                DerOutputStream derOutputStream = new DerOutputStream();
                this.certReq.encode(derOutputStream);
                byte[] byArray2 = derOutputStream.toByteArray();
                signature.update(byArray2);
                return signature.verify(byArray);
            }
            throw new IOException("CertReqMsg error, invalid pop type");
        }
        throw new IOException("CertReqMsg error, pop method not supported");
    }
}

