/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.CRMF;
import com.ibm.security.crmf.RegCtrl;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;

public final class ProtocolEncrKeyRegCtrl
extends CMPDerObject
implements RegCtrl,
Cloneable {
    private static final ObjectIdentifier oid = CRMF.id_regCtrl_protocolEncrKey_oid;
    private X509Key value;
    private byte[] encodedValue;

    public ProtocolEncrKeyRegCtrl(PublicKey publicKey) throws IOException {
        if (publicKey == null) {
            throw new IllegalArgumentException("ProtocolEncrKeyRegCtrl error, key not specified");
        }
        try {
            this.value = new X509Key();
            byte[] byArray = publicKey.getEncoded();
            this.value.decode(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("ProtocolEncrKeyRegCtrl error, invalid public key.  The key must be in X.509 format.");
        }
        this.setEncodedValue();
    }

    public ProtocolEncrKeyRegCtrl(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new ProtocolEncrKeyRegCtrl(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        DerValue derValue2 = derValue.getData().getDerValue();
        this.value = (X509Key)X509Key.parse(derValue2);
        this.setEncodedValue();
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncodedValue());
    }

    public boolean equals(ProtocolEncrKeyRegCtrl protocolEncrKeyRegCtrl) {
        DerValue derValue;
        DerValue derValue2;
        if (protocolEncrKeyRegCtrl == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            protocolEncrKeyRegCtrl.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof ProtocolEncrKeyRegCtrl) {
            return this.equals((ProtocolEncrKeyRegCtrl)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "ProtocolEncrKey";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.value.encode(derOutputStream);
            DerInputStream derInputStream = new DerInputStream(derOutputStream.toByteArray());
            return X509Key.parse(derInputStream.getDerValue());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void setEncodedValue() throws IOException {
        this.encodedValue = this.value.getEncoded();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "ProtocolEncrKeyRegCtrl:";
        string = String.valueOf(string) + "\r\nvalue: ";
        string = String.valueOf(string) + this.value.toString();
        return string;
    }
}

