/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.EntityIdentifier;
import com.ibm.security.pkcs7.RecipientIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class IssuerAndSerialNumber
extends PKCSDerObject
implements RecipientIdentifier,
EntityIdentifier,
Cloneable {
    private X500Name issuer;
    private BigInteger serialNumber;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.IssuerAndSerialNumber";
    private volatile int cachedHashVal = 0;

    public IssuerAndSerialNumber(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", (Object)der);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(byte[] der, String provider) throws IOException {
        super(der, provider);
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAndSerialNumber", der, provider);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(X500Name issuer, BigInteger serialNumber) {
        this(issuer, serialNumber, null);
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAndSerialNumber", issuer, serialNumber);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(X500Name issuer, BigInteger serialNumber, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{issuer, serialNumber, provider};
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", parms);
        }
        if (issuer == null) {
            if (debug != null) {
                debug.text(16384L, className, "IssuerAndSerialNumber", "issuer not specified.");
            }
            throw new IllegalArgumentException("issuer not specified.");
        }
        if (serialNumber == null) {
            if (debug != null) {
                debug.text(16384L, className, "IssuerAndSerialNumber", "serialNumber not specified.");
            }
            throw new IllegalArgumentException("serialNumber not specified.");
        }
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(X509Certificate cert) throws IOException {
        this(cert, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", cert);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(X509Certificate cert, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAndSerialNumber", cert, provider);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "IssuerAndSerialNumber", "Certificate not specified.");
            }
            throw new IllegalArgumentException("Certificate not specified.");
        }
        if (!(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.text(16384L, className, "IssuerAndSerialNumber", "Certificate type " + cert.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
            }
            throw new IllegalArgumentException("Certificate type " + cert.getClass().getName() + "not supported.  Only instances of java.security.cert.X509Certificate are supported.");
        }
        Principal princ = cert.getIssuerDN();
        this.issuer = new X500Name(princ.getName());
        this.serialNumber = cert.getSerialNumber();
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            debug.entry(16384L, className, "IssuerAndSerialNumber", filename, new Boolean(base64));
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    public IssuerAndSerialNumber(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", parms);
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuerAndSerialNumber", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        this.issuer.encode(bytes);
        bytes.putInteger(this.serialNumber);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "IssuerAndSerialNumber");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "IssuerAndSerialNumber parsing error");
            }
            throw new IOException("IssuerAndSerialNumber parsing error");
        }
        DerValue der = encoding.getData().getDerValue();
        this.issuer = new X500Name(der);
        this.serialNumber = encoding.getData().getInteger();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof IssuerAndSerialNumber)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((IssuerAndSerialNumber)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public String toString() {
        String out = "";
        out = out + "\tissuer: " + this.issuer;
        out = out + "\r\n\tserialNumber: " + this.serialNumber;
        return out;
    }

    public X500Name getIssuer() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuer");
        }
        if (this.issuer == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIssuer", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIssuer", new X500Name(this.issuer.toString()));
        }
        return new X500Name(this.issuer.toString());
    }

    public BigInteger getSerialNumber() {
        if (debug != null) {
            debug.entry(16384L, className, "getSerialNumber");
            debug.exit(16384L, (Object)className, "getSerialNumber", this.serialNumber);
        }
        return this.serialNumber;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            IssuerAndSerialNumber result = new IssuerAndSerialNumber(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }
}

