/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.pkcs12.PFX;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.cert.Certificate;

public class parsePFX {
    public static void main(String[] argv) throws Throwable {
        int i2 = 0;
        String pfxFile = null;
        char[] pwd = null;
        String certPrefix = null;
        String keyPrefix = null;
        if (argv.length < 8) {
            parsePFX.usage();
            System.exit(1);
        }
        try {
            EncryptedPrivateKeyInfo[] sKeys;
            PrivateKeyInfo[] keys;
            while (i2 < argv.length) {
                String arg = argv[i2];
                if (arg.equals("-f")) {
                    if (pfxFile != null) {
                        System.out.println("ERROR: PFX file has already been specified.");
                        parsePFX.usage();
                        System.exit(1);
                    }
                    pfxFile = argv[++i2];
                } else if (arg.equals("-p")) {
                    if (pwd != null) {
                        System.out.println("ERROR: Password has already been specified.");
                        parsePFX.usage();
                        System.exit(1);
                    }
                    pwd = argv[++i2].toCharArray();
                } else if (arg.equals("-k")) {
                    if (keyPrefix != null) {
                        System.out.println("ERROR: Key file has already been specified.");
                        parsePFX.usage();
                        System.exit(1);
                    }
                    keyPrefix = argv[++i2];
                } else if (arg.equals("-c")) {
                    if (certPrefix != null) {
                        System.out.println("ERROR: Certificate file has already been specified.");
                        parsePFX.usage();
                        System.exit(1);
                    }
                    certPrefix = argv[++i2];
                }
                ++i2;
            }
            if (pfxFile == null) {
                System.out.println("ERROR: PFX file must be specified.");
                parsePFX.usage();
                System.exit(1);
            }
            if (pwd == null) {
                System.out.println("ERROR: Password must be specified.");
                parsePFX.usage();
                System.exit(1);
            }
            if (certPrefix == null) {
                System.out.println("ERROR: Certificate file must be specified.");
                parsePFX.usage();
                System.exit(1);
            }
            if (keyPrefix == null) {
                System.out.println("ERROR: Key file must be specified.");
                parsePFX.usage();
                System.exit(1);
            }
            FileInputStream fis = new FileInputStream(pfxFile);
            byte[] data = new byte[fis.available()];
            fis.read(data);
            fis.close();
            PFX pfx = new PFX(data);
            System.out.println("PFX constructed from " + pfxFile);
            System.out.println(pfx.toString());
            System.out.println("Verifying MAC with input password.");
            if (pfx.verifyMac(pwd)) {
                System.out.println("MAC is verified.");
            } else {
                System.out.println("MAC is not verified.");
                System.exit(2);
            }
            String filename = null;
            FileOutputStream fos = null;
            Certificate[] certs = pfx.getCertificates(pwd);
            if (certs != null && certs.length > 0) {
                System.out.println("Found " + certs.length + " certificates.");
                for (i2 = 0; i2 < certs.length; ++i2) {
                    filename = certPrefix + i2 + ".cer";
                    System.out.println("Writing certificate to " + filename);
                    byte[] certBytes = certs[i2].getEncoded();
                    fos = new FileOutputStream(filename);
                    fos.write(certBytes);
                    fos.close();
                }
            } else {
                System.out.println("Found no certificates.");
            }
            if ((keys = pfx.getPrivateKeys(pwd)) != null && keys.length > 0) {
                System.out.println("Found " + keys.length + " private keys.");
                for (i2 = 0; i2 < keys.length; ++i2) {
                    filename = keyPrefix + i2 + ".pri";
                    System.out.println("Writing private key to " + filename);
                    keys[i2].write(filename, false);
                }
            } else {
                System.out.println("Found no private keys.");
            }
            if ((sKeys = pfx.getShroudedKeys(pwd)) != null && sKeys.length > 0) {
                System.out.println("Found " + sKeys.length + " shrouded keys.");
                for (i2 = 0; i2 < sKeys.length; ++i2) {
                    filename = keyPrefix + i2 + ".epri";
                    System.out.println("Writing shrouded key to " + filename);
                    sKeys[i2].write(filename, false);
                    System.out.println("Converting shrouded key to private key.");
                    filename = keyPrefix + i2 + ".pri";
                    System.out.println("Writing decrypted private key to " + filename);
                    byte[] priEnc = sKeys[i2].decrypt(pwd);
                    PrivateKeyInfo pki = new PrivateKeyInfo(priEnc);
                    pki.write(filename, false);
                }
            } else {
                System.out.println("Found no shrouded keys.");
            }
        }
        catch (Exception e2) {
            System.out.println("ERROR: Caught exception.");
            e2.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage: parsePFX -f PFXfile -p password -c certfile -k keyfile");
        System.out.println("where  PFXfile is the PFX file");
        System.out.println("       password is the password used to protect the PFX");
        System.out.println("       certfile will hold any parsed certificates (.cer extension)");
        System.out.println("       keyfile will hold any parsed keys (.pri extension for private keys,");
        System.out.println("           .epri extension for shrouded keys)");
    }
}

