/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import com.ibm.security.util.ByteArrayLexOrder;
import com.ibm.security.util.ByteArrayTagOrder;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.UTFUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DerOutputStream(int size) {
        super(size);
    }

    public DerOutputStream() {
    }

    public void write(byte tag, byte[] buf) throws IOException {
        this.write(tag);
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void write(byte tag, DerOutputStream out) throws IOException {
        this.write(tag);
        this.putLength(out.count);
        this.write(out.buf, 0, out.count);
    }

    public void writeImplicit(byte tag, DerOutputStream value) throws IOException {
        this.write(tag);
        this.write(value.buf, 1, value.count - 1);
    }

    public void putDerValue(DerValue val) throws IOException {
        val.encode(this);
    }

    public void putBoolean(boolean val) throws IOException {
        this.write(1);
        this.putLength(1);
        if (val) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putSignedInt(int i2) throws IOException {
        int j2;
        byte[] places = new byte[4];
        int count = 0;
        places[3] = (byte)(i2 & 0xFF);
        places[2] = (byte)((i2 & 0xFF00) >>> 8);
        places[1] = (byte)((i2 & 0xFF0000) >>> 16);
        places[0] = (byte)((i2 & 0xFF000000) >>> 24);
        if (places[0] != 0) {
            for (j2 = 0; j2 < 3 && places[j2] == -1 && (places[j2 + 1] & 0xFFFFFF80) == -128; ++j2) {
                ++count;
            }
        } else if (places[0] == 0) {
            for (j2 = 0; j2 < 3 && places[j2] == 0 && (places[j2 + 1] & 0xFFFFFF80) == 0; ++j2) {
                ++count;
            }
        }
        byte[] buf = new byte[4 - count];
        for (j2 = 0; j2 < 4 - count; ++j2) {
            buf[j2] = places[j2 + count];
        }
        this.write(2);
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void putInteger(BigInteger i2) throws IOException {
        this.write(2);
        this.putBigInteger(i2);
    }

    public void putEnumerated(BigInteger i2) throws IOException {
        this.write(10);
        this.putBigInteger(i2);
    }

    private void putBigInteger(BigInteger i2) throws IOException {
        byte[] buf = i2.toByteArray();
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void putInteger(Integer i2) throws IOException {
        this.putInteger((int)i2);
    }

    public void putInteger(int i2) throws IOException {
        this.write(2);
        this.putIntegerContents(i2);
    }

    private void putIntegerContents(int i2) throws IOException {
        int j2;
        byte[] bytes = new byte[4];
        int start = 0;
        bytes[3] = (byte)(i2 & 0xFF);
        bytes[2] = (byte)((i2 & 0xFF00) >>> 8);
        bytes[1] = (byte)((i2 & 0xFF0000) >>> 16);
        bytes[0] = (byte)((i2 & 0xFF000000) >>> 24);
        if (bytes[0] == 255) {
            for (j2 = 0; j2 < 3 && bytes[j2] == 255 && (bytes[j2 + 1] & 0x80) == 128; ++j2) {
                ++start;
            }
        } else if (bytes[0] == 0) {
            for (j2 = 0; j2 < 3 && bytes[j2] == 0 && (bytes[j2 + 1] & 0x80) == 0; ++j2) {
                ++start;
            }
        }
        this.putLength(4 - start);
        for (int k2 = start; k2 < 4; ++k2) {
            this.write(bytes[k2]);
        }
    }

    public void putBitString(byte[] bits) throws IOException {
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(0);
        this.write(bits);
    }

    public void putUnalignedBitString(BitArray ba) throws IOException {
        byte[] bits = ba.toByteArray();
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(bits.length * 8 - ba.length());
        this.write(bits);
    }

    public void putOctetString(byte[] octets) throws IOException {
        this.write((byte)4, octets);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier oid) throws IOException {
        oid.encode(this);
    }

    public void putSequence(DerValue[] seq) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        for (int i2 = 0; i2 < seq.length; ++i2) {
            seq[i2].encode(bytes);
        }
        this.write((byte)48, bytes);
    }

    public void putSet(DerValue[] set) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        for (int i2 = 0; i2 < set.length; ++i2) {
            set[i2].encode(bytes);
        }
        this.write((byte)49, bytes);
    }

    public void putOrderedSetOf(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, (Comparator)lexOrder);
    }

    public void putOrderedSet(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, (Comparator)tagOrder);
    }

    private void putOrderedSet(byte tag, DerEncoder[] set, Comparator order) throws IOException {
        DerOutputStream[] streams = new DerOutputStream[set.length];
        for (int i2 = 0; i2 < set.length; ++i2) {
            streams[i2] = new DerOutputStream();
            set[i2].derEncode(streams[i2]);
        }
        byte[][] bufs = new byte[streams.length][];
        for (int i3 = 0; i3 < streams.length; ++i3) {
            bufs[i3] = streams[i3].toByteArray();
        }
        Arrays.sort(bufs, order);
        DerOutputStream bytes = new DerOutputStream();
        for (int i4 = 0; i4 < streams.length; ++i4) {
            bytes.write(bufs[i4]);
        }
        this.write(tag, bytes);
    }

    public void putOrderedSetOf(byte tag, DerValue[] set) throws IOException {
        this.putOrderedSet(tag, set, (Comparator)lexOrder);
    }

    private void putOrderedSet(byte tag, DerValue[] set, Comparator order) throws IOException {
        byte[][] bufs = new byte[set.length][];
        for (int i2 = 0; i2 < set.length; ++i2) {
            bufs[i2] = set[i2].toByteArray();
        }
        Arrays.sort(bufs, order);
        DerOutputStream bytes = new DerOutputStream();
        for (int i3 = 0; i3 < set.length; ++i3) {
            bytes.write(bufs[i3]);
        }
        this.write(tag, bytes);
    }

    public void putPrintableString(String s2) throws IOException {
        this.write(19);
        this.putLength(s2.length());
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            this.write((byte)s2.charAt(i2));
        }
    }

    public void putPrintableString(char[] s2) throws IOException {
        this.write(19);
        this.putLength(s2.length);
        for (int i2 = 0; i2 < s2.length; ++i2) {
            this.write((byte)s2[i2]);
        }
    }

    public void putVisibleString(String s2) throws IOException {
        this.write(26);
        this.putLength(s2.length());
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            this.write((byte)s2.charAt(i2));
        }
    }

    public void putIA5String(String s2) throws IOException {
        this.write(22);
        this.putLength(s2.length());
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            this.write((byte)s2.charAt(i2));
        }
    }

    public void putGeneralString(String s2) throws IOException {
        this.write(27);
        this.putLength(s2.length());
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            this.write((byte)s2.charAt(i2));
        }
    }

    public void putBMPString(byte[] bmp) throws IOException {
        this.write(30);
        this.putLength(bmp.length);
        this.write(bmp);
    }

    public void putUTF8String(String s2) throws IOException {
        this.write(12);
        byte[] bytes = UTFUtils.toUTF(s2);
        this.putLength(bytes.length);
        this.write(bytes);
    }

    public void putUniverString(String s2) throws IOException {
        this.write(28);
        byte[] bytes = UTFUtils.toUniv(s2);
        this.putLength(bytes.length);
        this.write(bytes);
    }

    public void putBMPString(String str) throws IOException {
        this.write(30);
        if (str == null) {
            this.putLength(0);
        } else {
            this.putLength(str.length() * 2);
        }
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char ch = str.charAt(i2);
            this.write((byte)(ch >>> 8));
            this.write((byte)(ch & 0xFF));
        }
    }

    public void putUTCTime(Date d2) throws IOException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        String pattern = "yyMMddHHmmss'Z'";
        Locale locale = new Locale("en", "US");
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
        sdf.setTimeZone(tz);
        byte[] utc = null;
        try {
            utc = sdf.format(d2).getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e2) {
            utc = sdf.format(d2).getBytes();
        }
        this.write(23);
        this.putLength(utc.length);
        this.write(utc);
    }

    public void putGeneralizedTime(Date d2) throws IOException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        String pattern = "yyyyMMddHHmmss'Z'";
        Locale locale = new Locale("en", "US");
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
        sdf.setTimeZone(tz);
        byte[] gt = null;
        try {
            gt = sdf.format(d2).getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e2) {
            gt = sdf.format(d2).getBytes();
        }
        this.write(24);
        this.putLength(gt.length);
        this.write(gt);
    }

    public void putLength(int len) throws IOException {
        if (len < 128) {
            this.write((byte)len);
        } else if (len < 256) {
            this.write(-127);
            this.write((byte)len);
        } else if (len < 65536) {
            this.write(-126);
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else if (len < 0x1000000) {
            this.write(-125);
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else {
            this.write(-124);
            this.write((byte)(len >> 24));
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        }
    }

    public void putTag(byte tagClass, boolean form, byte val) {
        byte tag = (byte)(tagClass | val);
        if (form) {
            tag = (byte)(tag | 0x20);
        }
        this.write(tag);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }

    public void putNamedBitString(BitArray ba) throws IOException {
        byte[] bits = ba.toByteArray();
        int count = ba.length();
        while (--count >= 0 && !ba.get(count)) {
        }
        this.write(3);
        if (count++ < 0) {
            this.putLength(1);
            this.write(0);
        } else {
            int len = (count + 7) / 8;
            this.putLength(len + 1);
            this.write(len * 8 - count);
            this.write(bits, 0, len);
        }
    }
}

