/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.UniqueIdentity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public final class CertificateSubjectUniqueIdentity
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.subjectID";
    public static final String NAME = "subjectID";
    public static final String ID = "id";
    private UniqueIdentity id;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateSubjectUniqueIdentity";

    public CertificateSubjectUniqueIdentity(UniqueIdentity id) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateSubjectUniqueIdentity", id);
            debug.exit(16384L, className, "CertificateSubjectUniqueIdentity");
        }
        this.id = id;
    }

    public CertificateSubjectUniqueIdentity(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateSubjectUniqueIdentity", in);
        }
        this.id = new UniqueIdentity(in);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateSubjectUniqueIdentity");
        }
    }

    public CertificateSubjectUniqueIdentity(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateSubjectUniqueIdentity", in);
        }
        DerValue val = new DerValue(in);
        this.id = new UniqueIdentity(val);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateSubjectUniqueIdentity");
        }
    }

    public CertificateSubjectUniqueIdentity(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateSubjectUniqueIdentity", val);
        }
        this.id = new UniqueIdentity(val);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateSubjectUniqueIdentity");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.id == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", this.id.toString());
        }
        return this.id.toString();
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        this.id.encode(tmp, DerValue.createTag((byte)-128, false, (byte)2));
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof UniqueIdentity)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type UniqueIdentity.");
            }
            throw new IOException("Attribute must be of type UniqueIdentity.");
        }
        if (!name.equalsIgnoreCase(ID)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
        }
        this.id = (UniqueIdentity)obj;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(ID)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", this.id);
            }
            return this.id;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(ID)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateSubjectUniqueIdentity.");
        }
        this.id = null;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(ID);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

