/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.RDN;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public final class X500Name
implements Principal,
GeneralNameInterface {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X500Name";
    private String dn = null;
    private String rfc1779Dn;
    private String rfc2253Dn;
    private String canonicalDn;
    private RDN[] names;
    private X500Principal x500Principal;
    private byte[] encoded;
    private volatile List<AVA> allAvaList;
    private static final Map internedOIDs = new HashMap();
    private static final int[] emailAddress_data = new int[]{1, 2, 840, 113549, 1, 9, 1};
    private static final int[] postalCode_data = new int[]{2, 5, 4, 17};
    private static final int[] serialNumber_data = new int[]{2, 5, 4, 5};
    private static final int[] commonName_data = new int[]{2, 5, 4, 3};
    private static final int[] countryName_data = new int[]{2, 5, 4, 6};
    private static final int[] localityName_data = new int[]{2, 5, 4, 7};
    private static final int[] stateName_data = new int[]{2, 5, 4, 8};
    private static final int[] streetAddress_data = new int[]{2, 5, 4, 9};
    private static final int[] orgName_data = new int[]{2, 5, 4, 10};
    private static final int[] orgUnitName_data = new int[]{2, 5, 4, 11};
    private static final int[] title_data = new int[]{2, 5, 4, 12};
    private static final int[] surname_data = new int[]{2, 5, 4, 4};
    private static final int[] givenname_data = new int[]{2, 5, 4, 42};
    private static final int[] initials_data = new int[]{2, 5, 4, 43};
    private static final int[] pseudonym_data = new int[]{2, 5, 4, 65};
    private static final int[] userid_data = new int[]{0, 9, 2342, 19200300, 100, 1, 1};
    private static final int[] generationQualifier_data = new int[]{2, 5, 4, 44};
    private static final int[] domainComponent_data = new int[]{0, 9, 2342, 19200300, 100, 1, 25};
    private static final int[] dnqualifier_data = new int[]{2, 5, 4, 46};
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    public static ObjectIdentifier emailAddress_oid;
    public static ObjectIdentifier postalCode_oid;
    public static ObjectIdentifier serialNumber_oid;
    public static ObjectIdentifier commonName_oid;
    public static ObjectIdentifier countryName_oid;
    public static ObjectIdentifier localityName_oid;
    public static ObjectIdentifier orgName_oid;
    public static ObjectIdentifier orgUnitName_oid;
    public static ObjectIdentifier stateName_oid;
    public static ObjectIdentifier streetAddress_oid;
    public static ObjectIdentifier title_oid;
    public static ObjectIdentifier surName_oid;
    public static ObjectIdentifier givenName_oid;
    public static ObjectIdentifier initials_oid;
    public static ObjectIdentifier ipAddress_oid;
    public static ObjectIdentifier dnQualifier_oid;
    public static ObjectIdentifier domainComponent_oid;
    public static ObjectIdentifier pseudonym_oid;
    public static ObjectIdentifier generationQualifier_oid;
    public static ObjectIdentifier userid_oid;

    public X500Name(String dname) throws IOException {
        this(dname, Collections.EMPTY_MAP);
    }

    public X500Name(String dname, Map<String, String> keywordMap) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{dname, keywordMap};
            debug.entry(16384L, (Object)className, "X500Name", parms);
        }
        this.parseDN(dname, keywordMap);
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String country) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{commonName, organizationUnit, organizationName, country};
            debug.entry(16384L, (Object)className, "X500Name", parms);
        }
        this.names = new RDN[4];
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(commonName_oid, new DerValue(commonName));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgUnitName_oid, new DerValue(organizationUnit));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(orgName_oid, new DerValue(organizationName));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(country));
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String country, String emailAddress) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{commonName, organizationUnit, organizationName, country, emailAddress};
            debug.entry(16384L, (Object)className, "X500Name", parms);
        }
        this.names = new RDN[5];
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(commonName_oid, new DerValue(commonName));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgUnitName_oid, new DerValue(organizationUnit));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgName_oid, new DerValue(organizationName));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(countryName_oid, new DerValue(country));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(emailAddress_oid, new DerValue(22, emailAddress));
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String localityName, String stateName, String country) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{commonName, organizationUnit, organizationName, localityName, stateName, country};
            debug.entry(16384L, (Object)className, "X500Name", parms);
        }
        this.names = new RDN[6];
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(commonName_oid, new DerValue(commonName));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgUnitName_oid, new DerValue(organizationUnit));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgName_oid, new DerValue(organizationName));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(localityName_oid, new DerValue(localityName));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(stateName_oid, new DerValue(stateName));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(country));
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String localityName, String stateName, String postalCode, String country) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{commonName, organizationUnit, organizationName, localityName, stateName, postalCode, country};
            debug.entry(16384L, (Object)className, "X500Name", parms);
        }
        this.names = new RDN[7];
        this.names[6] = new RDN(1);
        this.names[6].assertion[0] = new AVA(commonName_oid, new DerValue(commonName));
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(orgUnitName_oid, new DerValue(organizationUnit));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgName_oid, new DerValue(organizationName));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(localityName_oid, new DerValue(localityName));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(stateName_oid, new DerValue(stateName));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(postalCode_oid, new DerValue(postalCode));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(country));
    }

    public X500Name(DerValue value) throws IOException {
        this(new DerInputStream(value.toByteArray()));
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X500Name", value);
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(DerInputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X500Name", in);
        }
        this.parseDER(in);
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    public X500Name(byte[] name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X500Name", (Object)name);
        }
        DerInputStream in = new DerInputStream(name);
        this.parseDER(in);
        if (debug != null) {
            debug.exit(16384L, className, "X500Name");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", obj);
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof X500Name)) {
            return false;
        }
        X500Name other = (X500Name)obj;
        if (this.canonicalDn != null && other.canonicalDn != null) {
            if (debug != null) {
                debug.entry(16384L, className, "equals: canon", this.canonicalDn, other.canonicalDn);
            }
            return this.canonicalDn.equals(other.canonicalDn);
        }
        int n2 = this.names.length;
        if (n2 != other.names.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            RDN r1 = this.names[i2];
            RDN r2 = other.names[i2];
            if (debug != null) {
                debug.entry(16384L, className, "equals: rdn lengths", r1, r2);
            }
            if (r1.assertion.length == r2.assertion.length) continue;
            return false;
        }
        String thisCanonical = this.getRFC2253CanonicalName();
        String otherCanonical = other.getRFC2253CanonicalName();
        if (debug != null) {
            debug.entry(16384L, className, "equals: getCanon", thisCanonical, otherCanonical);
        }
        return thisCanonical.equals(otherCanonical);
    }

    List<AVA> allAvas() {
        List<AVA> list = this.allAvaList;
        if (list == null) {
            list = new ArrayList<AVA>();
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                list.addAll(this.names[i2].avas());
            }
        }
        return list;
    }

    boolean isEmpty() {
        int n2 = this.names.length;
        if (n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.names[i2].assertion.length == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        int retval = 0;
        int k2 = 1;
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            retval += this.names[i2].hashCode() * k2++;
        }
        if (debug != null) {
            debug.exit(16384L, className, "hashCode");
        }
        return retval;
    }

    public boolean equals(X500Name other) {
        if (this.canonicalDn != null && other.canonicalDn != null) {
            if (debug != null) {
                debug.entry(16384L, className, "equals: canon", this.canonicalDn, other.canonicalDn);
            }
            return this.canonicalDn.equals(other.canonicalDn);
        }
        int n2 = this.names.length;
        if (n2 != other.names.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            RDN r1 = this.names[i2];
            RDN r2 = other.names[i2];
            if (debug != null) {
                debug.entry(16384L, className, "equals: rdn lengths", r1, r2);
            }
            if (r1.assertion.length == r2.assertion.length) continue;
            return false;
        }
        String thisCanonical = this.getRFC2253CanonicalName();
        String otherCanonical = other.getRFC2253CanonicalName();
        if (debug != null) {
            debug.entry(16384L, className, "equals: getCanon", thisCanonical, otherCanonical);
        }
        return thisCanonical.equals(otherCanonical);
    }

    @Override
    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 4);
        }
        return 4;
    }

    public String getCountry() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getCountry");
        }
        DerValue attr = this.findAttribute(countryName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCountry", this.getString(attr));
        }
        return this.getString(attr);
    }

    public String getOrganization() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOrganization");
        }
        DerValue attr = this.findAttribute(orgName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOrganization", this.getString(attr));
        }
        return this.getString(attr);
    }

    public String getOrganizationalUnit() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOrganizationalUnit");
        }
        DerValue attr = this.findAttribute(orgUnitName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOrganizationalUnit", this.getString(attr));
        }
        return this.getString(attr);
    }

    public String getCommonName() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getCommonName");
        }
        DerValue attr = this.findAttribute(commonName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCommonName", this.getString(attr));
        }
        return this.getString(attr);
    }

    public String getLocality() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getLocality");
        }
        DerValue attr = this.findAttribute(localityName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getLocality", this.getString(attr));
        }
        return this.getString(attr);
    }

    public String getState() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getState");
        }
        DerValue attr = this.findAttribute(stateName_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getState", this.getString(attr));
        }
        return this.getString(attr);
    }

    public String getEmail() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getEmail");
        }
        DerValue attr = this.findAttribute(emailAddress_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEmail", this.getString(attr));
        }
        return this.getString(attr);
    }

    public String getPostalCode() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getPostalCode");
        }
        DerValue attr = this.findAttribute(postalCode_oid);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPostalCode", this.getString(attr));
        }
        return this.getString(attr);
    }

    @Override
    public String toString() {
        if (this.dn == null) {
            this.generateDN();
        }
        return this.dn;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public void emit(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "emit", out);
        }
        this.encode(out);
        if (debug != null) {
            debug.exit(16384L, className, "emit");
        }
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            this.names[i2].encode(tmp);
        }
        out.write((byte)48, tmp);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    byte[] getEncodedInternal() throws IOException {
        if (this.encoded == null) {
            DerOutputStream out = new DerOutputStream();
            DerOutputStream tmp = new DerOutputStream();
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                this.names[i2].encode(tmp);
            }
            out.write((byte)48, tmp);
            this.encoded = out.toByteArray();
        }
        return this.encoded;
    }

    public byte[] getEncoded() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        byte[] result = (byte[])this.getEncodedInternal().clone();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getEncoded", (Object)result);
        }
        return result;
    }

    public int size() {
        return this.names.length;
    }

    public RDN getRDN(int index) {
        return this.names[index];
    }

    public X500Name getParentDn() {
        RDN[] result = new RDN[this.names.length - 1];
        System.arraycopy(this.names, 0, result, 0, this.names.length - 1);
        return new X500Name(result);
    }

    public String getRFC1779Name() {
        return this.getRFC1779Name(Collections.EMPTY_MAP);
    }

    public String getRFC1779Name(Map<String, String> oidMap) throws IllegalArgumentException {
        if (oidMap.isEmpty()) {
            if (this.rfc1779Dn != null) {
                return this.rfc1779Dn;
            }
            this.rfc1779Dn = this.generateRFC1779DN(oidMap);
            return this.rfc1779Dn;
        }
        return this.generateRFC1779DN(oidMap);
    }

    public String getRFC2253Name() {
        return this.getRFC2253Name(Collections.EMPTY_MAP);
    }

    public String getRFC2253Name(Map<String, String> oidMap) {
        if (oidMap.isEmpty()) {
            if (this.rfc2253Dn != null) {
                return this.rfc2253Dn;
            }
            this.rfc2253Dn = this.generateRFC2253DN(oidMap);
            return this.rfc2253Dn;
        }
        return this.generateRFC2253DN(oidMap);
    }

    private String generateRFC2253DN(Map<String, String> oidMap) {
        if (this.names.length == 0) {
            return "";
        }
        StringBuilder fullname = new StringBuilder(48);
        for (int i2 = this.names.length - 1; i2 >= 0; --i2) {
            if (i2 < this.names.length - 1) {
                fullname.append(',');
            }
            fullname.append(this.names[i2].toRFC2253String(oidMap));
        }
        return fullname.toString();
    }

    public String getRFC2253CanonicalName() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getRFC2254CanonName()", this.canonicalDn);
        }
        if (this.canonicalDn != null) {
            return this.canonicalDn;
        }
        if (this.names.length == 0) {
            this.canonicalDn = "";
            if (debug != null) {
                debug.entry(16384L, (Object)className, "getRFC2254CanonName()", "canonicalDn == null");
            }
            return this.canonicalDn;
        }
        StringBuilder fullname = new StringBuilder(48);
        for (int i2 = this.names.length - 1; i2 >= 0; --i2) {
            if (i2 < this.names.length - 1) {
                fullname.append(',');
            }
            fullname.append(this.names[i2].toRFC2253String(true));
        }
        this.canonicalDn = fullname.toString();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getRFC2254CanonName() new Canon", this.canonicalDn);
        }
        return this.canonicalDn;
    }

    private String generateRFC1779DN(Map<String, String> oidMap) {
        if (this.names.length == 1) {
            return this.names[0].toRFC1779String(oidMap);
        }
        StringBuilder sb2 = new StringBuilder(48);
        if (this.names != null) {
            for (int i2 = this.names.length - 1; i2 >= 0; --i2) {
                if (i2 != this.names.length - 1) {
                    sb2.append(", ");
                }
                sb2.append(this.names[i2].toRFC1779String());
            }
        }
        return sb2.toString();
    }

    public boolean isAbove(X500Name other) {
        while (this.size() < other.size()) {
            other = other.getParentDn();
        }
        return this.equals(other);
    }

    public X500Name(RDN[] rdns) {
        if (rdns == null) {
            this.names = new RDN[0];
        } else {
            this.names = (RDN[])rdns.clone();
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                if (this.names[i2] != null) continue;
                throw new NullPointerException("RDN[] contains null");
            }
        }
    }

    private void parseDN(String input, Map<String, String> keywordMap) throws IOException {
        RDN rdn;
        String rdnString;
        if (input == null || input.length() == 0) {
            this.names = new RDN[0];
            return;
        }
        ArrayList<RDN> dnVector = new ArrayList<RDN>();
        int dnOffset = 0;
        int quoteCount = 0;
        String dnString = input;
        int searchOffset = 0;
        int nextComma = dnString.indexOf(44);
        int nextSemiColon = dnString.indexOf(59);
        while (nextComma >= 0 || nextSemiColon >= 0) {
            int rdnEnd = nextSemiColon < 0 ? nextComma : (nextComma < 0 ? nextSemiColon : Math.min(nextComma, nextSemiColon));
            if (rdnEnd >= 0 && (quoteCount += X500Name.countQuotes(dnString, searchOffset, rdnEnd)) != 1 && !X500Name.escaped(rdnEnd, searchOffset, dnString)) {
                rdnString = dnString.substring(dnOffset, rdnEnd);
                rdn = new RDN(rdnString, keywordMap);
                dnVector.add(rdn);
                dnOffset = rdnEnd + 1;
                quoteCount = 0;
            }
            searchOffset = rdnEnd + 1;
            nextComma = dnString.indexOf(44, searchOffset);
            nextSemiColon = dnString.indexOf(59, searchOffset);
        }
        rdnString = dnString.substring(dnOffset);
        rdn = new RDN(rdnString, keywordMap);
        dnVector.add(rdn);
        Collections.reverse(dnVector);
        this.names = dnVector.toArray(new RDN[dnVector.size()]);
    }

    static int countQuotes(String string, int from, int to) {
        int count = 0;
        for (int i2 = from; i2 < to; ++i2) {
            if (string.charAt(i2) != '\"') continue;
            ++count;
        }
        return count;
    }

    private static boolean escaped(int rdnEnd, int searchOffset, String dnString) {
        if (rdnEnd == 1 && dnString.charAt(rdnEnd - 1) == '\\') {
            return true;
        }
        if (rdnEnd > 1 && dnString.charAt(rdnEnd - 1) == '\\' && dnString.charAt(rdnEnd - 2) != '\\') {
            return true;
        }
        if (rdnEnd > 1 && dnString.charAt(rdnEnd - 1) == '\\' && dnString.charAt(rdnEnd - 2) == '\\') {
            int count = 0;
            --rdnEnd;
            while (rdnEnd >= searchOffset) {
                if (dnString.charAt(rdnEnd) == '\\') {
                    ++count;
                }
                --rdnEnd;
            }
            return count % 2 != 0;
        }
        return false;
    }

    private void generateDN() {
        if (this.names.length == 1) {
            this.dn = this.names[0].toString();
            return;
        }
        StringBuilder sb2 = new StringBuilder(48);
        for (int i2 = this.names.length - 1; i2 >= 0; --i2) {
            if (i2 != this.names.length - 1) {
                sb2.append(", ");
            }
            sb2.append(this.names[i2].toString());
        }
        this.dn = sb2.toString();
    }

    private DerValue findAttribute(ObjectIdentifier attribute) {
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            DerValue retval = this.names[i2].findAttribute(attribute);
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public DerValue findMostSpecificAttribute(ObjectIdentifier attribute) {
        for (int i2 = this.names.length - 1; i2 >= 0; --i2) {
            DerValue value = this.names[i2].findAttribute(attribute);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private void parseDER(DerInputStream in) throws IOException {
        DerValue[] nameseq = null;
        byte[] derBytes = in.toByteArray();
        try {
            nameseq = in.getSequence(5);
        }
        catch (IOException ioe) {
            if (derBytes == null) {
                nameseq = null;
            }
            DerValue derVal = new DerValue(48, derBytes);
            derBytes = derVal.toByteArray();
            nameseq = new DerInputStream(derBytes).getSequence(5);
        }
        if (nameseq == null) {
            this.names = new RDN[0];
        } else {
            this.names = new RDN[nameseq.length];
            for (int i2 = 0; i2 < nameseq.length; ++i2) {
                this.names[i2] = new RDN(nameseq[i2]);
            }
        }
    }

    private String getString(DerValue attribute) throws IOException {
        if (attribute == null) {
            return null;
        }
        String value = attribute.getAsString();
        if (value == null) {
            throw new IOException("not a DER string encoding, " + attribute.getTag());
        }
        return value;
    }

    static ObjectIdentifier intern(ObjectIdentifier oid) {
        if (oid.equals(commonName_oid)) {
            return commonName_oid;
        }
        if (oid.equals(countryName_oid)) {
            return countryName_oid;
        }
        if (oid.equals(localityName_oid)) {
            return localityName_oid;
        }
        if (oid.equals(stateName_oid)) {
            return stateName_oid;
        }
        if (oid.equals(streetAddress_oid)) {
            return streetAddress_oid;
        }
        if (oid.equals(orgName_oid)) {
            return orgName_oid;
        }
        if (oid.equals(orgUnitName_oid)) {
            return orgUnitName_oid;
        }
        if (oid.equals(title_oid)) {
            return title_oid;
        }
        if (oid.equals(ipAddress_oid)) {
            return ipAddress_oid;
        }
        if (oid.equals(emailAddress_oid)) {
            return emailAddress_oid;
        }
        if (oid.equals(serialNumber_oid)) {
            return serialNumber_oid;
        }
        if (oid.equals(domainComponent_oid)) {
            return domainComponent_oid;
        }
        if (oid.equals(postalCode_oid)) {
            return postalCode_oid;
        }
        if (oid.equals(dnQualifier_oid)) {
            return dnQualifier_oid;
        }
        if (oid.equals(pseudonym_oid)) {
            return pseudonym_oid;
        }
        if (oid.equals(generationQualifier_oid)) {
            return generationQualifier_oid;
        }
        if (oid.equals(surName_oid)) {
            return surName_oid;
        }
        if (oid.equals(initials_oid)) {
            return initials_oid;
        }
        if (oid.equals(givenName_oid)) {
            return givenName_oid;
        }
        return oid;
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        X500Name inputX500;
        int constraintType = inputName == null ? -1 : (inputName.getType() != 4 ? -1 : ((inputX500 = (X500Name)inputName).equals(this) ? 0 : (inputX500.names.length == 0 ? 2 : (this.names.length == 0 ? 1 : (inputX500.isWithinSubtree(this) ? 1 : (this.isWithinSubtree(inputX500) ? 2 : 3))))));
        return constraintType;
    }

    private boolean isWithinSubtree(X500Name other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.names.length == 0) {
            return true;
        }
        if (this.names.length == 0) {
            return false;
        }
        if (this.names.length < other.names.length) {
            return false;
        }
        for (int i2 = 0; i2 < other.names.length; ++i2) {
            if (this.names[i2].equals(other.names[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        return this.names.length;
    }

    static {
        try {
            emailAddress_oid = X500Name.intern(ObjectIdentifier.newInternal(emailAddress_data));
            postalCode_oid = X500Name.intern(ObjectIdentifier.newInternal(postalCode_data));
            serialNumber_oid = X500Name.intern(ObjectIdentifier.newInternal(serialNumber_data));
            commonName_oid = X500Name.intern(ObjectIdentifier.newInternal(commonName_data));
            countryName_oid = X500Name.intern(ObjectIdentifier.newInternal(countryName_data));
            localityName_oid = X500Name.intern(ObjectIdentifier.newInternal(localityName_data));
            orgName_oid = X500Name.intern(ObjectIdentifier.newInternal(orgName_data));
            orgUnitName_oid = X500Name.intern(ObjectIdentifier.newInternal(orgUnitName_data));
            stateName_oid = X500Name.intern(ObjectIdentifier.newInternal(stateName_data));
            streetAddress_oid = X500Name.intern(ObjectIdentifier.newInternal(streetAddress_data));
            title_oid = X500Name.intern(ObjectIdentifier.newInternal(title_data));
            surName_oid = X500Name.intern(ObjectIdentifier.newInternal(surname_data));
            givenName_oid = X500Name.intern(ObjectIdentifier.newInternal(givenname_data));
            initials_oid = X500Name.intern(ObjectIdentifier.newInternal(initials_data));
            ipAddress_oid = X500Name.intern(ObjectIdentifier.newInternal(ipAddress_data));
            dnQualifier_oid = X500Name.intern(ObjectIdentifier.newInternal(dnqualifier_data));
            domainComponent_oid = X500Name.intern(ObjectIdentifier.newInternal(domainComponent_data));
            generationQualifier_oid = X500Name.intern(ObjectIdentifier.newInternal(generationQualifier_data));
            userid_oid = X500Name.intern(ObjectIdentifier.newInternal(userid_data));
            pseudonym_oid = X500Name.intern(ObjectIdentifier.newInternal(pseudonym_data));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

