/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.controller.impl.ExecutionTransitioner;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.navigator.NavigatorFactory;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class FlowControllerImpl
implements IExecutionElementController {
    private static final String CLASSNAME = FlowControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private final RuntimeWorkUnitExecution flowExecution;
    protected ModelNavigator<Flow> flowNavigator;
    protected Flow flow;
    private ExecutionTransitioner transitioner;
    static final long serialVersionUID = 906037090215150128L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public FlowControllerImpl(RuntimeWorkUnitExecution flowExecution, Flow flow, long rootJobExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "<init>", new Object[]{flowExecution, flow, rootJobExecutionId});
        }
        this.flowExecution = flowExecution;
        this.flowNavigator = NavigatorFactory.createFlowNavigator(flow);
        this.flow = flow;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionStatus execute() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "execute", new Object[0]);
        }
        if (!this.flowExecution.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
            this.transitioner = new ExecutionTransitioner(this.flowExecution, this.flowNavigator);
            JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "flow.started", new Object[]{this.flow.getId(), this.flowExecution.getTopLevelInstanceId(), this.flowExecution.getTopLevelExecutionId()}, logger);
            ExecutionStatus flowStatus = this.transitioner.doExecutionLoop();
            if (flowStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || flowStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
                JoblogUtil.logToJobLogAndTraceOnly(Level.WARNING, "flow.failed", new Object[]{this.flowExecution.getFlowName(), this.flowExecution.getTopLevelInstanceId(), this.flowExecution.getTopLevelExecutionId()}, logger);
            }
            ExecutionStatus executionStatus = flowStatus;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                executionStatus = executionStatus;
                logger.exiting("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "execute", executionStatus);
            }
            return executionStatus;
        }
        ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "execute", executionStatus);
        }
        return executionStatus;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stop() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "stop", new Object[0]);
        }
        IController stoppableElementController = this.transitioner.getCurrentStoppableElementController();
        if (stoppableElementController != null) {
            stoppableElementController.stop();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "stop");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getLastRunStepExecutions() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "getLastRunStepExecutions", new Object[0]);
        }
        List<Long> list = this.transitioner.getStepExecIds();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.controller.impl.FlowControllerImpl", "getLastRunStepExecutions", list);
        }
        return list;
    }
}

