/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public class ClassUtils {
    private static HashMap<String, Class<?>> loadClassMap = new HashMap();

    public static Class loadClass(String _className) throws ClassNotFoundException {
        final String className = _className;
        Object ret = null;
        try {
            ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException cnfe) {
                        try {
                            return Class.forName(className, true, ClassUtils.class.getClassLoader());
                        }
                        catch (ClassNotFoundException cnfe2) {
                            try {
                                return Class.forName(className);
                            }
                            catch (ClassNotFoundException cnfe3) {
                                return cnfe3;
                            }
                        }
                    }
                }
            });
        }
        catch (SecurityException se) {
            throw new ClassNotFoundException(className);
        }
        if (ret instanceof Class) {
            return (Class)ret;
        }
        if (ret instanceof ClassNotFoundException) {
            Class<?> cls = loadClassMap.get(className);
            if (cls != null) {
                return cls;
            }
            throw (ClassNotFoundException)ret;
        }
        throw new ClassNotFoundException(className);
    }

    static {
        loadClassMap.put("byte", Byte.TYPE);
        loadClassMap.put("int", Integer.TYPE);
        loadClassMap.put("short", Short.TYPE);
        loadClassMap.put("long", Long.TYPE);
        loadClassMap.put("float", Float.TYPE);
        loadClassMap.put("double", Double.TYPE);
        loadClassMap.put("boolean", Boolean.TYPE);
        loadClassMap.put("char", Character.TYPE);
        loadClassMap.put("void", Void.TYPE);
    }
}

