/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.jandex.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.jandex.internal.PackedDataInputStream;
import com.ibm.ws.annocache.jandex.internal.SparseAnnotationHolder;
import com.ibm.ws.annocache.jandex.internal.SparseClassInfo;
import com.ibm.ws.annocache.jandex.internal.SparseDotName;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.jandex.internal.SparseIndexReaderVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class SparseIndexReaderVersionImpl_V2
implements SparseIndexReaderVersion {
    public static final int MIN_VERSION = 6;
    public static final int MAX_VERSION = 10;
    private final PackedDataInputStream input;
    private final int version;
    private byte[][] byteTable;
    private SparseDotName[] simpleNameTable;
    private String[] stringTable;
    private SparseDotName[] nameTable;
    private SparseDotName[] annoClassNameTable;
    private byte[] annoTypeTable;
    private SparseDotName[] typeTable;
    private SparseDotName[][] typeListTable;
    private SparseAnnotationHolder[] methodTable;
    private SparseAnnotationHolder[] fieldTable;
    private Map<SparseDotName, SparseClassInfo> classTable;
    private final List<SparseDotName> classAnnoClassNames;
    private int[] offsets;
    static final long serialVersionUID = 9052465729091255599L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean accept(int version) {
        return version >= 6 && version <= 10;
    }

    protected SparseIndexReaderVersionImpl_V2(PackedDataInputStream input, int version) {
        this.input = input;
        this.version = version;
        this.classAnnoClassNames = new ArrayList<SparseDotName>(20);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private SparseDotName getSimpleName(int nameNo) {
        SparseDotName simpleName = this.simpleNameTable[nameNo];
        if (simpleName == null) {
            byte[] nameBytes = this.byteTable[nameNo];
            this.simpleNameTable[nameNo] = simpleName = SparseDotName.createSimple(nameBytes);
        }
        return simpleName;
    }

    @Override
    public SparseIndex read() throws IOException {
        int usersLength = 0;
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        if (this.version >= 10) {
            usersLength = this.input.readPackedU32();
        }
        this.readByteTable();
        this.readStringTable();
        this.readNameTable();
        this.typeTable = new SparseDotName[this.input.readPackedU32() + 1];
        this.typeListTable = new SparseDotName[this.input.readPackedU32() + 1][];
        this.annoClassNameTable = new SparseDotName[this.input.readPackedU32() + 1];
        this.annoTypeTable = new byte[this.annoClassNameTable.length];
        this.readTypeTable();
        this.readTypeListTable();
        if (this.version >= 10) {
            this.readUsersTable(usersLength);
        }
        this.readMethodTable();
        this.readFieldTable();
        if (this.version >= 10) {
            this.readRecordComponentTable();
        }
        this.classTable = this.readClassTable();
        return new SparseIndex(this.classTable);
    }

    private void readByteTable() throws IOException {
        int numEntries = this.input.readPackedU32() + 1;
        byte[][] useByteTable = new byte[numEntries][];
        useByteTable[0] = null;
        for (int entryNo = 1; entryNo < numEntries; ++entryNo) {
            int numBytes = this.input.readPackedU32();
            useByteTable[entryNo] = new byte[numBytes];
            this.input.readFully(useByteTable[entryNo], 0, numBytes);
        }
        this.byteTable = useByteTable;
        this.simpleNameTable = new SparseDotName[useByteTable.length];
    }

    private void readStringTable() throws IOException {
        int numEntries = this.input.readPackedU32() + 1;
        String[] useStringTable = new String[numEntries];
        useStringTable[0] = null;
        for (int entryNo = 1; entryNo < numEntries; ++entryNo) {
            useStringTable[entryNo] = this.input.readUTF();
        }
        this.stringTable = useStringTable;
    }

    private void readNameTable() throws IOException {
        int numEntries = this.input.readPackedU32() + 1;
        SparseDotName[] useNameTable = new SparseDotName[numEntries];
        useNameTable[0] = null;
        int lastDepth = -1;
        SparseDotName lastName = null;
        for (int nameNo = 1; nameNo < numEntries; ++nameNo) {
            SparseDotName name;
            int packedDepth = this.input.readPackedU32();
            String tail = this.stringTable[this.input.readPackedU32()];
            boolean isInnerClass = (packedDepth & 1) == 1;
            int depth = packedDepth >> 1;
            SparseDotName head = lastName;
            if (lastDepth >= depth) {
                while (lastDepth-- >= depth) {
                    head = head.prefix();
                }
            }
            useNameTable[nameNo] = name = new SparseDotName(head, tail, false, isInnerClass);
            lastName = name;
            lastDepth = depth;
        }
        this.nameTable = useNameTable;
    }

    private void readAnnotations() throws IOException {
        int numAnno = this.input.readPackedU32();
        if (numAnno == 0) {
            return;
        }
        for (int annoNo = 0; annoNo < numAnno; ++annoNo) {
            int n = this.readAnnotation();
        }
    }

    private SparseDotName[] readElementAnnotations(SparseDotName targetName) throws IOException {
        int numAnno = this.input.readPackedU32();
        if (numAnno == 0) {
            return SparseDotName.EMPTY_ARRAY;
        }
        SparseDotName[] annoClassNames = new SparseDotName[numAnno];
        int numPlaceholders = 0;
        for (int annoNo = 0; annoNo < numAnno; ++annoNo) {
            int annoOffset = this.readAnnotation();
            SparseDotName annoClassName = this.annoClassNameTable[annoOffset];
            if (annoClassName.isPlaceholder()) {
                ++numPlaceholders;
                continue;
            }
            annoClassNames[annoNo - numPlaceholders] = annoClassName;
        }
        if (numPlaceholders != 0) {
            if (numPlaceholders == numAnno) {
                return SparseDotName.EMPTY_ARRAY;
            }
            return Arrays.copyOf(annoClassNames, numAnno - numPlaceholders);
        }
        return annoClassNames;
    }

    private boolean readClassAnnotations(SparseDotName targetName, List<SparseDotName> annoClassNames) throws IOException {
        int numAnno = this.input.readPackedU32();
        if (numAnno == 0) {
            return false;
        }
        boolean didAdd = false;
        for (int annotationNo = 0; annotationNo < numAnno; ++annotationNo) {
            byte annoType;
            int annoOffset = this.readAnnotation();
            SparseDotName annoClassName = this.annoClassNameTable[annoOffset];
            if (annoClassName.isPlaceholder() || !this.isClass(annoType = this.annoTypeTable[annoOffset])) continue;
            annoClassNames.add(annoClassName);
            didAdd = true;
        }
        return didAdd;
    }

    private boolean isClass(byte targetType) {
        return targetType == AnnoTarget.CLASS.tag;
    }

    private boolean selectType(byte targetType) {
        return targetType == AnnoTarget.CLASS.tag || targetType == AnnoTarget.FIELD.tag || targetType == AnnoTarget.METHOD.tag;
    }

    private int readAnnotation() throws IOException {
        int annoOffset = this.input.readPackedU32();
        SparseDotName annoClassName = this.annoClassNameTable[annoOffset];
        if (annoClassName != null) {
            return annoOffset;
        }
        annoClassName = this.nameTable[this.input.readPackedU32()];
        byte targetType = this.readAnnotationTarget();
        this.movePastAnnotationValues();
        if (!this.selectType(targetType)) {
            annoClassName = SparseDotName.PLACEHOLDER;
        }
        this.annoClassNameTable[annoOffset] = annoClassName;
        this.annoTypeTable[annoOffset] = targetType;
        return annoOffset;
    }

    private byte readAnnotationTarget() throws IOException {
        byte tag = this.input.readByte();
        byte seekCount = AnnoTarget.values()[tag].seekCount;
        if (seekCount == 3) {
            this.input.seekPackedU32();
            this.input.seekPackedU32();
            this.input.seekPackedU32();
        } else if (seekCount == 2) {
            this.input.seekPackedU32();
            this.input.seekPackedU32();
        } else if (seekCount == 1) {
            this.input.seekPackedU32();
        }
        return tag;
    }

    private void movePastAnnotationValues() throws IOException {
        int numValues = this.input.readPackedU32();
        for (int valueNo = 0; valueNo < numValues; ++valueNo) {
            this.movePastAnnotationValue();
        }
    }

    private void movePastAnnotationValue() throws IOException {
        this.input.seekPackedU32();
        byte valueType = this.input.readByte();
        if (valueType == AnnoValue.ARRAY.tag) {
            this.movePastAnnotationValues();
        } else if (valueType == AnnoValue.NESTED.tag) {
            int n = this.readAnnotation();
        } else {
            AnnoValue annoValue = AnnoValue.values()[valueType];
            int skipCount = annoValue.skipCount;
            if (skipCount != 0) {
                this.input.skipBytes(skipCount);
            } else {
                int readCount = annoValue.readCount;
                this.input.seekPackedU32();
                if (readCount == 2) {
                    this.input.seekPackedU32();
                }
            }
        }
    }

    private void readTypeTable() throws IOException {
        this.typeTable[0] = null;
        for (int entryNo = 1; entryNo < this.typeTable.length; ++entryNo) {
            this.typeTable[entryNo] = this.movePastReadTypeEntry();
        }
    }

    private SparseDotName movePastReadTypeEntry() throws IOException {
        int kind = this.input.readUnsignedByte();
        switch (kind) {
            case 0: {
                SparseDotName className = this.nameTable[this.input.readPackedU32()];
                this.readAnnotations();
                return className;
            }
            case 1: {
                this.input.seekPackedU32();
                this.input.seekPackedU32();
                this.readAnnotations();
                return SparseDotName.PLACEHOLDER;
            }
            case 2: {
                this.input.readUnsignedByte();
                this.readAnnotations();
                return SparseDotName.PLACEHOLDER;
            }
            default: {
                this.readAnnotations();
                return SparseDotName.PLACEHOLDER;
            }
            case 4: {
                this.input.seekPackedU32();
                this.readTypeListReference();
                this.readAnnotations();
                return SparseDotName.PLACEHOLDER;
            }
            case 5: {
                this.input.seekPackedU32();
                this.readAnnotations();
                return SparseDotName.PLACEHOLDER;
            }
            case 6: {
                this.input.seekPackedU32();
                this.input.seekPackedU32();
                this.readAnnotations();
                return SparseDotName.PLACEHOLDER;
            }
            case 7: 
        }
        SparseDotName name = this.nameTable[this.input.readPackedU32()];
        this.input.seekPackedU32();
        this.readTypeListReference();
        this.readAnnotations();
        return name;
    }

    private SparseDotName[] readTypeListReference() throws IOException {
        int listOffset = this.input.readPackedU32();
        SparseDotName[] typeNames = this.typeListTable[listOffset];
        if (typeNames != null) {
            return typeNames;
        }
        this.typeListTable[listOffset] = this.readTypeList();
        return this.typeListTable[listOffset];
    }

    private void readTypeListTable() throws IOException {
        SparseDotName[][] useTypeListTable = this.typeListTable;
        useTypeListTable[0] = null;
        int entryNo = this.findNextNull((Object[])useTypeListTable, 1);
        while (entryNo < useTypeListTable.length) {
            useTypeListTable[entryNo] = this.readTypeList();
            entryNo = this.findNextNull((Object[])useTypeListTable, entryNo);
        }
    }

    private int findNextNull(Object[] array, int start) {
        while (start < array.length) {
            if (array[start] == null) {
                return start;
            }
            ++start;
        }
        return array.length;
    }

    private SparseDotName[] readTypeList() throws IOException {
        int numNames = this.input.readPackedU32();
        if (numNames == 0) {
            return SparseDotName.PLACEHOLDER_ARRAY;
        }
        SparseDotName[] typeNames = new SparseDotName[numNames];
        for (int nameNo = 0; nameNo < numNames; ++nameNo) {
            typeNames[nameNo] = this.typeTable[this.input.readPackedU32()];
        }
        return typeNames;
    }

    private void readUsersTable(int usersLength) throws IOException {
        for (int i = 0; i < usersLength; ++i) {
            this.input.seekPackedU32();
            int usesCount = this.input.readPackedU32();
            for (int j = 0; j < usesCount; ++j) {
                this.input.seekPackedU32();
            }
        }
    }

    private void readMethodTable() throws IOException {
        int numMethods = this.input.readPackedU32() + 1;
        SparseAnnotationHolder[] useMethodTable = new SparseAnnotationHolder[numMethods];
        useMethodTable[0] = null;
        for (int methodNo = 1; methodNo < numMethods; ++methodNo) {
            useMethodTable[methodNo] = this.readMethod();
        }
        this.methodTable = useMethodTable;
    }

    private SparseAnnotationHolder readMethod() throws IOException {
        SparseDotName methodName = this.getSimpleName(this.input.readPackedU32());
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        if (this.version >= 7) {
            boolean hasDefaultValue;
            boolean bl = hasDefaultValue = this.input.readByte() > 0;
            if (hasDefaultValue) {
                this.movePastAnnotationValue();
            }
        }
        if (this.version >= 8) {
            int numParms = this.input.readPackedU32();
            for (int parmNo = 0; parmNo < numParms; ++parmNo) {
                this.input.seekPackedU32();
            }
        }
        SparseDotName[] methodAnnotations = this.readElementAnnotations(methodName);
        return new SparseAnnotationHolder(methodName, methodAnnotations);
    }

    private void readFieldTable() throws IOException {
        int numFields = this.input.readPackedU32() + 1;
        SparseAnnotationHolder[] useFieldTable = new SparseAnnotationHolder[numFields];
        useFieldTable[0] = null;
        for (int fieldNo = 1; fieldNo < numFields; ++fieldNo) {
            useFieldTable[fieldNo] = this.readField();
        }
        this.fieldTable = useFieldTable;
    }

    private SparseAnnotationHolder readField() throws IOException {
        SparseDotName fieldName = this.getSimpleName(this.input.readPackedU32());
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        SparseDotName[] fieldAnnotations = this.readElementAnnotations(fieldName);
        return new SparseAnnotationHolder(fieldName, fieldAnnotations);
    }

    private void readRecordComponentTable() throws IOException {
        int size = this.input.readPackedU32();
        for (int i = 0; i < size; ++i) {
            this.input.seekPackedU32();
            this.input.seekPackedU32();
            this.readAnnotations();
        }
    }

    private Map<SparseDotName, SparseClassInfo> readClassTable() throws IOException {
        int numClasses = this.input.readPackedU32();
        HashMap<SparseDotName, SparseClassInfo> classes = new HashMap<SparseDotName, SparseClassInfo>(numClasses);
        for (int classNo = 0; classNo < numClasses; ++classNo) {
            SparseClassInfo classInfo = this.readClass();
            classes.put(classInfo.name(), classInfo);
        }
        return classes;
    }

    private SparseClassInfo readClass() throws IOException {
        int enclosureBits;
        SparseDotName className = this.nameTable[this.input.readPackedU32()];
        short flags = (short)this.input.readPackedU32();
        SparseDotName superClassName = this.typeTable[this.input.readPackedU32()];
        this.input.seekPackedU32();
        SparseDotName[] interfaceNames = this.typeListTable[this.input.readPackedU32()];
        SparseClassInfo classInfo = new SparseClassInfo(className, superClassName, flags, interfaceNames);
        if (this.version >= 9) {
            enclosureBits = this.input.readUnsignedByte();
            if (enclosureBits > 0) {
                this.readPastEnclosingClass();
                if ((enclosureBits & 2) == 2) {
                    this.readPastEnclosingMethod();
                }
            }
        } else {
            this.readPastEnclosingClass();
            enclosureBits = this.input.readUnsignedByte();
            if (enclosureBits == 1) {
                this.readPastEnclosingMethod();
            }
        }
        int numAnnotations = this.input.readPackedU32();
        this.readFields(classInfo);
        if (this.version >= 10) {
            this.input.seekPackedU32();
        }
        this.readMethods(classInfo);
        if (this.version >= 10) {
            this.input.seekPackedU32();
        }
        if (this.version >= 10) {
            this.readRecordComponents();
            this.input.seekPackedU32();
        }
        for (int annoNo = 0; annoNo < numAnnotations; ++annoNo) {
            if (!this.readClassAnnotations(className, this.classAnnoClassNames)) continue;
            classInfo.addClassAnnotations(this.classAnnoClassNames);
            this.classAnnoClassNames.clear();
        }
        return classInfo;
    }

    private void readPastEnclosingClass() throws IOException {
        this.input.seekPackedU32();
        this.input.seekPackedU32();
    }

    private void readPastEnclosingMethod() throws IOException {
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        this.input.seekPackedU32();
        this.input.seekPackedU32();
    }

    private int[] getOffsets(int size) {
        if (this.offsets == null || size > this.offsets.length) {
            this.offsets = new int[size];
        }
        return this.offsets;
    }

    private void readFields(SparseClassInfo classInfo) throws IOException {
        SparseAnnotationHolder fieldAnnoHolder;
        int fieldOffset;
        int fieldNo;
        int numFields = this.input.readPackedU32();
        if (numFields == 0) {
            return;
        }
        int[] fieldOffsets = this.getOffsets(numFields);
        int numFieldAnnos = 0;
        for (fieldNo = 0; fieldNo < numFields; ++fieldNo) {
            fieldOffsets[fieldNo] = fieldOffset = this.input.readPackedU32();
            fieldAnnoHolder = this.fieldTable[fieldOffset];
            numFieldAnnos += fieldAnnoHolder.getAnnotations().length;
        }
        classInfo.allocateFieldAnnotations(numFieldAnnos);
        for (fieldNo = 0; fieldNo < numFields; ++fieldNo) {
            fieldOffset = fieldOffsets[fieldNo];
            fieldAnnoHolder = this.fieldTable[fieldOffset];
            classInfo.addAllocatedFieldAnnotations(fieldAnnoHolder.getAnnotations());
        }
    }

    private void readMethods(SparseClassInfo classInfo) throws IOException {
        SparseAnnotationHolder methodAnnoHolder;
        int methodOffset;
        int methodNo;
        int numMethods = this.input.readPackedU32();
        if (numMethods == 0) {
            return;
        }
        int[] methodOffsets = this.getOffsets(numMethods);
        int numMethodAnnos = 0;
        for (methodNo = 0; methodNo < numMethods; ++methodNo) {
            methodOffsets[methodNo] = methodOffset = this.input.readPackedU32();
            methodAnnoHolder = this.methodTable[methodOffset];
            numMethodAnnos += methodAnnoHolder.getAnnotations().length;
        }
        classInfo.allocateMethodAnnotations(numMethodAnnos);
        for (methodNo = 0; methodNo < numMethods; ++methodNo) {
            methodOffset = methodOffsets[methodNo];
            methodAnnoHolder = this.methodTable[methodOffset];
            classInfo.addAllocatedMethodAnnotations(methodAnnoHolder.getAnnotations());
        }
    }

    private void readRecordComponents() throws IOException {
        int numRecordComponents = this.input.readPackedU32();
        for (int i = 0; i < numRecordComponents; ++i) {
            this.input.seekPackedU32();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.jandex.internal.SparseIndexReaderVersionImpl_V2", SparseIndexReaderVersionImpl_V2.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }

    protected static enum AnnoValue {
        UNUSED(0, 0, 0),
        BYTE(1, 1, 0),
        SHORT(2, 0, 1),
        INT(3, 0, 1),
        CHAR(4, 0, 1),
        FLOAT(5, 4, 0),
        DOUBLE(6, 8, 0),
        LONG(7, 8, 0),
        BOOLEAN(8, 1, 0),
        STRING(9, 0, 1),
        CLASS(10, 0, 1),
        ENUM(11, 0, 2),
        ARRAY(12, 0, 0),
        NESTED(13, 0, 0);

        public final byte tag;
        public final int skipCount;
        public final int readCount;

        private AnnoValue(byte tag, int skipCount, int readCount) {
            this.tag = tag;
            this.skipCount = skipCount;
            this.readCount = readCount;
        }

        public byte getTag() {
            return this.tag;
        }

        public int getSkipCount() {
            return this.skipCount;
        }

        public int getReadCount() {
            return this.readCount;
        }

        public static AnnoValue select(int tag) {
            for (AnnoValue value : AnnoValue.values()) {
                if (value.tag == 0 || value.tag != tag) continue;
                return value;
            }
            return null;
        }
    }

    protected static enum AnnoTarget {
        NULL(0, 0),
        FIELD(1, 0),
        METHOD(2, 0),
        METHOD_PARAMATER(3, 1),
        CLASS(4, 0),
        EMPTY_TYPE(5, 2),
        CLASS_EXTENDS_TYPE(6, 2),
        TYPE_PARAMETER(7, 2),
        TYPE_PARAMETER_BOUND(8, 3),
        METHOD_PARAMETER_TYPE(9, 2),
        THROWS_TYPE(10, 2),
        RECORD_COMPONENT(11, 0);

        public final byte tag;
        public final byte seekCount;

        private AnnoTarget(byte tag, byte seekCount) {
            this.tag = tag;
            this.seekCount = seekCount;
        }

        public byte getTag() {
            return this.tag;
        }

        public static AnnoTarget select(byte tag) {
            for (AnnoTarget target : AnnoTarget.values()) {
                if (target.tag != tag) continue;
                return target;
            }
            return null;
        }
    }
}

