/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.TargetsTableContainers;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.TargetCache_Readable;
import com.ibm.ws.annocache.targets.cache.TargetCache_Reader;
import com.ibm.ws.annocache.targets.internal.AnnotationTargetsImpl_Factory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetsTableContainersImpl
implements TargetsTableContainers,
TargetCache_Readable {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    public static final String CLASS_NAME = TargetsTableContainersImpl.class.getSimpleName();
    protected final String hashText;
    protected final AnnotationTargetsImpl_Factory factory;
    protected final List<String> names;
    protected final Map<String, ClassSource_Aggregate.ScanPolicy> policies;
    static final long serialVersionUID = 5898313669412716300L;

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.hashText;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableContainersImpl(AnnotationTargetsImpl_Factory factory) {
        String methodName = "<init>";
        this.factory = factory;
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.names = new ArrayList<String>();
        this.policies = new HashMap<String, ClassSource_Aggregate.ScanPolicy>();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.hashText);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationTargetsImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addName(String name, ClassSource_Aggregate.ScanPolicy policy) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addName", new Object[]{name, policy});
        }
        this.names.add(name);
        this.policies.put(name, policy);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addName");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addNameAfter(String name, ClassSource_Aggregate.ScanPolicy policy, String afterName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNameAfter", new Object[]{name, policy, afterName});
        }
        int addOffset = this.names.indexOf(afterName);
        if (addOffset == -1) {
            throw new IndexOutOfBoundsException("Name [ " + afterName + " ] is not within container table [ " + this.getHashText() + " ]");
        }
        this.names.add(addOffset + 1, name);
        this.policies.put(name, policy);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNameAfter");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addNameBefore(String name, ClassSource_Aggregate.ScanPolicy policy, String beforeName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNameBefore", new Object[]{name, policy, beforeName});
        }
        int addOffset = this.names.indexOf(beforeName);
        if (addOffset == -1) {
            throw new IndexOutOfBoundsException("Name [ " + beforeName + " ] is not within container table [ " + this.getHashText() + " ]");
        }
        this.names.add(addOffset, name);
        this.policies.put(name, policy);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNameBefore");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Aggregate.ScanPolicy removeName(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "removeName", new Object[]{name});
        }
        this.names.remove(name);
        ClassSource_Aggregate.ScanPolicy scanPolicy = this.policies.remove(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            scanPolicy = scanPolicy;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "removeName", (Object)scanPolicy);
        }
        return scanPolicy;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getNames", new Object[0]);
        }
        List<String> list = this.names;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getNames", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsName(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "containsName", new Object[]{name});
        }
        boolean bl = this.policies.containsKey(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "containsName", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Aggregate.ScanPolicy getPolicy(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getPolicy", new Object[]{name});
        }
        ClassSource_Aggregate.ScanPolicy scanPolicy = this.policies.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            scanPolicy = scanPolicy;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getPolicy", (Object)scanPolicy);
        }
        return scanPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addNames(ClassSource_Aggregate rootClassSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNames", new Object[]{rootClassSource});
        }
        for (ClassSource classSource : rootClassSource.getClassSources()) {
            ClassSource_Aggregate.ScanPolicy scanPolicy = rootClassSource.getScanPolicy(classSource);
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            this.addName(classSource.getCanonicalName(), scanPolicy);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNames");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Containers: BEGIN");
        for (String name : this.getNames()) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Name: " + name);
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Policy: " + (Object)((Object)this.getPolicy(name)));
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Containers: END");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean sameAs(TargetsTableContainersImpl otherTable) {
        List<String> otherNames;
        int otherCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", new Object[]{otherTable});
        }
        if (otherTable == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", bl);
            }
            return bl;
        }
        if (otherTable == this) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", bl);
            }
            return bl;
        }
        List<String> theseNames = this.getNames();
        int thisCount = theseNames.size();
        if (thisCount != (otherCount = (otherNames = otherTable.getNames()).size())) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", bl);
            }
            return bl;
        }
        for (int nameNo = 0; nameNo < thisCount; ++nameNo) {
            ClassSource_Aggregate.ScanPolicy otherPolicy;
            String otherName;
            String thisName = theseNames.get(nameNo);
            if (!thisName.equals(otherName = otherNames.get(nameNo))) {
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", bl);
                }
                return bl;
            }
            ClassSource_Aggregate.ScanPolicy thisPolicy = this.getPolicy(thisName);
            if (thisPolicy == (otherPolicy = otherTable.getPolicy(thisName))) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> readUsing(TargetCache_Reader reader) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "readUsing", new Object[]{reader});
        }
        List<TargetCache_ParseError> list = reader.read(this);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "readUsing", list);
        }
        return list;
    }
}

