/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Manifest;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.aries.util.manifest.ManifestProcessor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LooseAppMonitoring {
    private static final TraceComponent tc = Tr.register(LooseAppMonitoring.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring");
    static final long serialVersionUID = 1424970806248098019L;

    private static String fixPathForMonitoringUse(String path) {
        String fixedPath = path.trim();
        if (!fixedPath.startsWith("/")) {
            fixedPath = "/" + path;
        }
        if (fixedPath.endsWith("/") && fixedPath.length() > 1) {
            fixedPath = fixedPath.substring(fixedPath.length() - 1);
        }
        return fixedPath;
    }

    public ApplicationMonitoringInformation configureLooseOSGiAppMonitoring(final Container container) {
        ApplicationMonitoringInformation appMonitoringInfo = new ApplicationMonitoringInformation(){
            static final long serialVersionUID = -3085897701617974535L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public boolean isListeningForRootStructuralChanges() {
                return false;
            }

            public Collection<Notifier.Notification> getNotificationsToMonitor() {
                ArrayList<Notifier.Notification> monitored = new ArrayList<Notifier.Notification>();
                monitored.add((Notifier.Notification)new DefaultNotification(container, "/META-INF/APPLICATION.MF"));
                monitored.add((Notifier.Notification)new DefaultNotification(container, "/META-INF/SUBSYSTEM.MF"));
                HashMap<String, List<Container>> symbolicNameToHostContainers = new HashMap<String, List<Container>>();
                HashMap<String, List<Container>> symbolicNameToFragmentContainers = new HashMap<String, List<Container>>();
                HashMap<Container, Map<String, String>> containerToManifestHeaders = new HashMap<Container, Map<String, String>>();
                this.buildContainerMapsForBundlesAndFragments(container, monitored, symbolicNameToHostContainers, symbolicNameToFragmentContainers, containerToManifestHeaders);
                ArrayList<BundleMonitoringContributor> bundleMonitoringProcessors = new ArrayList<BundleMonitoringContributor>();
                bundleMonitoringProcessors.add(new BundleMetaDataMonitor());
                bundleMonitoringProcessors.add(new BundleClassPathMonitor());
                bundleMonitoringProcessors.add(new WABMetaDataMonitor());
                bundleMonitoringProcessors.add(new BlueprintMetaDataMonitor());
                this.addMonitoringForHostBundles(bundleMonitoringProcessors, monitored, symbolicNameToHostContainers, symbolicNameToFragmentContainers, containerToManifestHeaders);
                this.addMonitoringForFragmentBundles(bundleMonitoringProcessors, monitored, symbolicNameToFragmentContainers, containerToManifestHeaders);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" Monitoring: ", (Object[])new Object[0]);
                }
                for (Notifier.Notification n : monitored) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)(" [" + n.getContainer().hashCode() + "] " + n.getPaths()), (Object[])new Object[0]);
                }
                return monitored;
            }

            private void addMonitoringForFragmentBundles(List<BundleMonitoringContributor> bundleMonitoringProcessors, Collection<Notifier.Notification> monitored, Map<String, List<Container>> symbolicNameToFragmentContainers, Map<Container, Map<String, String>> containerToManifestHeaders) {
                for (Map.Entry<String, List<Container>> fragmentContainers : symbolicNameToFragmentContainers.entrySet()) {
                    for (Container child : fragmentContainers.getValue()) {
                        Map<String, String> mm = containerToManifestHeaders.get(child);
                        for (BundleMonitoringContributor contributor : bundleMonitoringProcessors) {
                            contributor.processFragmentBundle(monitored, child, mm);
                        }
                    }
                }
            }

            private void addMonitoringForHostBundles(List<BundleMonitoringContributor> bundleMonitoringProcessors, Collection<Notifier.Notification> monitored, Map<String, List<Container>> symbolicNameToHostContainers, Map<String, List<Container>> symbolicNameToFragmentContainers, Map<Container, Map<String, String>> containerToManifestHeaders) {
                for (Map.Entry<String, List<Container>> hostContainers : symbolicNameToHostContainers.entrySet()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" symbname " + hostContainers.getKey() + " has " + hostContainers.getValue().size() + " containers to process"), (Object[])new Object[0]);
                    }
                    for (Container child : hostContainers.getValue()) {
                        Map<String, String> mm = containerToManifestHeaders.get(child);
                        for (BundleMonitoringContributor contributor : bundleMonitoringProcessors) {
                            contributor.processHostBundle(monitored, child, symbolicNameToFragmentContainers.get(hostContainers.getKey()), mm);
                        }
                    }
                }
            }

            private void buildContainerMapsForBundlesAndFragments(Container container2, Collection<Notifier.Notification> monitored, Map<String, List<Container>> symbolicNameToHostContainers, Map<String, List<Container>> symbolicNameToFragmentContainers, Map<Container, Map<String, String>> containerToManifestHeaders) {
                for (Entry e : container2) {
                    try {
                        Container child = (Container)e.adapt(Container.class);
                        if (child == null || !child.isRoot()) continue;
                        Entry manifest = child.getEntry("/META-INF/MANIFEST.MF");
                        if (manifest != null) {
                            InputStream is = (InputStream)manifest.adapt(InputStream.class);
                            Manifest m = ManifestProcessor.parseManifest((InputStream)is);
                            Map caseSensitiveManifest = ManifestProcessor.readManifestIntoMap((Manifest)m);
                            TreeMap mm = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                            mm.putAll(caseSensitiveManifest);
                            String bundleSymbolicNameHeader = (String)mm.get("Bundle-SymbolicName");
                            if (bundleSymbolicNameHeader == null || bundleSymbolicNameHeader.isEmpty()) {
                                monitored.add((Notifier.Notification)new DefaultNotification(child, "/"));
                                continue;
                            }
                            containerToManifestHeaders.put(child, mm);
                            String fragmentHostHeader = (String)mm.get("Fragment-Host");
                            String fragmentHost = null;
                            if (fragmentHostHeader != null) {
                                ManifestHeaderProcessor.NameValuePair fragmentNvp = ManifestHeaderProcessor.parseBundleSymbolicName((String)fragmentHostHeader);
                                fragmentHost = fragmentNvp.getName();
                            }
                            ManifestHeaderProcessor.NameValuePair symbolicNameNvp = ManifestHeaderProcessor.parseBundleSymbolicName((String)bundleSymbolicNameHeader);
                            String symbolicName = symbolicNameNvp.getName();
                            List<Container> c = null;
                            if (fragmentHost != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)(" " + e.getName() + " [" + child.hashCode() + "] is a fragment "), (Object[])new Object[0]);
                                }
                                c = symbolicNameToFragmentContainers.get(fragmentHost);
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)(" " + e.getName() + " [" + child.hashCode() + "] is a host "), (Object[])new Object[0]);
                                }
                                c = symbolicNameToHostContainers.get(symbolicName);
                            }
                            if (c == null) {
                                c = new ArrayList<Container>();
                                if (fragmentHost != null) {
                                    symbolicNameToFragmentContainers.put(fragmentHost, c);
                                } else {
                                    symbolicNameToHostContainers.put(symbolicName, c);
                                }
                            }
                            if (c.contains(child)) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(" adding container [" + child.hashCode() + "] for " + e.getName()), (Object[])new Object[0]);
                            }
                            c.add(child);
                            continue;
                        }
                        monitored.add((Notifier.Notification)new DefaultNotification(child, "/"));
                    }
                    catch (UnableToAdaptException unableToAdaptException) {
                        FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring$1", (String)"392", (Object)this, (Object[])new Object[]{container2, monitored, symbolicNameToHostContainers, symbolicNameToFragmentContainers, containerToManifestHeaders});
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring$1", (String)"394", (Object)this, (Object[])new Object[]{container2, monitored, symbolicNameToHostContainers, symbolicNameToFragmentContainers, containerToManifestHeaders});
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring$1");
            }
        };
        return appMonitoringInfo;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class BundleMetaDataMonitor
    implements BundleMonitoringContributor {
        static final long serialVersionUID = -1899111175170831012L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private BundleMetaDataMonitor() {
        }

        @Override
        public void processFragmentBundle(Collection<Notifier.Notification> monitored, Container fragment, Map<String, String> manifestHeadersForFragment) {
            monitored.add((Notifier.Notification)new DefaultNotification(fragment, "/META-INF/MANIFEST.MF"));
        }

        @Override
        public void processHostBundle(Collection<Notifier.Notification> monitored, Container bundle, List<Container> fragmentContainersForBundle, Map<String, String> manifestHeadersForBundle) {
            monitored.add((Notifier.Notification)new DefaultNotification(bundle, "/META-INF/MANIFEST.MF"));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BundleMetaDataMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring$BundleMetaDataMonitor");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class BlueprintMetaDataMonitor
    implements BundleMonitoringContributor {
        static final long serialVersionUID = 7223186137112941716L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private BlueprintMetaDataMonitor() {
        }

        @Override
        public void processFragmentBundle(Collection<Notifier.Notification> monitored, Container fragment, Map<String, String> manifestHeadersForFragment) {
        }

        @Override
        public void processHostBundle(Collection<Notifier.Notification> monitored, Container bundle, List<Container> fragmentContainersForBundle, Map<String, String> manifestHeadersForBundle) {
            ArrayList<String> blueprintSearchPaths = new ArrayList<String>();
            String blueprintHeaderVal = manifestHeadersForBundle.get("Bundle-Blueprint");
            if (blueprintHeaderVal == null) {
                blueprintSearchPaths.add("/OSGI-INF/blueprint");
            } else {
                Map classPathMap = ManifestHeaderProcessor.parseImportString((String)blueprintHeaderVal);
                for (String key : classPathMap.keySet()) {
                    if (key.contains("*")) {
                        int lastSlash = key.lastIndexOf(47);
                        if (lastSlash == -1) {
                            blueprintSearchPaths.add("/");
                            continue;
                        }
                        blueprintSearchPaths.add(key.substring(0, lastSlash));
                        continue;
                    }
                    blueprintSearchPaths.add(key);
                }
            }
            for (String path : blueprintSearchPaths) {
                String fixedPath = LooseAppMonitoring.fixPathForMonitoringUse(path);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" monitoring blueprint location of " + fixedPath + " for " + bundle.hashCode()), (Object[])new Object[0]);
                }
                monitored.add((Notifier.Notification)new DefaultNotification(bundle, fixedPath));
                if (fragmentContainersForBundle == null) continue;
                for (Container fragment : fragmentContainersForBundle) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" monitoring same location (" + fixedPath + ")for fragment " + fragment.hashCode()), (Object[])new Object[0]);
                    }
                    monitored.add((Notifier.Notification)new DefaultNotification(fragment, fixedPath));
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BlueprintMetaDataMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring$BlueprintMetaDataMonitor");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class WABMetaDataMonitor
    implements BundleMonitoringContributor {
        static final long serialVersionUID = -1703669233364267307L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private WABMetaDataMonitor() {
        }

        @Override
        public void processFragmentBundle(Collection<Notifier.Notification> monitored, Container fragment, Map<String, String> manifestHeadersForFragment) {
        }

        @Override
        public void processHostBundle(Collection<Notifier.Notification> monitored, Container bundle, List<Container> fragmentContainersForBundle, Map<String, String> manifestHeadersForBundle) {
            String webHeader = manifestHeadersForBundle.get("Web-ContextPath");
            if (webHeader != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" monitoring web-inf for wab " + bundle.hashCode()), (Object[])new Object[0]);
                }
                monitored.add((Notifier.Notification)new DefaultNotification(bundle, "!/WEB-INF"));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WABMetaDataMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring$WABMetaDataMonitor");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class BundleClassPathMonitor
    implements BundleMonitoringContributor {
        static final long serialVersionUID = 1103476320179087056L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private BundleClassPathMonitor() {
        }

        @Override
        public void processFragmentBundle(Collection<Notifier.Notification> monitored, Container fragment, Map<String, String> manifestHeadersForFragment) {
            String bundleClassPath = manifestHeadersForFragment.get("Bundle-ClassPath");
            if (bundleClassPath == null || bundleClassPath.equals(".")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Monitoring whole fragment for " + fragment.hashCode()), (Object[])new Object[0]);
                }
                monitored.add((Notifier.Notification)new DefaultNotification(fragment, "/"));
            } else {
                Map classPathMap = ManifestHeaderProcessor.parseImportString((String)bundleClassPath);
                for (String path : classPathMap.keySet()) {
                    String fixedPath = LooseAppMonitoring.fixPathForMonitoringUse(path);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" monitoring fragment-classpath location of " + fixedPath + " for " + fragment.hashCode()), (Object[])new Object[0]);
                    }
                    monitored.add((Notifier.Notification)new DefaultNotification(fragment, fixedPath));
                }
            }
        }

        @Override
        public void processHostBundle(Collection<Notifier.Notification> monitored, Container bundle, List<Container> fragmentContainersForBundle, Map<String, String> manifestHeadersForBundle) {
            String bundleClassPath = manifestHeadersForBundle.get("Bundle-ClassPath");
            if (bundleClassPath == null || bundleClassPath.equals(".")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Monitoring whole fragment for " + bundle.hashCode()), (Object[])new Object[0]);
                }
                monitored.add((Notifier.Notification)new DefaultNotification(bundle, "/"));
            } else {
                Map classPathMap = ManifestHeaderProcessor.parseImportString((String)bundleClassPath);
                for (String path : classPathMap.keySet()) {
                    String fixedPath = LooseAppMonitoring.fixPathForMonitoringUse(path);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" monitoring classpath location of " + fixedPath + " for " + bundle.hashCode()), (Object[])new Object[0]);
                    }
                    monitored.add((Notifier.Notification)new DefaultNotification(bundle, fixedPath));
                    if (fragmentContainersForBundle == null) continue;
                    for (Container fragment : fragmentContainersForBundle) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(" monitoring same location (" + fixedPath + ")for fragment "), (Object[])new Object[0]);
                        }
                        monitored.add((Notifier.Notification)new DefaultNotification(fragment, fixedPath));
                    }
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BundleClassPathMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.esa.internal.resources.Messages", (String)"com.ibm.ws.app.manager.esa.internal.LooseAppMonitoring$BundleClassPathMonitor");
        }
    }

    static interface BundleMonitoringContributor {
        public void processHostBundle(Collection<Notifier.Notification> var1, Container var2, List<Container> var3, Map<String, String> var4);

        public void processFragmentBundle(Collection<Notifier.Notification> var1, Container var2, Map<String, String> var3);
    }
}

