/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.esa.internal.featuremanager;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.esa.internal.featuremanager.Feature;
import com.ibm.ws.app.manager.esa.internal.featuremanager.Service;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FeatureBundleFactory {
    private static final String VIRTUAL_FEATURE = "virtual.feature.";
    private static final String OSGI_SERVICE_NAMESPACE = "osgi.service";
    static final long serialVersionUID = -1065313523703009326L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    static Bundle createAndInstallFeatureBundle(BundleContext ctx, Feature f) throws IOException, BundleException {
        String symbolicName = VIRTUAL_FEATURE + f.toString();
        Manifest mf = FeatureBundleFactory.createBundleManifest(f, symbolicName);
        InputStream in = FeatureBundleFactory.getBundleInputStream(mf);
        Bundle b = FeatureBundleFactory.installBundle(ctx, symbolicName, in);
        ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(1);
        return b;
    }

    static Manifest createBundleManifest(Feature f, String symbolicName) {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.putValue("Bundle-Name", f.getName());
        attrs.putValue("Bundle-Version", f.getOsgiVersion().toString());
        attrs.putValue("Bundle-ManifestVersion", "2");
        attrs.putValue("Bundle-SymbolicName", symbolicName);
        FeatureBundleFactory.addServiceCapabilities(attrs, f);
        return manifest;
    }

    private static void addServiceCapabilities(Attributes attrs, Feature f) {
        ArrayList<String> serviceCapabilities = new ArrayList<String>();
        for (Service service : f.getServices()) {
            serviceCapabilities.add(FeatureBundleFactory.createServiceCapability(service));
        }
        if (!serviceCapabilities.isEmpty()) {
            StringBuilder capabilityHeader = new StringBuilder();
            boolean first = true;
            for (String service : serviceCapabilities) {
                if (!first) {
                    capabilityHeader.append(", ");
                } else {
                    first = false;
                }
                capabilityHeader.append(service);
            }
            attrs.putValue("Provide-Capability", capabilityHeader.toString());
        }
    }

    private static String createServiceCapability(Service service) {
        Map<String, String> serviceAttrs = service.getProperties();
        if (serviceAttrs.isEmpty()) {
            throw new IllegalArgumentException("No service attributes!");
        }
        StringBuilder result = new StringBuilder(OSGI_SERVICE_NAMESPACE);
        for (Map.Entry<String, String> attr : serviceAttrs.entrySet()) {
            result.append("; ");
            result.append(attr.getKey()).append("=\"").append(attr.getValue()).append("\"");
        }
        return result.toString();
    }

    static InputStream getBundleInputStream(Manifest manifest) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        JarOutputStream jarOut = new JarOutputStream((OutputStream)bytesOut, manifest);
        jarOut.flush();
        jarOut.close();
        bytesOut.close();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        return bytesIn;
    }

    private static Bundle installBundle(BundleContext ctx, String id, InputStream in) throws BundleException {
        return ctx.installBundle("FrameworkVirtualResource@" + id, in);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.app.manager.esa.internal.featuremanager.FeatureBundleFactory", FeatureBundleFactory.class, null, null);
    }
}

