/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.zip.internal.ZipFileContainerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.zip.ZipException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ZipValidator {
    static final TraceComponent tc = Tr.register(ZipFileContainerFactory.class, (String)"archive.artifact.zip", (String)"com.ibm.ws.artifact.zip.internal.resources.ZipArtifactMessages");
    private static final int EOCDR_MIN_SIZE = 22;
    private static final int EOCDR_MAX_COMMENT_LEN = 65535;
    private static final int EOCDR_MAX_SIZE = 65557;
    private static final int EOCDR_SIGNATURE = 1347093766;
    private static final int EOCDR_TOTAL_ENTRIES_OFFSET = 10;
    private static final int ZIP64_INDICATOR = 65535;
    private static final int EOCDR_CENTRAL_DIR_SIZE_OFFSET = 12;
    private static final int EOCDR_CENTRAL_DIR_OFFSET = 16;
    private static final int EOCDR_COMMENT_LENGTH_OFFSET = 20;
    private static final int ZIP64_EOCDR_SIGNATURE = 1347094022;
    private static final int ZIP64_EOCDR_MINIMUM_SIZE = 56;
    private static final int ZIP64_EOCDR_HEADER_SIZE = 12;
    private static final int ZIP64_EOCDR_SIZE_OFFSET = 4;
    private static final int ZIP64_EOCDR_SIZE_FIELD_LENGTH = 8;
    private static final int ZIP64_LOCATOR_SIGNATURE = 1347094023;
    private static final int ZIP64_LOCATOR_SIZE = 20;
    private static final int ZIP64_LOCATOR_EOCD_OFFSET_OFFSET = 8;
    private static final int LOCAL_FILE_HEADER_SIGNATURE = 1347093252;
    private static final int BLOCK_SIZE = 256;
    private static final int FORWARD_BLOCK_SIZE = 8192;
    private static final int MAX_PREFIX_ALLOWED_FOR_ZIP64 = 0xC800000;
    private byte[] _endOfCentralDirectoryRecord;
    private int _eocdRecordSize;
    private byte[] _zip64EoCDRLocator;
    private long _zip64EoCDRLocatorOffset;
    private byte[] _zip64EoCDR;
    private long _zip64EoCDRecSize;
    private String _archiveFileName;
    private long _fileLength;
    static final long serialVersionUID = -7942201707642836712L;

    ZipValidator(String archiveFileName) {
        this._archiveFileName = archiveFileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid() {
        try {
            RandomAccessFile file222;
            block7: {
                boolean bl;
                file222 = new RandomAccessFile(this._archiveFileName, "r");
                try {
                    long archiveOffset;
                    this._fileLength = file222.length();
                    this._endOfCentralDirectoryRecord = this.getEndOfCentralDirectoryRecord(file222);
                    if (this.isZip64()) {
                        this._zip64EoCDRLocator = this.getZip64EoCDLocator(file222);
                        this._zip64EoCDRLocatorOffset = this._fileLength - (long)this._eocdRecordSize - 20L;
                        this._zip64EoCDR = this.getZip64EndOfCentralDirectoryRecord(file222);
                        this._zip64EoCDRecSize = this.getZip64EoCDRecordSize(this._zip64EoCDR, 0);
                    }
                    if (!this.archiveStartsWithSignature(file222, archiveOffset = this.getActualArchiveOffset())) break block7;
                    bl = true;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.artifact.zip.internal.ZipValidator", (String)"117", (Object)this, (Object[])new Object[0]);
                    try {
                        file222.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.artifact.zip.internal.ZipValidator", (String)"117", (Object)this, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                file222.close();
                return bl;
            }
            file222.close();
            return false;
        }
        catch (Exception file222) {
            FFDCFilter.processException((Throwable)file222, (String)"com.ibm.ws.artifact.zip.internal.ZipValidator", (String)"135", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"bad.zip.data", (Object[])new Object[]{this._archiveFileName});
        }
        return false;
    }

    private byte[] getEndOfCentralDirectoryRecord(RandomAccessFile file) throws IOException {
        byte[] block = this.getBlockFromEndOfFile(file, null, 256L, 256);
        if (block.length < 22) {
            throw new ZipException("Not a valid zip file.  Less than minimum required length. File [ " + this._archiveFileName + " ]");
        }
        int size = 22;
        int offset = block.length - size;
        int offsetFromEnd = block.length - offset;
        while (!this.isValidEoCDRec(block, offset, size)) {
            ++offsetFromEnd;
            if (++size > 65557 || (long)size > this._fileLength) {
                throw new ZipException("Cannot find central directory end record in zip. File [ " + this._archiveFileName + " ]");
            }
            if (offsetFromEnd > block.length) {
                block = this.getBlockFromEndOfFile(file, block, size + 256 - 22, 256);
                offsetFromEnd = 22;
            }
            offset = block.length - offsetFromEnd;
        }
        this._eocdRecordSize = size;
        return Arrays.copyOfRange(block, offset, offset + 22);
    }

    private byte[] getZip64EoCDLocator(RandomAccessFile file) throws IOException {
        if (!this.isZip64()) {
            return null;
        }
        byte[] block = this.getBlockFromEndOfFile(file, null, this._eocdRecordSize + 20, 20);
        if (!this.isValid_Zip64EoCDRLocator(block, 0)) {
            throw new ZipException("Invalid Zip64-End-of-Central-Direcytory-Locator. File [ " + this._archiveFileName + " ]");
        }
        return Arrays.copyOfRange(block, 0, 20);
    }

    private byte[] getZip64EndOfCentralDirectoryRecord(RandomAccessFile file) throws IOException {
        if (!this.isZip64()) {
            return null;
        }
        long zip64EoCDOffset = this.getLittleEndianValue(this._zip64EoCDRLocator, 8, 4);
        byte[] block = this.getBlockFromBeginningOfFile(file, null, zip64EoCDOffset, 56);
        if (block.length < 56) {
            throw new ZipException("Offset to Zip64-End-of-Central-Directory-Record is not correct.  Reached end of file. File [ " + this._archiveFileName + " ]");
        }
        long offsetFromBeginningOfFile = zip64EoCDOffset;
        int offsetInBlock = 0;
        int offsetFromStartingPoint = 0;
        boolean blockAllocatedInLoop = false;
        while (!this.isValid_Zip64EoCDRecord(block, offsetInBlock, offsetFromBeginningOfFile)) {
            ++offsetInBlock;
            ++offsetFromBeginningOfFile;
            if (++offsetFromStartingPoint > 0xC800000) {
                throw new ZipException("Failed to find the Zip64-End-of-Central-Directory-Record after searching 209715200 bytes. File [ " + this._archiveFileName + " ]");
            }
            if (offsetInBlock <= block.length - 4) continue;
            if (!blockAllocatedInLoop) {
                blockAllocatedInLoop = true;
                block = new byte[8192];
            }
            if ((block = this.getBlockFromBeginningOfFile(file, block, offsetFromBeginningOfFile, 8192)).length < 4) {
                throw new ZipException("Reached end of file while searching for Zip64-End-of-Central-Directory-Record. File [ " + this._archiveFileName + " ]");
            }
            offsetInBlock = 0;
        }
        if (block.length < offsetInBlock + 56) {
            block = this.getBlockFromBeginningOfFile(file, null, offsetFromBeginningOfFile, 56);
            return Arrays.copyOfRange(block, 0, 56);
        }
        return Arrays.copyOfRange(block, offsetInBlock, offsetInBlock + 56);
    }

    private byte[] getBlockFromEndOfFile(RandomAccessFile file, byte[] bytes, long offsetFromEnd, int sizeRequested) throws IOException {
        int sizeToRead = sizeRequested;
        if (offsetFromEnd > this._fileLength) {
            if (offsetFromEnd - (long)sizeRequested >= this._fileLength) {
                return new byte[0];
            }
            long adjustment = offsetFromEnd - this._fileLength;
            offsetFromEnd = this._fileLength;
            if ((sizeToRead = (int)((long)sizeToRead - adjustment)) < 0) {
                return new byte[0];
            }
        }
        long offset = this._fileLength > offsetFromEnd ? this._fileLength - offsetFromEnd : 0L;
        file.seek(offset);
        if (bytes == null || sizeToRead != sizeRequested) {
            bytes = new byte[sizeToRead];
        } else if (bytes.length != sizeRequested) {
            throw new IllegalArgumentException("The 'bytes' array parameter must be 'size' bytes in length. File [ " + this._archiveFileName + " ]");
        }
        int bytesRead = file.read(bytes, 0, sizeToRead);
        if (bytesRead != bytes.length) {
            throw new ZipException("Not enough bytes were read to fill the array. File [ " + this._archiveFileName + " ]");
        }
        return bytes;
    }

    private byte[] getBlockFromBeginningOfFile(RandomAccessFile file, byte[] bytes, long offset, int size) throws IOException {
        if (offset >= this._fileLength) {
            return new byte[0];
        }
        int blockLength = (long)size + offset > this._fileLength ? (int)(this._fileLength - offset) : size;
        file.seek(offset);
        if (bytes == null || blockLength != size) {
            bytes = new byte[blockLength];
        } else if (bytes.length != size) {
            throw new IllegalArgumentException("The 'bytes' array must be 'size' bytes in length. File [ " + this._archiveFileName + " ]");
        }
        int bytesRead = file.read(bytes, 0, size);
        if (bytesRead != bytes.length) {
            throw new ZipException("Not enough bytes were read to fill the array. File [ " + this._archiveFileName + " ]");
        }
        return bytes;
    }

    private boolean isValidEoCDRec(byte[] bytes, int offset, int centralDirEndRecSize) {
        if (!this.isSignature(bytes, offset, 1347093766)) {
            return false;
        }
        long commentLength = this.getLittleEndianValue(bytes, offset + 20, 2);
        return (long)centralDirEndRecSize == 22L + commentLength;
    }

    private boolean isSignature(byte[] bytes, int offset, int signature) {
        int value = this.getSignature(bytes, offset);
        return value == signature;
    }

    private boolean isValid_Zip64EoCDRecord(byte[] bytes, int offsetInByteArray, long offsetInFile) {
        if (!this.isSignature(bytes, offsetInByteArray, 1347094022)) {
            return false;
        }
        return this.isValid_Zip64EoCDRecordSize(bytes, offsetInByteArray, offsetInFile);
    }

    private boolean isValid_Zip64EoCDRLocator(byte[] bytes, int offset) {
        return this.isSignature(bytes, offset, 1347094023);
    }

    private boolean isValid_Zip64EoCDRecordSize(byte[] bytes, int offsetInArray, long offsetInFile) {
        long specifiedZip64EoCDRecSize = this.getZip64EoCDRecordSize(bytes, offsetInArray);
        if (specifiedZip64EoCDRecSize > this._fileLength - (long)this._eocdRecordSize - 20L) {
            return false;
        }
        long calculatedZip64EoCDRecSize = this._zip64EoCDRLocatorOffset - offsetInFile;
        return calculatedZip64EoCDRecSize == specifiedZip64EoCDRecSize;
    }

    private long getZip64EoCDRecordSize(byte[] bytes, int offsetInArray) {
        long specifiedZip64EoCDRecSize = this.getLittleEndianValue(bytes, offsetInArray + 4, 8);
        return specifiedZip64EoCDRecSize + 12L;
    }

    private long getLittleEndianValue(byte[] bytes, int offset, int length) {
        long value = 0L;
        for (int i = length - 1; i >= 0; --i) {
            value = value << 8 | (long)(bytes[offset + i] & 0xFF);
        }
        return value;
    }

    private int getSignature(byte[] bytes, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value = value << 8 | bytes[offset + i] & 0xFF;
        }
        return value;
    }

    private boolean isZip64() {
        return this.getLittleEndianValue(this._endOfCentralDirectoryRecord, 10, 2) == 65535L;
    }

    private boolean archiveStartsWithSignature(RandomAccessFile file, long archiveOffset) throws IOException {
        file.seek(archiveOffset);
        byte[] localFileHeaderSigBytes = new byte[4];
        file.read(localFileHeaderSigBytes, 0, 4);
        return this.isSignature(localFileHeaderSigBytes, 0, 1347093252);
    }

    private long getActualArchiveOffset() throws IOException {
        long lengthOfCentralDirectory = this.getLittleEndianValue(this._endOfCentralDirectoryRecord, 12, 4);
        long offsetOfCentralDirectory = this.getLittleEndianValue(this._endOfCentralDirectoryRecord, 16, 4);
        long zip64RecLengths = this.isZip64() ? this._zip64EoCDRecSize + 20L : 0L;
        return this._fileLength - (long)this._eocdRecordSize - zip64RecLengths - lengthOfCentralDirectory - offsetOfCentralDirectory;
    }
}

