/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.TaskErrorException;
import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationRegistry;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ListImportsAction
extends BaseAction {
    public ListImportsAction() {
        this.registerArguments("[serverName]");
    }

    @Override
    public String getActionName() {
        return "listImports";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        ServiceConfigurationRegistry registry = new ServiceConfigurationRegistry(Utils.getUserDir());
        Set<String> importedServiceNames = null;
        List<String> positionalArgs = arguments.getPositionalArguments();
        importedServiceNames = !positionalArgs.isEmpty() ? new HashSet<String>(registry.getServerImports(positionalArgs.get(0))) : registry.getServiceImports();
        this.printImports(importedServiceNames);
        return ReturnCode.OK;
    }

    private void printImports(Set<String> importedServiceNames) {
        if (!importedServiceNames.isEmpty()) {
            this.stdout.println(NLS.getOption("listImports.list.configurations", new Object[0]));
            this.stdout.println();
            for (String serviceName : importedServiceNames) {
                this.stdout.println(serviceName);
            }
        } else {
            this.stdout.println(NLS.getOption("listImports.no.configurations", new Object[0]));
        }
    }

    @Override
    protected void validateArguments(Arguments arguments) throws TaskErrorException {
    }
}

