/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.api;

import com.ibm.ws.bluemix.utility.api.ServiceConfiguration;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationException;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationWriter;
import com.ibm.ws.bluemix.utility.utils.DOMUtils;
import com.ibm.ws.bluemix.utility.utils.HttpRequestBuilder;
import com.ibm.ws.bluemix.utility.utils.IOUtils;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.SSLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceConfigurationRegistry {
    private static final Logger logger = Logger.getLogger(ServiceConfigurationRegistry.class.getName());
    private static final String IMPORT_FILE_SUFFIX = "-service.xml";
    private static Pattern VAR_PATTERN = Pattern.compile(Pattern.quote("${") + "(.+?)" + Pattern.quote("}"));
    private final File userDirectory;

    public ServiceConfigurationRegistry(File userDirectory) {
        this.userDirectory = userDirectory;
    }

    private File getUserDirectory() {
        return this.userDirectory;
    }

    private static File getServerConfigDirectory(File userDirectory, String serverName) {
        if (serverName == null) {
            throw new NullPointerException("serverName is null");
        }
        return new File(new File(userDirectory, "servers"), serverName);
    }

    private static File getServiceImportDirectory(File userDirectory, String serviceName) {
        File configDir = new File(userDirectory, "shared/config/services");
        File serviceDir = new File(configDir, serviceName);
        return serviceDir;
    }

    private void validateService(File serviceImportDir) {
        if (!serviceImportDir.exists()) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_SERVICE_CONFIGURATION", serviceImportDir.getName()));
        }
    }

    private void validateServer(File serverConfigDir) {
        if (!serverConfigDir.exists()) {
            throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_SERVER", serverConfigDir.getName()));
        }
    }

    public boolean hasService(String serviceName) {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        File serviceXmlFile = new File(serviceImportDir, "service.xml");
        return serviceXmlFile.exists();
    }

    public File getServiceImportDirectory(String serviceName) {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        return serviceImportDir;
    }

    private File getServiceConfigImportFile(File serverConfigDir, String serviceName) {
        File configDropinsDir = new File(serverConfigDir, "configDropins/defaults");
        File serviceConfigImport = new File(configDropinsDir, serviceName + IMPORT_FILE_SUFFIX);
        return serviceConfigImport;
    }

    public boolean isServiceBound(String serviceName, String serverName) {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        this.validateService(serviceImportDir);
        File serverConfigDir = ServiceConfigurationRegistry.getServerConfigDirectory(wlpUserDir, serverName);
        this.validateServer(serverConfigDir);
        File serviceConfigImport = this.getServiceConfigImportFile(serverConfigDir, serviceName);
        return serviceConfigImport.exists();
    }

    public Set<String> getServersBound(String serviceName) {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        this.validateService(serviceImportDir);
        HashSet<String> serversBound = new HashSet<String>();
        File serversDir = new File(wlpUserDir, "servers");
        File[] files = serversDir.listFiles();
        if (files != null) {
            for (File server : files) {
                File serviceConfigImport = this.getServiceConfigImportFile(server, serviceName);
                if (!serviceConfigImport.exists()) continue;
                serversBound.add(server.getName());
            }
        }
        return serversBound;
    }

    public boolean unbind(String serviceName, String serverName) throws ServiceConfigurationException {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        this.validateService(serviceImportDir);
        File serverConfigDir = ServiceConfigurationRegistry.getServerConfigDirectory(wlpUserDir, serverName);
        this.validateServer(serverConfigDir);
        File serviceConfigImport = this.getServiceConfigImportFile(serverConfigDir, serviceName);
        if (serviceConfigImport.exists()) {
            return serviceConfigImport.delete();
        }
        throw new IllegalArgumentException(NLS.getMessage("SERVICE_NOT_BOUND", serviceName, serverName));
    }

    public boolean uninstall(String serviceName) {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        this.validateService(serviceImportDir);
        return IOUtils.recursiveDelete(serviceImportDir);
    }

    public Set<String> getServiceImports() {
        File[] serviceDirs;
        File wlpUserDir = this.getUserDirectory();
        File configDir = new File(wlpUserDir, "shared/config/services");
        HashSet<String> importedServiceNames = new HashSet<String>();
        if (configDir.exists() && (serviceDirs = configDir.listFiles()) != null) {
            for (File singleService : serviceDirs) {
                File serviceXmlFile;
                if (!singleService.isDirectory() || !(serviceXmlFile = new File(singleService, "service.xml")).exists()) continue;
                importedServiceNames.add(singleService.getName());
            }
        }
        return importedServiceNames;
    }

    public Set<String> getServerImports(String serverName) {
        File serverConfigDir = ServiceConfigurationRegistry.getServerConfigDirectory(this.getUserDirectory(), serverName);
        this.validateServer(serverConfigDir);
        HashSet<String> importedServiceNames = new HashSet<String>();
        File configDropinsDir = new File(serverConfigDir, "configDropins/defaults");
        File[] serviceFiles = configDropinsDir.listFiles();
        if (serviceFiles != null) {
            for (File singleService : serviceFiles) {
                String serviceName;
                String serviceFileName = singleService.getName();
                if (!serviceFileName.endsWith(IMPORT_FILE_SUFFIX) || !this.hasService(serviceName = serviceFileName.substring(0, serviceFileName.length() - IMPORT_FILE_SUFFIX.length()))) continue;
                importedServiceNames.add(serviceName);
            }
        }
        return importedServiceNames;
    }

    public boolean bind(String serviceName, String serverName, Map<String, String> variables) throws ServiceConfigurationException {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        this.validateService(serviceImportDir);
        File serverConfigDir = ServiceConfigurationRegistry.getServerConfigDirectory(wlpUserDir, serverName);
        this.validateServer(serverConfigDir);
        File configDropinsDir = new File(serverConfigDir, "configDropins/defaults");
        if (!configDropinsDir.exists() && !configDropinsDir.mkdirs()) {
            throw new ServiceConfigurationException(NLS.getMessage("CONFIG_DROPINS_CREATE", serviceName, serverName, configDropinsDir));
        }
        File serviceXmlFile = new File(serviceImportDir, "service.xml");
        Document doc = this.readServiceXml(serviceName, serviceXmlFile);
        Map<String, String> validBindVariables = this.discoverServiceVariables(doc);
        Map<String, String> validatedVars = this.validateVariables(variables, validBindVariables.keySet(), serviceName);
        File serviceConfigImport = new File(configDropinsDir, serviceName + IMPORT_FILE_SUFFIX);
        boolean newBind = !serviceConfigImport.exists();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serviceConfigImport), "UTF8"));
            writer.write("<server>");
            writer.write("\r\n");
            writer.write("    <include location=\"${shared.config.dir}/services/" + serviceName + "/service.xml\"/>");
            if (validatedVars != null) {
                for (Map.Entry<String, String> variable : validatedVars.entrySet()) {
                    String varName = variable.getKey();
                    String name = serviceName + "." + varName;
                    String value = variable.getValue();
                    writer.write("\r\n    <variable name=\"" + name + "\" value=\"" + value + "\"/>");
                }
            }
            writer.write("\r\n");
            writer.write("</server>");
        }
        catch (IOException e) {
            try {
                throw new ServiceConfigurationException(NLS.getMessage("UNEXPECTED_REGISTRY_ERROR", e.getMessage()), e);
            }
            catch (Throwable throwable) {
                IOUtils.close(writer);
                throw throwable;
            }
        }
        IOUtils.close(writer);
        return newBind;
    }

    public boolean install(ServiceConfiguration serviceConfiguration) throws ServiceConfigurationException {
        return this.install(serviceConfiguration, null, null);
    }

    public boolean install(ServiceConfiguration serviceConfiguration, String encodeAlgorithm, String encodeKey) throws ServiceConfigurationException {
        String name = serviceConfiguration.getName();
        boolean newInstall = true;
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, name);
        if (!serviceImportDir.mkdirs()) {
            newInstall = false;
            boolean deleted = IOUtils.recursiveDelete(serviceImportDir);
            logger.log(Level.FINER, "Deleted existing import directory {0}: {1}.", new Object[]{serviceImportDir, deleted});
            if (!serviceImportDir.mkdirs()) {
                throw new ServiceConfigurationException(NLS.getMessage("CREATE_DIRECTORY_ERROR", serviceImportDir));
            }
        }
        this.writeServiceXml(serviceImportDir, serviceConfiguration, encodeAlgorithm, encodeKey);
        this.downloadLibraries(serviceImportDir, serviceConfiguration);
        return newInstall;
    }

    private void writeServiceXml(File serviceImportDir, ServiceConfiguration serviceConfiguration, String encodeAlgorithm, String encodeKey) throws ServiceConfigurationException {
        File serviceXmlFile = new File(serviceImportDir, "service.xml");
        ServiceConfigurationWriter writer = new ServiceConfigurationWriter();
        writer.setEncodeAlgorithm(encodeAlgorithm);
        writer.setEncodeKey(encodeKey);
        writer.write(serviceXmlFile, serviceConfiguration);
    }

    private void downloadLibraries(File serviceImportDir, ServiceConfiguration serviceConfiguration) throws ServiceConfigurationException {
        for (ServiceConfiguration.Library library : serviceConfiguration.getLibraries()) {
            try {
                this.downloadLibrary(serviceImportDir, library);
            }
            catch (UnknownHostException e) {
                throw new ServiceConfigurationException(NLS.getMessage("LIBRARY_UNKNOWN_HOST_ERROR", library.getUrl(), e.getMessage()), e);
            }
            catch (ConnectException e) {
                throw new ServiceConfigurationException(NLS.getMessage("LIBRARY_CONNECT_ERROR", library.getUrl(), e.getMessage()), e);
            }
            catch (SocketTimeoutException e) {
                throw new ServiceConfigurationException(NLS.getMessage("LIBRARY_TIMEOUT_ERROR", library.getUrl(), e.getMessage()), e);
            }
            catch (NoRouteToHostException e) {
                throw new ServiceConfigurationException(NLS.getMessage("LIBRARY_NO_ROUTE_ERROR", library.getUrl(), e.getMessage()), e);
            }
            catch (IOException e) {
                throw new ServiceConfigurationException(NLS.getMessage("LIBRARY_DOWNLOAD_ERROR", library.getUrl(), e.getMessage()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadLibrary(File serviceImportDir, ServiceConfiguration.Library library) throws IOException, ServiceConfigurationException {
        File file;
        String driverUrl = library.getUrl();
        File libraryFile = null;
        String targetPath = library.getTargetPath();
        if (targetPath == null) {
            targetPath = "lib/";
        }
        if (targetPath.endsWith("/")) {
            File targetDir = new File(serviceImportDir, targetPath);
            String name = ServiceConfigurationRegistry.getDriverName(driverUrl);
            libraryFile = new File(targetDir, name);
        } else {
            libraryFile = new File(serviceImportDir, targetPath);
        }
        logger.log(Level.FINE, "Downloading {0} to {1}.", new Object[]{driverUrl, libraryFile});
        this.validatePath(libraryFile);
        File parentDir = libraryFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new ServiceConfigurationException(NLS.getMessage("CREATE_DIRECTORY_ERROR", parentDir));
        }
        URL url = new URL(driverUrl);
        int connectionTimeout = 30000;
        int readTimeout = 90000;
        String userAgent = HttpRequestBuilder.DEFAULT_USER_AGENT;
        ReadableByteChannel source = null;
        FileChannel destination = null;
        try {
            URLConnection request = url.openConnection();
            String credentials = library.getCredentials();
            if (credentials != null) {
                request.setRequestProperty("Authorization", credentials);
            }
            request.setConnectTimeout(connectionTimeout);
            request.setReadTimeout(readTimeout);
            this.configureSSL(request);
            request.setRequestProperty("User-Agent", userAgent);
            source = Channels.newChannel(request.getInputStream());
            destination = new FileOutputStream(libraryFile).getChannel();
            long bytesRead = 0L;
            while ((bytesRead = destination.transferFrom(source, bytesRead, Integer.MAX_VALUE)) > 0L) {
            }
            logger.log(Level.FINE, "Download complete for {0}.", driverUrl);
            file = libraryFile;
        }
        catch (Throwable throwable) {
            IOUtils.close(destination);
            IOUtils.close(source);
            throw throwable;
        }
        IOUtils.close(destination);
        IOUtils.close(source);
        return file;
    }

    private void configureSSL(URLConnection request) throws IOException {
        if (request instanceof HttpsURLConnection) {
            try {
                ((HttpsURLConnection)request).setSSLSocketFactory(SSLUtils.createDefaultSSLSocketFactory());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private static String getDriverName(String driverURL) {
        int nameIndex = driverURL.lastIndexOf(47) + 1;
        String name = driverURL.substring(nameIndex);
        return name;
    }

    private void validatePath(File file) throws ServiceConfigurationException {
        try {
            String filePath;
            String userDirectoryPath = this.userDirectory.getCanonicalPath();
            if (!userDirectoryPath.endsWith(File.separator)) {
                userDirectoryPath = userDirectoryPath + File.separator;
            }
            if (!(filePath = file.getCanonicalPath()).startsWith(userDirectoryPath)) {
                throw new ServiceConfigurationException(NLS.getMessage("INVALID_PATH_ERROR", userDirectoryPath, filePath));
            }
        }
        catch (IOException e) {
            throw new ServiceConfigurationException(NLS.getMessage("UNEXPECTED_REGISTRY_ERROR", e.getMessage()), e);
        }
    }

    private Map<String, String> validateVariables(Map<String, String> inputVars, Set<String> validBindVariables, String serviceName) {
        HashMap<String, String> validVars = new HashMap<String, String>();
        if (inputVars != null) {
            for (Map.Entry<String, String> variable : inputVars.entrySet()) {
                String varName = variable.getKey();
                boolean isValid = false;
                for (String validName : validBindVariables) {
                    if (!varName.equalsIgnoreCase(validName)) continue;
                    isValid = true;
                    validVars.put(validName, variable.getValue());
                    break;
                }
                if (isValid) continue;
                throw new IllegalArgumentException(NLS.getMessage("NO_SUCH_BIND_VARIABLE", serviceName, varName));
            }
        }
        return validVars;
    }

    private Map<String, String> discoverServiceVariables(Document doc) {
        HashMap<String, String> validBindVariables = new HashMap<String, String>();
        Element root = doc.getDocumentElement();
        NodeList varElements = root.getElementsByTagName("variable");
        if (varElements != null) {
            for (int i = 0; i < varElements.getLength(); ++i) {
                Element variable = (Element)varElements.item(i);
                String fullName = variable.getAttribute("name");
                String varName = fullName.substring(fullName.indexOf(".") + 1);
                String value = variable.getAttribute("value");
                validBindVariables.put(varName, value);
            }
        }
        return validBindVariables;
    }

    public Map<String, String> getServiceVariables(String serviceName) throws ServiceConfigurationException {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        this.validateService(serviceImportDir);
        File serviceXmlFile = new File(serviceImportDir, "service.xml");
        Document doc = this.readServiceXml(serviceName, serviceXmlFile);
        return this.discoverServiceVariables(doc);
    }

    public Set<String> getServiceFeatures(String serviceName) throws ServiceConfigurationException {
        File wlpUserDir = this.getUserDirectory();
        File serviceImportDir = ServiceConfigurationRegistry.getServiceImportDirectory(wlpUserDir, serviceName);
        this.validateService(serviceImportDir);
        File serviceXmlFile = new File(serviceImportDir, "service.xml");
        Document doc = this.readServiceXml(serviceName, serviceXmlFile);
        return this.getFeaturesFromXml(doc, serviceName);
    }

    private Set<String> getFeaturesFromXml(Document doc, String serviceName) throws ServiceConfigurationException {
        HashSet<String> features = new HashSet<String>();
        Map<String, String> variables = this.getServiceVariables(serviceName);
        Element root = doc.getDocumentElement();
        NodeList featureManagerList = root.getElementsByTagName("featureManager");
        if (featureManagerList != null) {
            for (int i = 0; i < featureManagerList.getLength(); ++i) {
                Element featueManagerElement = (Element)featureManagerList.item(i);
                NodeList featureList = featueManagerElement.getElementsByTagName("feature");
                if (featureList == null) continue;
                for (int j = 0; j < featureList.getLength(); ++j) {
                    Node featureNode = featureList.item(j);
                    String featureName = featureNode.getTextContent();
                    String converted = ServiceConfigurationRegistry.convertVariableRef(featureName, variables);
                    if (converted == null) continue;
                    features.add(converted);
                }
            }
        }
        return features;
    }

    private static String convertVariableRef(String name, Map<String, String> variables) {
        Matcher matcher = VAR_PATTERN.matcher(name);
        while (matcher.find()) {
            String var = matcher.group(1);
            String value = variables.get(var);
            if (value == null) continue;
            name = name.replace(matcher.group(0), value);
            matcher.reset(name);
        }
        return name;
    }

    private Document readServiceXml(String serviceName, File file) throws ServiceConfigurationException {
        try {
            return DOMUtils.load(file);
        }
        catch (Exception e) {
            throw new ServiceConfigurationException(NLS.getMessage("CONFIGURATION_READ_ERROR", serviceName, e.getMessage()), e);
        }
    }

    public boolean requiresLicenseCheck(ServiceConfiguration configuration) {
        List<ServiceConfiguration.Library> libraries = configuration.getLibraries();
        if (libraries != null) {
            for (ServiceConfiguration.Library library : libraries) {
                String license = library.getLicense();
                if (license == null) continue;
                return true;
            }
        }
        return false;
    }
}

