/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.credentials;

import com.ibm.ws.bluemix.utility.credentials.TargetInfo;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BluemixProperties {
    private static final String ACCESS_TOKEN_KEY = "token";
    private static final String AUTH_ENDPOINT_KEY = "authorization_endpoint";
    private static final String REFRESH_TOKEN_KEY = "refresh_token";
    private static final String SPACE_KEY = "space";
    private static final String SPACE_GUID_KEY = "space_guid";
    private static final String ORG_KEY = "organization";
    private static final String ORG_GUID_KEY = "organization_guid";
    private static final String API_KEY = "api";

    private static File getBluemixPropertiesFile() {
        return new File(System.getProperty("user.home"), ".ibm.wlp" + File.separator + "bluemix.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetInfo load() throws IOException {
        File configFile = BluemixProperties.getBluemixPropertiesFile();
        if (!FileUtils.fileExists((File)configFile)) {
            return null;
        }
        InputStream in = null;
        try {
            in = FileUtils.getInputStream((File)configFile);
            Properties props = new Properties();
            props.load(in);
            TargetInfo targetInfo = BluemixProperties.toTargetInfo(props);
            return targetInfo;
        }
        finally {
            FileUtils.tryToClose((Closeable)in);
        }
    }

    private static TargetInfo toTargetInfo(Properties props) {
        TargetInfo targetInfo = new TargetInfo();
        targetInfo.setAPI(props.getProperty(API_KEY));
        targetInfo.setAuthorizationEndpoint(props.getProperty(AUTH_ENDPOINT_KEY));
        targetInfo.setAccessToken(props.getProperty(ACCESS_TOKEN_KEY));
        targetInfo.setRefreshToken(props.getProperty(REFRESH_TOKEN_KEY));
        targetInfo.setOrganizationName(props.getProperty(ORG_KEY));
        targetInfo.setOrganizationGuid(props.getProperty(ORG_GUID_KEY));
        targetInfo.setSpaceName(props.getProperty(SPACE_KEY));
        targetInfo.setSpaceGuid(props.getProperty(SPACE_GUID_KEY));
        return targetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(TargetInfo targetInfo) throws IOException {
        File propsFile = BluemixProperties.getBluemixPropertiesFile();
        FileUtils.fileMkDirs((File)propsFile.getParentFile());
        FileUtils.fileCreate((File)propsFile);
        FileUtils.setUserReadWriteOnly((File)propsFile);
        FileOutputStream output = null;
        try {
            output = FileUtils.getFileOutputStream((File)propsFile);
            Properties props = BluemixProperties.toProperties(targetInfo);
            props.store(output, null);
        }
        finally {
            FileUtils.tryToClose((Closeable)output);
        }
    }

    private static Properties toProperties(TargetInfo target) {
        Properties props = new Properties();
        if (target.getAPI() != null) {
            props.setProperty(API_KEY, target.getAPI());
        }
        if (target.getAuthorizationEndpoint() != null) {
            props.setProperty(AUTH_ENDPOINT_KEY, target.getAuthorizationEndpoint());
        }
        if (target.getAccessToken() != null) {
            props.setProperty(ACCESS_TOKEN_KEY, new String(target.getAccessToken().getChars()));
        }
        if (target.getRefreshToken() != null) {
            props.setProperty(REFRESH_TOKEN_KEY, new String(target.getRefreshToken().getChars()));
        }
        if (target.getOrganizationName() != null) {
            props.setProperty(ORG_KEY, target.getOrganizationName());
        }
        if (target.getOrganizationGuid() != null) {
            props.setProperty(ORG_GUID_KEY, target.getOrganizationGuid());
        }
        if (target.getSpaceName() != null) {
            props.setProperty(SPACE_KEY, target.getSpaceName());
        }
        if (target.getSpaceGuid() != null) {
            props.setProperty(SPACE_GUID_KEY, target.getSpaceGuid());
        }
        return props;
    }
}

