/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import java.io.IOException;

public class AsyncException
extends IOException {
    private static final long serialVersionUID = 5894453373641317981L;
    static final int AIO_INTERNAL_ERROR = -99;
    private final int errorCode;
    private final String platformMessage;

    AsyncException(String message, String platformMessage, int errorCode) {
        super(message);
        this.errorCode = errorCode;
        this.platformMessage = platformMessage;
    }

    public AsyncException(String message) {
        super(message);
        this.errorCode = -99;
        this.platformMessage = "Async IO Internal Error";
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName());
        buffer.append("(");
        buffer.append(this.getLocalizedMessage());
        buffer.append(", [");
        if (this.errorCode == -99) {
            buffer.append("Internal Error");
        } else {
            buffer.append(this.platformMessage.trim());
            buffer.append(", rc=");
            buffer.append(this.errorCode);
        }
        buffer.append("])");
        return buffer.toString();
    }
}

