/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.udpchannel.internal.UDPChannelConfiguration;
import com.ibm.ws.udpchannel.internal.UDPFilterList;
import java.net.Inet6Address;
import java.net.InetAddress;

public class AccessLists {
    protected UDPFilterList excludeAccess = null;
    protected UDPFilterList includeAccess = null;
    private static final TraceComponent tc = Tr.register(AccessLists.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");

    public AccessLists(UDPFilterList _excludeAccess, UDPFilterList _includeAccess) {
        this.excludeAccess = _excludeAccess;
        this.includeAccess = _includeAccess;
    }

    protected static AccessLists getInstance(UDPChannelConfiguration config) {
        AccessLists retVal = null;
        boolean haveAList = false;
        UDPFilterList excludeAccess = null;
        UDPFilterList includeAccess = null;
        String[] sExclude = config.getAddressExcludeList();
        excludeAccess = new UDPFilterList();
        if (sExclude != null) {
            excludeAccess.buildData(sExclude, false);
            excludeAccess.setActive(true);
            haveAList = true;
        }
        String[] sInclude = config.getAddressIncludeList();
        includeAccess = new UDPFilterList();
        if (sInclude != null) {
            includeAccess.buildData(sInclude, false);
            includeAccess.setActive(true);
            haveAList = true;
        }
        if (haveAList) {
            retVal = new AccessLists(excludeAccess, includeAccess);
        }
        return retVal;
    }

    public boolean accessDenied(InetAddress remoteAddr) {
        if (this.includeAccess.getActive()) {
            boolean allOk = false;
            if (remoteAddr instanceof Inet6Address) {
                if (this.includeAccess.findInList6(remoteAddr.getAddress())) {
                    allOk = true;
                }
            } else if (this.includeAccess.findInList(remoteAddr.getAddress())) {
                allOk = true;
            }
            if (!allOk) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Address and host name not in include list, address: " + remoteAddr.getHostAddress() + " host name: " + remoteAddr.getHostName()), (Object[])new Object[0]);
                }
                return true;
            }
        }
        if (this.excludeAccess.getActive()) {
            if (remoteAddr instanceof Inet6Address) {
                if (this.excludeAccess.findInList6(remoteAddr.getAddress())) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Address (IPv6) in exclude list, address: " + remoteAddr.getHostAddress()), (Object[])new Object[0]);
                    }
                    return true;
                }
            } else if (this.excludeAccess.findInList(remoteAddr.getAddress())) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Address in exclude list, address: " + remoteAddr.getHostAddress()), (Object[])new Object[0]);
                }
                return true;
            }
        }
        return false;
    }
}

