/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.udpchannel.internal.BufferDump;
import com.ibm.ws.udpchannel.internal.NIOChannelModRequest;
import com.ibm.ws.udpchannel.internal.UDPBufferFactory;
import com.ibm.ws.udpchannel.internal.UDPChannel;
import com.ibm.ws.udpchannel.internal.UDPChannelFactory;
import com.ibm.ws.udpchannel.internal.UDPConnLink;
import com.ibm.ws.udpchannel.internal.UDPNetworkLayer;
import com.ibm.ws.udpchannel.internal.UDPReadRequestContextImpl;
import com.ibm.ws.udpchannel.internal.UDPRequestContextImpl;
import com.ibm.ws.udpchannel.internal.UDPSelectorMonitor;
import com.ibm.ws.udpchannel.internal.UDPWriteRequestContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.DiscriminationProcessException;
import com.ibm.wsspi.channelfw.objectpool.CircularObjectPool;
import com.ibm.wsspi.channelfw.objectpool.ObjectPool;
import com.ibm.wsspi.udpchannel.UDPWriteCompletedCallback;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkQueueManager
implements UDPSelectorMonitor {
    protected static final TraceComponent tc = Tr.register(WorkQueueManager.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    static final AtomicInteger numWorkerThreads = new AtomicInteger(0);
    private boolean shutdown = false;
    private Selector selector = null;
    private Thread selectorThread = null;
    private final long selectorTimeout = 10000L;
    private WsByteBufferPoolManager byteBufferManager = null;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private static final int OBJ_SIZE = 100;
    private VirtualConnectionFactory vcFactory = null;
    private final Object channelRequestingToBeAddedRemovedSync = new Object(){};
    private boolean channelRequestingToBeAddedRemoved = false;
    private final Map<DatagramChannel, SelectionKey> channelToSelectionKeyMap = new HashMap<DatagramChannel, SelectionKey>();
    private final List<NIOChannelModRequest> channelModList = new ArrayList<NIOChannelModRequest>();
    private final Object lock = new Object(){};
    private boolean readAlways = false;
    private int numReceivesBeforeNewWorker = 10;
    private int numFailuresBeforeWorkerDie = 3;
    private UDPWriteRequestContextImpl outstandingWriteRequest = null;
    private final Object outstandingWriteLock = new Object(){};
    private SelectorTask selectorTask = null;
    private long selectorThreadId = 0L;
    private boolean isBufferDumpEnabled = false;
    private final ObjectPool multiThreadedObjectPool = new CircularObjectPool(100);

    public WorkQueueManager(UDPChannelFactory udpFactory) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"WorkQueueManager", (Object[])new Object[0]);
        }
        this.byteBufferManager = WsByteBufferPoolManagerImpl.getRef();
        this.vcFactory = udpFactory.getVCFactory();
        this.selector = Selector.open();
        this.selectorTask = new SelectorTask();
        this.selectorThread = new Thread(this.selectorTask);
        this.selectorThread.setName("UDP WorkQueueManager Thread:" + numWorkerThreads.incrementAndGet());
        this.selectorThread.setDaemon(true);
        this.selectorThread.start();
        this.selectorThreadId = this.selectorThread.getId();
        String value = (String)udpFactory.getProperties().get("numReceivesBeforeNewWorker");
        if (value != null && 0 < value.length()) {
            this.numReceivesBeforeNewWorker = Integer.parseInt(value);
        }
        if ((value = (String)udpFactory.getProperties().get("numFailuresBeforeWorkerDie")) != null && 0 < value.length()) {
            this.numFailuresBeforeWorkerDie = Integer.parseInt(value);
        }
        if ((value = (String)udpFactory.getProperties().get("udpChannelBufferDumpEnabled")) != null && 0 < value.length()) {
            this.isBufferDumpEnabled = Boolean.parseBoolean(value);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("bufferDumpEnabled is " + value), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Creating new WQM with thread id: " + this.selectorThreadId), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"WorkQueueManager");
        }
    }

    public void addRef() {
        this.refCount.incrementAndGet();
    }

    public int decRef() {
        return this.refCount.decrementAndGet();
    }

    public void shutdown() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"shutdown", (Object[])new Object[0]);
        }
        if (this.decRef() <= 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Reference Count is 0 so shutting down.", (Object[])new Object[0]);
            }
            this.shutdown = true;
            this.selector.wakeup();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setChannel(DatagramChannel channel, UDPNetworkLayer udpNetworkLayer) throws IOException {
        int interestOps = 0;
        if (udpNetworkLayer.getUDPChannel().getConfig().isInboundChannel()) {
            interestOps = 1;
        }
        NIOChannelModRequest request = new NIOChannelModRequest(1, channel, interestOps, udpNetworkLayer);
        Object object = this.channelModList;
        synchronized (object) {
            this.channelModList.add(request);
        }
        object = this.channelRequestingToBeAddedRemovedSync;
        synchronized (object) {
            this.channelRequestingToBeAddedRemoved = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Adding channel for port: " + channel.socket().getLocalPort() + " to WQM : " + this.hashCode()), (Object[])new Object[0]);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeChannel(DatagramChannel channel) {
        NIOChannelModRequest request = new NIOChannelModRequest(2, channel, 0, null);
        Object object = this.channelModList;
        synchronized (object) {
            this.channelModList.add(request);
        }
        object = this.channelRequestingToBeAddedRemovedSync;
        synchronized (object) {
            this.channelRequestingToBeAddedRemoved = true;
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChannelInSelector(DatagramChannel channel, UDPNetworkLayer udpNetworkLayer, int interestMask, int interestOperand) throws IOException {
        NIOChannelModRequest request = new NIOChannelModRequest(3, channel, interestMask, interestOperand, udpNetworkLayer);
        Object object = this.channelModList;
        synchronized (object) {
            this.channelModList.add(request);
        }
        object = this.channelRequestingToBeAddedRemovedSync;
        synchronized (object) {
            this.channelRequestingToBeAddedRemoved = true;
        }
        if (Thread.currentThread().getId() != this.selectorThreadId) {
            this.selector.wakeup();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("selector.wakeup() for selector " + this.selector.hashCode()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChannelMods() throws IOException {
        List<NIOChannelModRequest> list = this.channelModList;
        synchronized (list) {
            for (NIOChannelModRequest request : this.channelModList) {
                if (request.getRequestType() == 3) {
                    this.handleModRequest(request);
                    continue;
                }
                if (request.getRequestType() == 1) {
                    Selector selector = this.selector;
                    synchronized (selector) {
                        SelectionKeyAttachment attachment = new SelectionKeyAttachment(request.getNetworkLayer());
                        SelectionKey selectionKey = request.getChannel().register(this.selector, request.getInterestMask(), attachment);
                        this.channelToSelectionKeyMap.put(request.getChannel(), selectionKey);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Added channel with interestOps " + request.getInterestMask()), (Object[])new Object[0]);
                    continue;
                }
                if (request.getRequestType() != 2) continue;
                this.handleRemoveRequest(request);
            }
            this.channelModList.clear();
        }
    }

    private void handleModRequest(NIOChannelModRequest request) {
        block9: {
            SelectionKey selectionKey = this.channelToSelectionKeyMap.get(request.getChannel());
            if (selectionKey == null) {
                return;
            }
            if (!selectionKey.isValid()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Ignoring mod attempt on invalid key; " + selectionKey.hashCode()), (Object[])new Object[0]);
                }
                return;
            }
            try {
                int currentOps;
                int newOps = currentOps = selectionKey.interestOps();
                if (request.getInterestOperator() == 2) {
                    newOps |= request.getInterestMask();
                } else if (request.getInterestOperator() == 1) {
                    newOps &= request.getInterestMask();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Modified interest ops old=" + currentOps + " new=" + newOps + " for channel " + selectionKey.hashCode()), (Object[])new Object[0]);
                }
                selectionKey.interestOps(newOps);
            }
            catch (CancelledKeyException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Error modifying cancelled key; " + selectionKey.hashCode()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoveRequest(NIOChannelModRequest request) {
        DatagramChannel channel = request.getChannel();
        if (null == channel) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Removing channel; " + channel), (Object[])new Object[0]);
        }
        Selector selector = this.selector;
        synchronized (selector) {
            this.channelToSelectionKeyMap.remove(channel);
            SelectionKey selectionKey = channel.keyFor(this.selector);
            if (selectionKey != null) {
                selectionKey.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualConnection processWriteRequest(UDPWriteRequestContextImpl writeRequest, boolean forceWrite) {
        VirtualConnection vc = null;
        Object object = this.outstandingWriteLock;
        synchronized (object) {
            block14: {
                boolean writeIt = false;
                if (forceWrite) {
                    writeIt = true;
                } else {
                    if (this.outstandingWriteRequest == null) {
                        writeIt = true;
                    }
                    writeIt = !writeRequest.isForceQueue();
                }
                if (writeIt) {
                    try {
                        vc = this.doPhysicalWrite(writeRequest);
                    }
                    catch (IOException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Error writing message, discarding message. " + e.getMessage()), (Object[])new Object[0]);
                        }
                        this.outstandingWriteRequest = null;
                        vc = writeRequest.getConnLink().getVirtualConnection();
                    }
                } else {
                    this.outstandingWriteRequest = writeRequest;
                    try {
                        this.setChannelInSelector(writeRequest.getConnLink().getUDPNetworkLayer().getDatagramChannel(), writeRequest.getConnLink().getUDPNetworkLayer(), 4, 2);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Turning on WRITE from processWriteRequest", (Object[])new Object[0]);
                        }
                    }
                    catch (IOException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Error while setChannelInSelector. " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
        }
        return vc;
    }

    private VirtualConnection doPhysicalWrite(UDPWriteRequestContextImpl writeRequest) throws IOException {
        VirtualConnection vc = null;
        this.outstandingWriteRequest = writeRequest;
        UDPConnLink connLink = writeRequest.getConnLink();
        UDPNetworkLayer udpPort = connLink.getUDPNetworkLayer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.isBufferDumpEnabled) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("BUFFER TO ADDRESS " + writeRequest.getAddress()), (Object[])new Object[0]);
            String dumpedBuffer = BufferDump.getHexDump(writeRequest.getBuffer().getWrappedByteBuffer(), true);
            Tr.debug((Object)this, (TraceComponent)tc, (String)dumpedBuffer, (Object[])new Object[0]);
        }
        int numWritten = 1;
        try {
            numWritten = udpPort.send(writeRequest.getBuffer(), writeRequest.getAddress());
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Caught exception " + e.toString() + " while sending data.  Packet is lost."), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"1", (Object)this);
        }
        if (numWritten != 0) {
            this.outstandingWriteRequest = null;
            vc = writeRequest.getConnLink().getVirtualConnection();
        } else {
            this.setChannelInSelector(writeRequest.getConnLink().getUDPNetworkLayer().getDatagramChannel(), writeRequest.getConnLink().getUDPNetworkLayer(), 4, 2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Turning on WRITE from doPhysicalWrite", (Object[])new Object[0]);
            }
        }
        return vc;
    }

    private void setupReadOp(UDPReadRequestContextImpl readRequest) {
        block3: {
            try {
                SelectionKey selectionKey;
                this.setChannelInSelector(readRequest.getConnLink().getUDPNetworkLayer().getDatagramChannel(), readRequest.getConnLink().getUDPNetworkLayer(), 1, 2);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && (selectionKey = this.channelToSelectionKeyMap.get(readRequest.getConnLink().getUDPNetworkLayer().getDatagramChannel())) != null) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Turning on READ from processReadRequest for channel " + selectionKey.hashCode()), (Object[])new Object[0]);
                }
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("setupReadOp IOException caught. " + e), (Object[])new Object[0]);
            }
        }
    }

    private VirtualConnection processReadRequest(UDPReadRequestContextImpl readRequest) {
        VirtualConnection vc;
        block11: {
            vc = null;
            if (readRequest.isForceQueue() || readRequest.isReadAlwaysCalled()) {
                this.setupReadOp(readRequest);
                if (readRequest.isReadAlwaysCalled()) {
                    this.readAlways = true;
                }
            } else {
                if (this.readAlways && !readRequest.isReadAlwaysCalled()) {
                    this.readAlways = false;
                    try {
                        this.setChannelInSelector(readRequest.getConnLink().getUDPNetworkLayer().getDatagramChannel(), readRequest.getConnLink().getUDPNetworkLayer(), -2, 1);
                    }
                    catch (IOException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("processReadRequest caught " + e), (Object[])new Object[0]);
                        }
                        break block11;
                    }
                }
                UDPNetworkLayer networkLayer = readRequest.getConnLink().getUDPNetworkLayer();
                WsByteBuffer buffer = this.byteBufferManager.allocateDirect(networkLayer.getUDPChannel().getConfig().getChannelReceiveBufferSize());
                try {
                    SocketAddress address = networkLayer.receive(buffer);
                    if (address != null) {
                        readRequest.setBuffer(buffer, address, false);
                        vc = readRequest.getConnLink().getVirtualConnection();
                    } else {
                        buffer.release();
                        this.setupReadOp(readRequest);
                    }
                }
                catch (IOException e) {
                    buffer.release();
                }
            }
        }
        return vc;
    }

    public VirtualConnection processWork(UDPRequestContextImpl req) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"processWork", (Object[])new Object[0]);
        }
        VirtualConnection vc = null;
        if (req.isRead()) {
            UDPReadRequestContextImpl readRequest = (UDPReadRequestContextImpl)req;
            vc = this.processReadRequest(readRequest);
        } else {
            UDPWriteRequestContextImpl writeRequest = (UDPWriteRequestContextImpl)req;
            vc = this.processWriteRequest(writeRequest, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)("processWork: " + vc));
        }
        return vc;
    }

    private void sendToDiscriminaters(VirtualConnection vc, UDPReadRequestContextImpl readRequest, UDPChannel udpChannel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"sendToDiscriminaters", (Object[])new Object[0]);
        }
        int state = 0;
        try {
            state = udpChannel.getDiscriminationProcess().discriminate(vc, readRequest.getUDPBuffer().getBuffer(), readRequest.getConnLink());
        }
        catch (DiscriminationProcessException dpe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Exception occurred while discriminating data received from client ", (Object[])new Object[0]);
            }
            readRequest.getConnLink().close(vc, new IOException("Discrimination failed", dpe));
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Discrimination returned " + state), (Object[])new Object[0]);
        }
        if (state == 1) {
            ConnectionReadyCallback cb = readRequest.getConnLink().getApplicationCallback();
            if (cb != null) {
                this.dispatchWorker(new Worker(cb, vc));
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"No application callback found, closing connection", (Object[])new Object[0]);
                }
                readRequest.getConnLink().close(vc, null);
            }
        } else if (state == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Discrimination failed, no one claimed data even after 1 complete buffer presented - probably garbage passed in", (Object[])new Object[0]);
            }
            readRequest.getConnLink().close(vc, null);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Error occurred while discriminating data received from client", (Object[])new Object[0]);
            }
            readRequest.getConnLink().close(vc, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"sendToDiscriminaters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWrite(SelectionKey key) {
        Object object = this.outstandingWriteLock;
        synchronized (object) {
            block10: {
                try {
                    if (this.outstandingWriteRequest != null) {
                        UDPWriteRequestContextImpl request = this.outstandingWriteRequest;
                        VirtualConnection vc = this.processWriteRequest(this.outstandingWriteRequest, true);
                        if (vc != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Turning off WRITE from selector thread", (Object[])new Object[0]);
                            }
                            this.setChannelInSelector(request.getConnLink().getUDPNetworkLayer().getDatagramChannel(), request.getConnLink().getUDPNetworkLayer(), -5, 1);
                            UDPWriteCompletedCallback callback = request.getWriteCallback();
                            if (callback != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Calling completed callback.", (Object[])new Object[0]);
                                }
                                callback.complete(vc, request);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error while setChannelInSelector. " + e), (Object[])new Object[0]);
                }
            }
        }
    }

    protected boolean handleRead(SelectionKey key, UDPNetworkLayer networkLayer) {
        boolean returnValue;
        block21: {
            returnValue = true;
            try {
                WsByteBuffer buffer = this.byteBufferManager.allocateDirect(networkLayer.getUDPChannel().getConfig().getChannelReceiveBufferSize());
                SocketAddress address = networkLayer.receive(buffer);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.isBufferDumpEnabled && address != null) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("BUFFER FROM ADDRESS " + address), (Object[])new Object[0]);
                    String dumpedBuffer = BufferDump.getHexDump(buffer.getWrappedByteBuffer(), false);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)dumpedBuffer, (Object[])new Object[0]);
                }
                if (address != null) {
                    UDPConnLink udpConnLink = networkLayer.getConnLink();
                    if (!this.readAlways) {
                        this.setChannelInSelector(networkLayer.getDatagramChannel(), networkLayer, -2, 1);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Turning off READ from selector thread", (Object[])new Object[0]);
                        }
                    }
                    if (udpConnLink == null) {
                        try {
                            VirtualConnection vc = this.vcFactory.createConnection();
                            udpConnLink = (UDPConnLink)networkLayer.getUDPChannel().getConnectionLink(vc);
                            networkLayer.setConnLink(udpConnLink);
                            udpConnLink.setUDPNetworkLayer(networkLayer);
                            vc.getStateMap().put("UDPConfiguredListeningHost", networkLayer.getConfiguredBindAddress());
                            vc.getStateMap().put("UDPConfiguredListeningPort", networkLayer.getListenPort());
                            UDPReadRequestContextImpl readRequest = (UDPReadRequestContextImpl)udpConnLink.getReadInterface();
                            readRequest.setBuffer(buffer, address, true);
                            this.sendToDiscriminaters(vc, readRequest, networkLayer.getUDPChannel());
                        }
                        catch (ChainException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error creating VC " + e.getMessage()), (Object[])new Object[0]);
                            }
                            break block21;
                        }
                        catch (ChannelException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("Error creating VC " + e.getMessage()), (Object[])new Object[0]);
                            }
                            break block21;
                        }
                    }
                    if (!this.readAlways) {
                        UDPReadRequestContextImpl readRequest = (UDPReadRequestContextImpl)udpConnLink.getReadInterface();
                        boolean bufferSet = readRequest.setBuffer(buffer, address, false);
                        if (bufferSet) {
                            this.dispatchWorker(new Worker(readRequest));
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"setBuffer returned false, not calling back with buffer", (Object[])new Object[0]);
                        }
                    } else {
                        UDPReadRequestContextImpl readRequest = (UDPReadRequestContextImpl)udpConnLink.getReadInterface();
                        readRequest.complete(UDPBufferFactory.getUDPBuffer(buffer, address));
                    }
                    break block21;
                }
                buffer.release();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Read event but there was nothing to read", (Object[])new Object[0]);
                }
                returnValue = false;
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error in handleRead. " + e), (Object[])new Object[0]);
                }
                returnValue = false;
            }
            catch (Throwable e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Error in handleRead. " + e), (Object[])new Object[0]);
                }
                returnValue = false;
            }
        }
        return returnValue;
    }

    protected boolean dispatchWorker(Runnable worker) {
        ExecutorService executorService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Dispatching: " + worker), (Object[])new Object[0]);
        }
        if (null == (executorService = CHFWBundle.getExecutorService())) {
            Tr.error((TraceComponent)tc, (String)"EXECUTOR_SVC_MISSING", (Object[])new Object[0]);
            throw new RuntimeException("Missing executor service");
        }
        executorService.execute(worker);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiThreadedWorker getMultiThreadedWorker(SelectionKey key, long threadIdfWQM) {
        MultiThreadedWorker worker = null;
        ObjectPool objectPool = this.multiThreadedObjectPool;
        synchronized (objectPool) {
            worker = (MultiThreadedWorker)this.multiThreadedObjectPool.get();
        }
        if (worker == null) {
            worker = new MultiThreadedWorker(this);
        }
        worker.set(key);
        return worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(MultiThreadedWorker object) {
        object.clear();
        ObjectPool objectPool = this.multiThreadedObjectPool;
        synchronized (objectPool) {
            this.multiThreadedObjectPool.put(object);
        }
    }

    protected class Worker
    implements Runnable {
        private UDPReadRequestContextImpl req = null;
        private ConnectionReadyCallback cb = null;
        private VirtualConnection vc = null;

        protected Worker(UDPReadRequestContextImpl reqIn) {
            this.req = reqIn;
        }

        protected Worker(ConnectionReadyCallback cb, VirtualConnection vc) {
            this.cb = cb;
            this.vc = vc;
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)("Running " + this), (Object[])new Object[0]);
            }
            if (this.req != null) {
                this.req.complete();
            } else if (this.cb != null) {
                this.cb.ready(this.vc);
            }
        }
    }

    protected class MultiThreadedWorker
    implements Runnable {
        private SelectionKey key = null;
        private WorkQueueManager factory = null;

        protected MultiThreadedWorker(SelectionKey key) {
            this.key = key;
        }

        protected MultiThreadedWorker(WorkQueueManager factory) {
            this.factory = factory;
        }

        public void set(SelectionKey key) {
            this.key = key;
        }

        public void release() {
            if (this.factory != null) {
                this.factory.release(this);
            }
        }

        public void clear() {
            this.key = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SelectionKeyAttachment attachment = (SelectionKeyAttachment)this.key.attachment();
            try {
                attachment.incNumThreadsProcessing();
                boolean stopping = false;
                int numFailedReadsInRow = 0;
                int numSuccessfulReadsInRow = 0;
                int maxSuccessfulReadsinRow = 0;
                int realMaxSuccessfulReadsinRow = 0;
                while (!stopping) {
                    boolean readSomething = WorkQueueManager.this.handleRead(this.key, attachment.udpNetworkLayer);
                    WorkQueueManager.this.handleWrite(this.key);
                    if (!readSomething) {
                        if (maxSuccessfulReadsinRow > realMaxSuccessfulReadsinRow) {
                            realMaxSuccessfulReadsinRow = maxSuccessfulReadsinRow;
                        }
                        numSuccessfulReadsInRow = 0;
                        if (++numFailedReadsInRow != WorkQueueManager.this.numFailuresBeforeWorkerDie) continue;
                        stopping = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)("Stopping this worker thread: " + attachment.getNumThreadsProcessing() + ":" + realMaxSuccessfulReadsinRow), (Object[])new Object[0]);
                        continue;
                    }
                    ++maxSuccessfulReadsinRow;
                    numFailedReadsInRow = 0;
                    if (++numSuccessfulReadsInRow <= WorkQueueManager.this.numReceivesBeforeNewWorker) continue;
                    numSuccessfulReadsInRow = 0;
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"2", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)("Caught throwable while in worker thread = " + e), (Object[])new Object[0]);
                }
            }
            finally {
                if (0 >= attachment.decNumThreadsProcessing()) {
                    Object stopping = WorkQueueManager.this.lock;
                    synchronized (stopping) {
                        WorkQueueManager.this.lock.notify();
                    }
                }
                this.release();
            }
        }
    }

    protected static class SelectionKeyAttachment {
        private final AtomicInteger numThreadsProcessing = new AtomicInteger(0);
        protected UDPNetworkLayer udpNetworkLayer = null;

        SelectionKeyAttachment(UDPNetworkLayer udpNetworkLayer) {
            this.udpNetworkLayer = udpNetworkLayer;
        }

        public int getNumThreadsProcessing() {
            return this.numThreadsProcessing.get();
        }

        public void incNumThreadsProcessing() {
            this.numThreadsProcessing.incrementAndGet();
        }

        public int decNumThreadsProcessing() {
            return this.numThreadsProcessing.decrementAndGet();
        }

        public UDPNetworkLayer getUdpNetworkLayer() {
            return this.udpNetworkLayer;
        }
    }

    public class SelectorTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block43: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"SelectorTask.run", (Object[])new Object[0]);
                }
                Object object = WorkQueueManager.this.lock;
                synchronized (object) {
                    long DIAG_TIME = 10000L;
                    long lastPacketReceivedTime = 0L;
                    int failureCount = 0;
                    while (!WorkQueueManager.this.shutdown) {
                        try {
                            Object object2;
                            block42: {
                                int numReady = 0;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"Calling select: 10000", (Object[])new Object[0]);
                                }
                                object2 = WorkQueueManager.this.selector;
                                synchronized (object2) {
                                    numReady = WorkQueueManager.this.selector.select(10000L);
                                }
                                if (numReady == 0) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && !WorkQueueManager.this.shutdown) {
                                        long currentTime = System.currentTimeMillis();
                                        if (lastPacketReceivedTime > 0L && currentTime > lastPacketReceivedTime + 10000L) {
                                            lastPacketReceivedTime = 0L;
                                            Set<SelectionKey> set = WorkQueueManager.this.selector.keys();
                                            if (set != null) {
                                                Tr.event((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"*** current interest ops ", (Object[])new Object[0]);
                                                for (SelectionKey key : set) {
                                                    if (key == null) continue;
                                                    Tr.event((Object)WorkQueueManager.this, (TraceComponent)tc, (String)("channel = " + key.hashCode() + " interestOps " + key.interestOps()), (Object[])new Object[0]);
                                                }
                                                Tr.event((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"*** end current interest ops ", (Object[])new Object[0]);
                                            }
                                        }
                                    }
                                } else {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)("returned from select = " + numReady), (Object[])new Object[0]);
                                    }
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                        lastPacketReceivedTime = System.currentTimeMillis();
                                    }
                                    Iterator<SelectionKey> it = WorkQueueManager.this.selector.selectedKeys().iterator();
                                    while (it.hasNext()) {
                                        block41: {
                                            SelectionKey key = it.next();
                                            try {
                                                SelectionKeyAttachment attachment = (SelectionKeyAttachment)key.attachment();
                                                UDPNetworkLayer networkLayer = attachment.udpNetworkLayer;
                                                UDPConnLink udpConnLink = networkLayer.getConnLink();
                                                if (!key.isValid()) {
                                                    it.remove();
                                                    continue;
                                                }
                                                if (WorkQueueManager.this.readAlways && udpConnLink != null) {
                                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                        Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)("Starting worker thread from WQM: " + attachment.getNumThreadsProcessing()), (Object[])new Object[0]);
                                                    }
                                                    MultiThreadedWorker worker = WorkQueueManager.this.getMultiThreadedWorker(key, Thread.currentThread().getId());
                                                    WorkQueueManager.this.dispatchWorker(worker);
                                                } else {
                                                    WorkQueueManager.this.readAlways = false;
                                                    if (key.isReadable()) {
                                                        WorkQueueManager.this.handleRead(key, networkLayer);
                                                    }
                                                    if (key.isWritable()) {
                                                        WorkQueueManager.this.handleWrite(key);
                                                    }
                                                }
                                            }
                                            catch (CancelledKeyException e) {
                                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block41;
                                                Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"Cancelled key exception.", (Object[])new Object[0]);
                                            }
                                        }
                                        it.remove();
                                    }
                                    if (WorkQueueManager.this.readAlways) {
                                        try {
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"Waiting on lock.", (Object[])new Object[0]);
                                            }
                                            WorkQueueManager.this.lock.wait();
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"After wait on lock.", (Object[])new Object[0]);
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block42;
                                            Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"Caught InterruptedException waiting on lock.", (Object[])new Object[0]);
                                        }
                                    }
                                }
                            }
                            object2 = WorkQueueManager.this.channelRequestingToBeAddedRemovedSync;
                            synchronized (object2) {
                                if (WorkQueueManager.this.channelRequestingToBeAddedRemoved) {
                                    WorkQueueManager.this.channelRequestingToBeAddedRemoved = false;
                                    WorkQueueManager.this.handleChannelMods();
                                }
                            }
                            failureCount = 0;
                        }
                        catch (Throwable e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)("Error while selecting. " + e.getMessage()), (Object[])new Object[0]);
                            }
                            ++failureCount;
                        }
                    }
                }
                try {
                    WorkQueueManager.this.selector.close();
                }
                catch (IOException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block43;
                    Tr.debug((Object)WorkQueueManager.this, (TraceComponent)tc, (String)("Error closing selector. " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)WorkQueueManager.this, (TraceComponent)tc, (String)"SelectorTask.run");
            }
        }
    }
}

