/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.CompositeResourceProvider;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.dynamic.bundle.BundleFactory;
import com.ibm.ws.dynamic.bundle.DynamicBundleException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.ApiRegion;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoadingServiceException;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class GatewayBundleFactory {
    private static final TraceComponent tc = Tr.register(GatewayBundleFactory.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private static final String BUNDLE_LOCATION_PREFIX = "WSClassLoadingService@";
    private static final String REGION_PREFIX = "liberty.gateway";
    private static final String REGION_POSTFIX = ".hub";
    private static final String REGION_PRODUCT_HUB = "liberty.product.api.spi.hub";
    static final String MANIFEST_GATEWAY_ALLOWEDTYPES_PROPERTY_KEY = "IBM-ApiTypeVisibility";
    static final String GATEWAY_BUNDLE_MARKER = "IBM-GatewayBundle";
    protected final BundleContext bundleContext;
    private final FrameworkWiring frameworkWiring;
    private final RegionDigraph digraph;
    final Map<Bundle, Set<GatewayClassLoader>> classloaders;
    static final long serialVersionUID = 1460581234462286780L;

    GatewayBundleFactory(BundleContext bundleContext, RegionDigraph digraph, Map<Bundle, Set<GatewayClassLoader>> classloaders) {
        this.bundleContext = bundleContext;
        this.frameworkWiring = (FrameworkWiring)bundleContext.getBundle("System Bundle").adapt(FrameworkWiring.class);
        this.digraph = digraph;
        this.classloaders = classloaders;
    }

    private void setStartLevel(Bundle b) {
        FrameworkStartLevel fsl = (FrameworkStartLevel)this.frameworkWiring.getBundle().adapt(FrameworkStartLevel.class);
        BundleStartLevel bsl = (BundleStartLevel)b.adapt(BundleStartLevel.class);
        int currentStartLevel = fsl.getStartLevel();
        int neededStartLevel = bsl.getStartLevel();
        if (neededStartLevel > currentStartLevel) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Changing the start level of bundle {0} from {1} to the current level of {2}", (Object[])new Object[]{b, neededStartLevel, currentStartLevel});
            }
            bsl.setStartLevel(currentStartLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    GatewayClassLoader createGatewayBundleClassLoader(GatewayConfiguration gwConfig, ClassLoaderConfiguration clConfig, CompositeResourceProvider resourceProviders) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            Bundle b = this.createGatewayBundle(gwConfig, clConfig);
            this.setStartLevel(b);
            try {
                this.start(b);
            }
            catch (BundleException bundleException) {
                void e;
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.classloading.internal.GatewayBundleFactory", (String)"91", (Object)this, (Object[])new Object[]{gwConfig, clConfig, resourceProviders});
                throw new ClassLoadingServiceException(Tr.formatMessage((TraceComponent)tc, (String)"cls.gateway.not.resolvable", (Object[])new Object[]{gwConfig.getApplicationName(), gwConfig.getApplicationVersion()}), (Throwable)e);
            }
            BundleWiring bw = (BundleWiring)b.adapt(BundleWiring.class);
            ClassLoader bundleLoader = null;
            if (bw == null) {
                if (!FrameworkState.isStopping()) {
                    throw new ClassLoadingServiceException(Tr.formatMessage((TraceComponent)tc, (String)"cls.gateway.not.resolvable", (Object[])new Object[]{gwConfig.getApplicationName(), gwConfig.getApplicationVersion()}));
                }
            } else {
                bundleLoader = bw.getClassLoader();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"The state of started bundle {0} is {1}", (Object[])new Object[]{b, b.getState()});
            }
            GatewayClassLoader gatewayClassLoader = GatewayClassLoader.createGatewayClassLoader(this.classloaders, gwConfig, bundleLoader, resourceProviders);
            return gatewayClassLoader;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void start(Bundle b) throws BundleException {
        Object resolverException = null;
        for (int i = 0; i < 2; ++i) {
            resolverException = null;
            try {
                b.start(2);
                return;
            }
            catch (BundleException bundleException) {
                void e;
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.classloading.internal.GatewayBundleFactory", (String)"131", (Object)this, (Object[])new Object[]{b});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"An exception occurred while starting bundle {0}: {1}", (Object[])new Object[]{b, e});
                }
                if (e.getType() != 4) continue;
                resolverException = e;
                continue;
            }
        }
        if (resolverException != null) {
            throw resolverException;
        }
    }

    private Bundle createGatewayBundle(GatewayConfiguration gwConfig, ClassLoaderConfiguration clConfig) {
        return new BundleFactory().setBundleName(GatewayBundleFactory.getAppName(gwConfig, clConfig)).setBundleVersion(GatewayBundleFactory.getAppVersion(gwConfig)).setBundleSymbolicName(GatewayBundleFactory.getSymbolicName(clConfig)).importPackages(gwConfig.getImportPackage()).requireBundles(gwConfig.getRequireBundle()).dynamicallyImportPackages(gwConfig.getDynamicImportPackage()).addAttributeValues(GATEWAY_BUNDLE_MARKER, new Object[]{"true"}).addManifestAttribute(MANIFEST_GATEWAY_ALLOWEDTYPES_PROPERTY_KEY, gwConfig.getApiTypeVisibility()).setBundleLocationPrefix(BUNDLE_LOCATION_PREFIX).setBundleLocation(clConfig.getId().toString()).setBundleContext(this.bundleContext).setRegion(this.getRegion(gwConfig.getApiTypeVisibility())).setLazyActivation(true).createBundle();
    }

    private Region getRegion(EnumSet<ApiType> apiTypeVisibility) {
        if (this.digraph == null) {
            return null;
        }
        if (apiTypeVisibility == null) {
            return this.digraph.getRegion(ApiRegion.THREAD_CONTEXT.getRegionName());
        }
        if (apiTypeVisibility.isEmpty()) {
            return this.digraph.getRegion(ApiRegion.INTERNAL.getRegionName());
        }
        StringBuilder regionName = new StringBuilder(REGION_PREFIX);
        for (ApiType apiType : apiTypeVisibility) {
            regionName.append('.').append(apiType.toString());
        }
        regionName.append(REGION_POSTFIX);
        Region region = this.digraph.getRegion(regionName.toString());
        if (region == null) {
            return this.createRegion(apiTypeVisibility, regionName.toString());
        }
        return region;
    }

    /*
     * WARNING - void declaration
     */
    private Region createRegion(final EnumSet<ApiType> apiTypeVisibility, final String regionName) {
        try {
            ApiRegion.update((RegionDigraph)this.digraph, (Callable)new Callable<RegionDigraph>(){
                static final long serialVersionUID = 6621684806796518707L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public RegionDigraph call() throws BundleException {
                    try {
                        RegionDigraph copy = GatewayBundleFactory.this.digraph.copy();
                        Region region = copy.getRegion(regionName.toString());
                        if (region != null) {
                            return null;
                        }
                        region = copy.createRegion(regionName);
                        GatewayBundleFactory.this.connectToApiRegions(region, apiTypeVisibility, copy);
                        GatewayBundleFactory.this.connectProductHubToGatewayRegion(region, copy);
                        return copy;
                    }
                    catch (BundleException region) {
                        void e;
                        FFDCFilter.processException((Throwable)region, (String)"com.ibm.ws.classloading.internal.GatewayBundleFactory$1", (String)"205", (Object)this, (Object[])new Object[0]);
                        throw new DynamicBundleException("Failed to modify the region graph for region: " + regionName, (Throwable)e);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.GatewayBundleFactory$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
        }
        catch (BundleException bundleException) {
            void e;
            FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.classloading.internal.GatewayBundleFactory", (String)"212", (Object)this, (Object[])new Object[]{apiTypeVisibility, regionName});
            throw new DynamicBundleException((Throwable)e);
        }
        return this.digraph.getRegion(regionName);
    }

    private void connectToApiRegions(Region region, EnumSet<ApiType> apiTypeVisibility, RegionDigraph copy) throws BundleException {
        RegionFilterBuilder allBuilder = copy.createRegionFilterBuilder();
        allBuilder.allowAll("org.eclipse.equinox.allow.all");
        boolean connectToInternal = false;
        for (ApiType apiType : apiTypeVisibility) {
            ApiRegion apiRegionType = ApiRegion.valueFromApiType((String)apiType.toString());
            connectToInternal |= apiRegionType.delegateInternal();
            Region apiRegion = copy.getRegion(apiRegionType.getRegionName());
            region.connectRegion(apiRegion, allBuilder.build());
        }
        if (connectToInternal) {
            region.connectRegion(copy.getRegion(ApiRegion.INTERNAL.getRegionName()), allBuilder.build());
        }
    }

    private void connectProductHubToGatewayRegion(Region region, RegionDigraph copy) throws BundleException {
        RegionFilterBuilder builder = copy.createRegionFilterBuilder();
        builder.allowAll("org.eclipse.equinox.allow.service");
        Region productHub = copy.getRegion(REGION_PRODUCT_HUB);
        productHub.connectRegion(region, builder.build());
    }

    private static Version getAppVersion(GatewayConfiguration config) {
        Version appVersion = config.getApplicationVersion();
        if (appVersion == null) {
            appVersion = Version.emptyVersion;
        }
        return appVersion;
    }

    private static String getSymbolicName(ClassLoaderConfiguration clConfig) {
        String symbolicName = String.format("gateway.bundle.%s.%s", clConfig.getId().getDomain(), clConfig.getId().getId());
        return symbolicName.replaceAll("[^A-Za-z0-9._-]", "_");
    }

    private static String getAppName(GatewayConfiguration config, ClassLoaderConfiguration clConfig) {
        String appName = config.getApplicationName();
        if (appName == null) {
            appName = "" + clConfig.getId();
        }
        appName = "Gateway bundle for " + appName;
        return appName;
    }
}

