/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.HostAuthConfig;
import com.ibm.ws.collective.member.MemberJMXEndpoint;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.management.AttributeNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ServerManagementPublisher
implements EventHandler,
NotificationListener {
    protected static final TraceComponent tc = Tr.register(ServerManagementPublisher.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    public static final String REGISTRATION_MBEAN = "WebSphere:feature=collectiveController,type=CollectiveRegistration,name=CollectiveRegistration";
    public static final String KEY_EVENT_ADMIN_REF = "eventAdmin";
    public static final String KEY_LOCATION_ADMIN_REF = "locationAdmin";
    public static final String KEY_HOST_AUTH_CONFIG_REF = "hostAuthConfig";
    public static final String KEY_MEMBER_JMX_ENDPOINT_REF = "memberJMXEndpoint";
    protected final AtomicServiceReference<EventAdmin> eventAdminRef = new AtomicServiceReference("eventAdmin");
    protected final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    protected final AtomicServiceReference<HostAuthConfig> hostAuthConfigRef = new AtomicServiceReference("hostAuthConfig");
    protected final AtomicServiceReference<MemberJMXEndpoint> memberJMXEndpointRef = new AtomicServiceReference("memberJMXEndpoint");
    public static final String PATH_HOST_AUTH_INFO = "sys.host.auth.info";
    public static final String PATH_JMX_AUTH_INFO = "sys.jmx.auth.info";
    private boolean publishedHostAuthInfo = false;
    private boolean publishedJMXAuthInfo = false;
    protected ExecutorService executorService = null;
    protected ServiceRegistration<EventHandler> jmxEndpointChangeListnerReg = null;
    protected SSHKeyUtility sshKeyUtil;
    static final long serialVersionUID = 8376640043517294405L;

    protected abstract String getCollectivePublicKey() throws AttributeNotFoundException, Exception;

    public ServerManagementPublisher() {
        this.sshKeyUtil = new SSHKeyUtilityImpl();
    }

    public ServerManagementPublisher(SSHKeyUtility sshKeyUtil) {
        this.sshKeyUtil = sshKeyUtil;
    }

    protected ServiceRegistration<EventHandler> registerJMXEndpointChangeListener(ComponentContext cc) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "com/ibm/ws/management/repository/member/MemberJMXEndpoint/updated");
        return cc.getBundleContext().registerService(EventHandler.class, (Object)new JMXEndpointUpdatedEventHandler(), properties);
    }

    @Trivial
    private void putIfDefined(Map<String, Object> source, Map<String, Object> target, String key) {
        if (source.containsKey(key)) {
            target.put(key, source.get(key));
        }
    }

    @Sensitive
    private Map<String, Object> buildHostAuthInfo(@Sensitive Map<String, Object> configData) {
        HashMap<String, Object> hostAuthInfo = new HashMap<String, Object>();
        hostAuthInfo.put("osName", configData.get("osName"));
        hostAuthInfo.put("rpcHost", configData.get("rpcHost"));
        hostAuthInfo.put("rpcPort", configData.get("rpcPort"));
        hostAuthInfo.put("rpcUser", configData.get("rpcUser"));
        this.putIfDefined(configData, hostAuthInfo, "rpcUserPassword");
        this.putIfDefined(configData, hostAuthInfo, "sshPrivateKey");
        this.putIfDefined(configData, hostAuthInfo, "sshPrivateKeyPassword");
        this.putIfDefined(configData, hostAuthInfo, "useCollectiveSSHKey");
        this.putIfDefined(configData, hostAuthInfo, "useSudo");
        this.putIfDefined(configData, hostAuthInfo, "sudoUser");
        this.putIfDefined(configData, hostAuthInfo, "sudoUserPassword");
        return hostAuthInfo;
    }

    private void publishHostAuthInfo(EventAdmin eventAdmin, @Sensitive Map<String, Object> configData) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        if (!configData.isEmpty()) {
            Map<String, Object> hostAuthInfo = this.buildHostAuthInfo(configData);
            eventProps.put("operation", "UPDATE");
            eventProps.put("dataValue", hostAuthInfo);
        } else {
            eventProps.put("operation", "DELETE");
        }
        eventProps.put("sendStatusEvent", "true");
        eventProps.put("dataName", PATH_HOST_AUTH_INFO);
        eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
    }

    private Map<String, Object> buildJMXAuthInfo(MemberJMXEndpoint jmxEndpoint) {
        String hostName = jmxEndpoint.getHostName();
        String httpsPort = jmxEndpoint.getHTTPSPort();
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(" Retrieved jmx endpoint info: hostName = " + hostName + ", httpsPort = " + httpsPort), (Object[])new Object[0]);
        }
        HashMap<String, Object> jmxAuthInfo = null;
        if (hostName == null || httpsPort == null) {
            Tr.warning((TraceComponent)tc, (String)"SERVER_MANAGEMENT_INCOMPLETE_ENDPOINT_DATA", (Object[])new Object[0]);
        } else {
            jmxAuthInfo = new HashMap<String, Object>();
            jmxAuthInfo.put("jmxHost", hostName);
            jmxAuthInfo.put("jmxPort", httpsPort);
        }
        return jmxAuthInfo;
    }

    private void publishJMXAuthInfo(EventAdmin eventAdmin, MemberJMXEndpoint jmxEndpoint) {
        Map<String, Object> jmxAuthInfo = this.buildJMXAuthInfo(jmxEndpoint);
        if (jmxAuthInfo != null) {
            HashMap<String, Object> eventProps = new HashMap<String, Object>();
            eventProps.put("operation", "UPDATE");
            eventProps.put("sendStatusEvent", "true");
            eventProps.put("dataName", PATH_JMX_AUTH_INFO);
            eventProps.put("dataValue", jmxAuthInfo);
            eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"We could not build the JMX auth info, nothing to publish. A warning will have been printed earlier to describe what went wrong.", (Object[])new Object[0]);
        }
    }

    private void validateMapInput(@Sensitive Map<String, Object> configData) {
        if (configData.containsKey("rpcUserPassword") && configData.containsKey("sshPrivateKeyPath")) {
            throw new IllegalStateException("This should never happen. We have a HostAuthConfig with both a user password and an SSH private key. This is not valid input for " + this.getClass().getCanonicalName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void publishAuthInfo() throws Exception {
        HashMap<String, Object> configData;
        block19: {
            this.publishedHostAuthInfo = false;
            this.publishedJMXAuthInfo = false;
            configData = new HashMap<String, Object>(this.getHostAuthConfigService().getHostAuthConfig());
            this.validateMapInput(configData);
            if (configData.containsKey("useCollectiveSSHKey") && ((Boolean)configData.get("useCollectiveSSHKey")).booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Property useCollectiveSSHKey is enabled. Attempting to retrieve the collective-wide public SSH key.", (Object[])new Object[0]);
                }
                try {
                    String collectivePublicKey = this.getCollectivePublicKey();
                    if (collectivePublicKey != null) {
                        collectivePublicKey = collectivePublicKey.trim();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Successfully retrieved the collective-wide public SSH key from controller.", (Object[])new Object[0]);
                        }
                        this.sshKeyUtil.updateAuthorizedKeys((String)configData.get("rpcUserHome"), collectivePublicKey);
                        configData.remove("sshPrivateKeyPath");
                        configData.remove("sshPublicKeyPath");
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The collective controller is not configured to use collective-wide SSH.", (Object[])new Object[0]);
                        }
                        if (!configData.containsKey("sshPrivateKeyPath")) {
                            Tr.error((TraceComponent)tc, (String)"SERVER_MANAGEMENT_CONTROLLER_PUB_SSH_KEY_NOT_CONFIGURED", (Object[])new Object[0]);
                            throw new Exception("The collective controller is not configured to use colelctive-wide SSH");
                        }
                        configData.put("useCollectiveSSHKey", false);
                    }
                }
                catch (AttributeNotFoundException collectivePublicKey) {
                    FFDCFilter.processException((Throwable)collectivePublicKey, (String)"com.ibm.ws.collective.member.ServerManagementPublisher", (String)"317", (Object)this, (Object[])new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The collective controller does not support collective-wide SSH", (Object[])new Object[0]);
                    }
                    if (!configData.containsKey("sshPrivateKeyPath")) {
                        Tr.error((TraceComponent)tc, (String)"SERVER_MANAGEMENT_CONTROLLER_PUB_SSH_KEY_NOT_SUPPORTED", (Object[])new Object[0]);
                        throw new Exception("The collective controller does not support collective-wide SSH");
                    }
                    configData.put("useCollectiveSSHKey", false);
                }
                catch (Exception anfe) {
                    void e;
                    FFDCFilter.processException((Throwable)anfe, (String)"com.ibm.ws.collective.member.ServerManagementPublisher", (String)"328", (Object)this, (Object[])new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("There was an error retrieving the collective-wide public SSH key from the collective controller: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    if (!configData.containsKey("sshPrivateKeyPath")) {
                        Tr.error((TraceComponent)tc, (String)"SERVER_MANAGEMENT_CONTROLLER_PUB_SSH_KEY_ERROR", (Object[])new Object[0]);
                        throw e;
                    }
                    configData.put("useCollectiveSSHKey", false);
                }
            }
            if (configData.containsKey("sshPrivateKeyPath")) {
                try {
                    String serverName = this.getEventAdminService().getServerName();
                    String publicKeyComment = "Generated SSH key for Liberty server " + serverName + " for Liberty management.";
                    String userHome = (String)configData.get("rpcUserHome");
                    String privateKeyPathName = (String)configData.get("sshPrivateKeyPath");
                    String publicKeyPathName = (String)configData.get("sshPublicKeyPath");
                    String encodedPrivateKey = this.sshKeyUtil.useSSHKeyPair(publicKeyComment, userHome, publicKeyPathName, privateKeyPathName);
                    configData.put("sshPrivateKey", encodedPrivateKey);
                }
                catch (NoSuchAlgorithmException serverName) {
                    FFDCFilter.processException((Throwable)serverName, (String)"com.ibm.ws.collective.member.ServerManagementPublisher", (String)"353", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"SSH_KEYGEN_NOSUCHALGORITHMEXCEPTION", (Object[])new Object[]{"RSA"});
                    if (tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("Unable to compute SSH keys. Caught NoSuchAlgorithmException: " + e.getMessage()), (Object[])new Object[]{e});
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.ServerManagementPublisher", (String)"358", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)"SSH_KEYGEN_IOEXCEPTION", (Object[])new Object[]{e.getLocalizedMessage()});
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug((TraceComponent)tc, (String)("Unable to compute SSH keys. Caught IOException: " + e.getMessage()), (Object[])new Object[]{e});
                }
            }
        }
        this.writeEffectiveConfigInfoMessage(configData);
        EventAdmin eventAdmin = (EventAdmin)this.eventAdminRef.getService();
        this.publishHostAuthInfo(eventAdmin, configData);
        MemberJMXEndpoint jmxEndpoint = (MemberJMXEndpoint)this.memberJMXEndpointRef.getService();
        this.publishJMXAuthInfo(eventAdmin, jmxEndpoint);
    }

    @Trivial
    private void writeEffectiveConfigInfoMessage(@Sensitive Map<String, Object> hostAuthInfo) {
        if (hostAuthInfo.isEmpty()) {
            Tr.info((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_STATE_HOST_CREDENTIALS", (Object[])new Object[0]);
        } else if (((Boolean)hostAuthInfo.get("useCollectiveSSHKey")).booleanValue()) {
            Tr.info((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_STATE_COLLECTIVE_SSH", (Object[])new Object[0]);
        } else {
            String host = (String)hostAuthInfo.get("rpcHost");
            String port = ((Integer)hostAuthInfo.get("rpcPort")).toString();
            String user = (String)hostAuthInfo.get("rpcUser");
            String authType = null;
            if (hostAuthInfo.containsKey("rpcUserPassword")) {
                authType = "password";
            } else if (hostAuthInfo.containsKey("sshPrivateKeyPath")) {
                authType = "ssh-key";
            }
            Tr.info((TraceComponent)tc, (String)"HOST_AUTH_CONFIG_STATE", (Object[])new Object[]{host, port, user, authType});
        }
    }

    private void handleOurStatusEvent(@Sensitive Event statusEvent, String publishedData) {
        if (statusEvent.containsProperty("errorMessage")) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error during publishing while shutting down server " + publishedData), (Object[])new Object[]{statusEvent.getProperty("errorMessage")});
                }
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Error during publishing " + publishedData), (Object[])new Object[]{statusEvent.getProperty("errorMessage")});
                }
                Tr.error((TraceComponent)tc, (String)"PUBLISHED_SERVER_MANAGEMENT_INFO_ERROR", (Object[])new Object[]{statusEvent.getProperty("errorMessage")});
            }
        } else {
            if (PATH_HOST_AUTH_INFO.equals(publishedData)) {
                this.publishedHostAuthInfo = true;
            }
            if (PATH_JMX_AUTH_INFO.equals(publishedData)) {
                this.publishedJMXAuthInfo = true;
            }
            if (this.publishedHostAuthInfo && this.publishedJMXAuthInfo) {
                Tr.info((TraceComponent)tc, (String)"PUBLISHED_SERVER_MANAGEMENT_INFO", (Object[])new Object[0]);
            }
        }
    }

    public void handleEvent(@Sensitive Event statusEvent) {
        if (statusEvent == null) {
            return;
        }
        Object dataName = statusEvent.getProperty("dataName");
        if (dataName instanceof String) {
            String publishedData = (String)dataName;
            if (PATH_HOST_AUTH_INFO.equals(publishedData) || PATH_JMX_AUTH_INFO.equals(publishedData)) {
                this.handleOurStatusEvent(statusEvent, publishedData);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received unexpected event.", (Object[])new Object[]{statusEvent});
            }
        }
    }

    @Trivial
    private HostAuthConfig getHostAuthConfigService() {
        HostAuthConfig service = (HostAuthConfig)this.hostAuthConfigRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that HostAuthConfigService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HostAuthConfigService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The HostAuthConfig service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @Trivial
    private WsLocationAdmin getEventAdminService() {
        WsLocationAdmin service = (WsLocationAdmin)this.locationAdminRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that EventAdminService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"EventAdminService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The EventAdmin service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public final class PublishAuthInfo
    implements Callable<Object> {
        static final long serialVersionUID = 2838524416489989174L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public Object call() throws Exception {
            ServerManagementPublisher.this.publishAuthInfo();
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.member.ServerManagementPublisher$PublishAuthInfo", PublishAuthInfo.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public final class JMXEndpointUpdatedEventHandler
    implements EventHandler {
        static final long serialVersionUID = 5200377927526877262L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void handleEvent(Event event) {
            if (event == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JMXEndpointUpdatedEventHandler received a null event, ignoring...", (Object[])new Object[0]);
                }
                return;
            }
            if ("com/ibm/ws/management/repository/member/MemberJMXEndpoint/updated".equals(event.getTopic())) {
                if (ServerManagementPublisher.this.executorService != null) {
                    ServerManagementPublisher.this.executorService.submit(new PublishAuthInfo());
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"The JMX endpoint has changed. The management configuration has been scheduled for publishing", (Object[])new Object[0]);
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"The executorService is null, we've been deactivated so nothing to do...", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JMXEndpointUpdatedEventHandler received an unexpected topic, ignoring...", (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.member.ServerManagementPublisher$JMXEndpointUpdatedEventHandler", JMXEndpointUpdatedEventHandler.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
        }
    }
}

