/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.DockerEnvironmentUtil;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.RepositoryClient;
import com.ibm.wsspi.collective.repository.RepositoryConnectionFactory;
import com.ibm.wsspi.collective.repository.publisher.RepositoryPublisher;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ReflectionException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={EventHandler.class, ServerQuiesceListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "event.topics=com/ibm/wsspi/collective/repository/publish/*"})
public class RepositoryPublisherImpl
implements EventHandler,
RepositoryPublisher,
ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(RepositoryPublisherImpl.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    static final String KEY_EVENT_ADMIN_REF = "eventAdmin";
    static final String KEY_LOCATION_ADMIN_REF = "locationAdmin";
    static final String KEY_COLLECTIVE_HOSTNAME_REF = "collectiveHostName";
    static final String KEY_REPOSITORY_CONNECTION_FACTORY_REF = "repositoryConnectionFactory";
    private final AtomicServiceReference<EventAdmin> eventAdminRef = new AtomicServiceReference("eventAdmin");
    private final AtomicServiceReference<RepositoryConnectionFactory> repositoryConnectionFactoryRef = new AtomicServiceReference("repositoryConnectionFactory");
    private ServerInfoMBean serverIdentity = null;
    static final int MAX_QUEUE_RETRIES = 3;
    private static final long MAX_DEACTIVATE_WAIT_SECONDS = 10L;
    static final String INIT_EVENT_TOPIC = "com/ibm/wsspi/collective/repository/publish/ServiceInitialization";
    private static final String PATH_STATE = "sys.status";
    private static final String STATE_STARTED = "STARTED";
    private static final String STATE_STOPPED = "STOPPED";
    private static final String IS_INTERNAL_STATE_EVENT = "isInternalStateEvent";
    private String serverPath = null;
    private volatile boolean sawEvent = false;
    private Future<Object> registrationTask;
    protected ExecutorService executorService;
    protected ExecutorService queueHandlerExecutor;
    private ServiceRegistration<RepositoryPublisher> reg;
    private final BlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>();
    private Future<?> queueHandlerTask;
    private volatile boolean doRetry = false;
    volatile String errorMessage = null;
    private volatile boolean backlevelController = false;
    private volatile boolean serverStopping = false;
    private QueueHandler queueHandler;
    private static final Map<String, Object> publishedData = new HashMap<String, Object>();
    private static final Set<String> republishSet = new HashSet<String>();
    private final Lock queueHandlerLock = new ReentrantLock();
    private static final Event QUEUE_TERMINATOR = new Event("terminator", new HashMap());
    static final long serialVersionUID = -2260768968763607200L;

    @Reference
    protected void setExecutorService(ExecutorService svc) {
        this.executorService = svc;
    }

    protected void unsetExecutorService(ExecutorService svc) {
        if (this.executorService == svc) {
            this.executorService = null;
        }
    }

    @Reference(name="eventAdmin", service=EventAdmin.class)
    protected void setEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.setReference(ref);
    }

    protected void unsetEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.unsetReference(ref);
    }

    @Reference
    protected synchronized void setServerIdentityMBean(ServerInfoMBean reference) {
        this.serverIdentity = reference;
    }

    protected synchronized void unsetServerIdentityMBean(ServerInfoMBean reference) {
        if (this.serverIdentity == reference) {
            this.serverIdentity = null;
        }
    }

    @Reference(name="repositoryConnectionFactory", service=RepositoryConnectionFactory.class)
    protected void setRepositoryConnectionFactory(ServiceReference<RepositoryConnectionFactory> ref) {
        this.repositoryConnectionFactoryRef.setReference(ref);
    }

    protected void unsetRepositoryConnectionFactory(ServiceReference<RepositoryConnectionFactory> ref) {
        this.repositoryConnectionFactoryRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.eventAdminRef.activate(cc);
        this.repositoryConnectionFactoryRef.activate(cc);
        this.backlevelController = false;
        this.registrationTask = this.executorService.submit(new RegisteredEventHandler(cc, this));
        this.queueHandler = new QueueHandler();
        if (this.queueHandlerExecutor == null) {
            this.queueHandlerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){
                static final long serialVersionUID = -8789379424248713290L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    t.setName("RepositoryPublisher" + t.getName());
                    return t;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.member.internal.publisher.RepositoryPublisherImpl$1", 1.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
                }
            });
        }
        this.queueHandlerTask = this.queueHandlerExecutor.submit(this.queueHandler);
        this.queueHandlerExecutor.shutdown();
        this.queueHandlerExecutor = null;
        this.serverStateChangedEvent(STATE_STARTED);
    }

    private void serverStateChangedEvent(String state) {
        HashMap<String, String> eventProps = new HashMap<String, String>();
        eventProps.put("operation", "UPDATE");
        eventProps.put("dataName", PATH_STATE);
        eventProps.put("dataValue", state);
        eventProps.put(IS_INTERNAL_STATE_EVENT, "true");
        this.handleEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.serverStateChangedEvent(STATE_STOPPED);
        if (this.registrationTask != null) {
            this.registrationTask.cancel(true);
        }
        this.shutdownQueueHandlerTask();
        this.eventAdminRef.deactivate(cc);
        this.repositoryConnectionFactoryRef.deactivate(cc);
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    @FFDCIgnore(value={TimeoutException.class})
    private void shutdownQueueHandlerTask() {
        if (this.queueHandlerLock.tryLock()) {
            try {
                if (this.queueHandlerTask == null) {
                    return;
                }
                this.eventQueue.add(QUEUE_TERMINATOR);
                this.queueHandlerTask.get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Timed out in deactivate() waiting for queueHandlerTask to complete processing. " + this.eventQueue.size() + " events remaining unprocessed."), (Object[])new Object[0]);
                }
                this.queueHandlerTask.cancel(true);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.internal.publisher.RepositoryPublisherImpl", (String)"277", (Object)this, (Object[])new Object[0]);
                if (tc.isDebugEnabled()) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    Tr.debug((TraceComponent)tc, (String)("Exception in deactivate() waiting for queueHandlerTask to complete processing: " + sw.toString() + "\n There were" + this.eventQueue.size() + " events remaining unprocessed."), (Object[])new Object[0]);
                }
            }
            finally {
                this.queueHandler = null;
                this.queueHandlerTask = null;
                this.queueHandlerLock.unlock();
            }
        }
    }

    @Trivial
    protected synchronized String getServerPath() {
        if (this.serverPath == null) {
            if (this.serverIdentity != null) {
                String hostName = null;
                String userDir = null;
                String serverName = null;
                if (DockerEnvironmentUtil.isMemberInDockerEnvironment()) {
                    hostName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment("containerHost");
                    userDir = "Docker";
                    serverName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment("containerName");
                } else {
                    hostName = this.serverIdentity.getDefaultHostname();
                    String unencodedUserDir = this.serverIdentity.getUserDirectory();
                    userDir = RepositoryPathUtility.getURLEncodedPath((String)unencodedUserDir);
                    serverName = this.serverIdentity.getName();
                }
                if (hostName == null || hostName.isEmpty() || userDir == null || userDir.isEmpty() || serverName == null || serverName.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to compute the server path. Required information missing. hostName=" + hostName + " userDir=" + userDir + " serverName=" + serverName), (Object[])new Object[0]);
                    }
                    return null;
                }
                this.serverPath = RepositoryPathUtility.buildServerRepositoryPath((String)hostName, (String)userDir, (String)serverName);
                return this.serverPath;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to compute the server path. The ServerIdentityMBean is unavailable.", (Object[])new Object[0]);
            }
            return null;
        }
        return this.serverPath;
    }

    @Trivial
    private Map<String, Object> copyEventProperties(Event source) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        for (String propName : source.getPropertyNames()) {
            eventProps.put(propName, source.getProperty(propName));
        }
        return eventProps;
    }

    @Trivial
    void logStateChangePublishOutcome(@Sensitive Event statusEvent) {
        if ("true".equals(statusEvent.getProperty(IS_INTERNAL_STATE_EVENT))) {
            if (this.errorMessage != null) {
                this.logError(statusEvent.getProperty("dataValue"), this.errorMessage);
            } else {
                Tr.info((TraceComponent)tc, (String)"PUBLISHED_SERVER_STATE", (Object[])new Object[]{statusEvent.getProperty("dataValue")});
            }
        }
    }

    private void logError(Object value, String msg) {
        if (this.serverStopping) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"PUBLISHED_SERVER_STATE_ERROR", (Object[])new Object[]{value, msg});
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"PUBLISHED_SERVER_STATE_ERROR", (Object[])new Object[]{value, msg});
        }
    }

    private void postOperationStatusEvent(@Sensitive Event publishEvent, String errorMessage) {
        if (!publishEvent.containsProperty("sendStatusEvent")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Publish Event did not request a Status Event, skipping...", (Object[])new Object[0]);
            }
            return;
        }
        EventAdmin eventAdmin = (EventAdmin)this.eventAdminRef.getService();
        if (eventAdmin != null) {
            String statusTopic = publishEvent.getTopic().replace("com/ibm/wsspi/collective/repository/publish/", "com/ibm/wsspi/collective/repository/publishStatus/");
            Map<String, Object> statusProps = this.copyEventProperties(publishEvent);
            if (errorMessage != null) {
                statusProps.put("errorMessage", errorMessage);
            }
            Event statusEvent = new Event(statusTopic, statusProps);
            eventAdmin.postEvent(statusEvent);
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Unable to post the Status Event, EventAdmin service is unavailable.", (Object[])new Object[0]);
        }
    }

    private void doUpdateOrCreate(RepositoryConnectionFactory factory, @Sensitive Event publishEvent, String relativePath, @Sensitive Object value) {
        boolean allowNodeCreation = true;
        boolean allowRepublishing = true;
        this.doSetDataWithRelativePath(factory, publishEvent, relativePath, value, allowNodeCreation, allowRepublishing);
    }

    private void doUpdate(RepositoryConnectionFactory factory, @Sensitive Event publishEvent, String relativePath, @Sensitive Object value) {
        boolean allowNodeCreation = false;
        boolean allowRepublishing = false;
        this.doSetDataWithRelativePath(factory, publishEvent, relativePath, value, allowNodeCreation, allowRepublishing);
    }

    private void doSetDataWithRelativePath(RepositoryConnectionFactory factory, @Sensitive Event publishEvent, String relativePath, @Sensitive Object value, boolean allowNodeCreation, boolean allowRepublishing) {
        String serverPath;
        if (tc.isDebugEnabled() && (relativePath.endsWith("State") || relativePath.endsWith("state") || relativePath.endsWith(PATH_STATE))) {
            Tr.debug((TraceComponent)tc, (String)("RelativePath=" + relativePath + ", Value=" + value), (Object[])new Object[0]);
        }
        if ((serverPath = this.getServerPath()) == null) {
            this.errorMessage = "Unable to compute server path, no operation was performed.";
        } else {
            String nodeName = serverPath + relativePath;
            this.doSetDataWithAbsolutePath(factory, publishEvent, nodeName, value, allowNodeCreation, allowRepublishing);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalArgumentException.class, IllegalStateException.class, IOException.class})
    private void doSetDataWithAbsolutePath(RepositoryConnectionFactory factory, @Sensitive Event publishEvent, String path, @Sensitive Object value, boolean allowNodeCreation, boolean allowRepublishing) {
        if (tc.isDebugEnabled() && (path.endsWith("State") || path.endsWith("state") || path.endsWith(PATH_STATE))) {
            Tr.debug((TraceComponent)tc, (String)("Path=" + path + ", Value=" + value), (Object[])new Object[0]);
        }
        RepositoryClient client = factory.obtainRepositoryClient();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempting to update " + path), (Object[])new Object[0]);
            }
            if (allowNodeCreation || this.isNodePublished(path)) {
                this.doUpdate(client, path, value, allowRepublishing);
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Update only operation; setData was not performed on " + path), (Object[])new Object[0]);
                }
                this.errorMessage = "Update only operation; setData was not performed.";
            }
        }
        catch (ReflectionException reflectionException) {
            Object[] objectArray = new Object[6];
            objectArray[0] = factory;
            objectArray[1] = "<sensitive org.osgi.service.event.Event>";
            objectArray[2] = path;
            objectArray[3] = "<sensitive java.lang.Object>";
            objectArray[4] = allowNodeCreation;
            objectArray[5] = allowRepublishing;
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.ws.collective.member.internal.publisher.RepositoryPublisherImpl", (String)"591", (Object)this, (Object[])objectArray);
            if (tc.isEventEnabled()) {
                void e;
                Tr.event((TraceComponent)tc, (String)("Detected backlevel controller while trying to update " + path + "; Exception: " + e.getMessage()), (Object[])new Object[0]);
            }
            this.errorMessage = "Detected backlevel controller.  Retry with original API.";
            this.backlevelController = true;
            this.doRetry = true;
        }
        catch (IllegalArgumentException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IllegalArgumentException while trying to update " + path + " Exception: " + e.getMessage()), (Object[])new Object[0]);
            }
            this.errorMessage = e.getMessage();
        }
        catch (IllegalStateException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IllegalStateException because of de-activation while trying to update " + path + " Exception: " + e.getMessage()), (Object[])new Object[0]);
            }
            this.errorMessage = e.getMessage();
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while trying to update " + path + " Exception: " + e.getMessage()), (Object[])new Object[0]);
            }
            if (e.getCause() instanceof SocketException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("SocketException while trying to update " + path + ". Re-trying event."), (Object[])new Object[0]);
                }
                this.doRetry = true;
            }
            this.errorMessage = e.getMessage();
        }
    }

    private void doUpdate(RepositoryClient client, String nodeName, @Sensitive Object value, boolean allowRepublishing) throws IOException, IllegalArgumentException, IllegalStateException, ReflectionException {
        if (this.serverStopping) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Skipping publish for " + nodeName + " because the server is stopping"), (Object[])new Object[0]);
            }
        } else if (!this.alreadyPublished(nodeName, value) || this.isRepublishable(nodeName) && allowRepublishing) {
            if (tc.isDebugEnabled() && (nodeName.endsWith(PATH_STATE) || nodeName.endsWith("State") || nodeName.endsWith("state"))) {
                Tr.debug((TraceComponent)tc, (String)("Publishing NodeName=" + nodeName + ", Value=" + value), (Object[])new Object[0]);
            }
            this.updateToBacklevelController(client, nodeName, value);
            this.addToPublishedData(nodeName, value);
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Skipping publish for " + nodeName + ".  The value was already published."), (Object[])new Object[0]);
        }
    }

    private boolean alreadyPublished(String nodeName, @Sensitive Object value) {
        if (tc.isDebugEnabled() && (nodeName.endsWith(PATH_STATE) || nodeName.endsWith("State") || nodeName.endsWith("state"))) {
            Tr.debug((TraceComponent)tc, (String)("NodeName=" + nodeName + ", Value=" + value), (Object[])new Object[0]);
        }
        boolean result = false;
        Object publishedValue = publishedData.get(nodeName);
        if (publishedValue != null && publishedValue.equals(value)) {
            result = true;
        }
        return result;
    }

    private void updateToBacklevelController(RepositoryClient client, String nodeName, @Sensitive Object value) throws IOException, IllegalArgumentException, IllegalStateException {
        if (tc.isDebugEnabled() && (nodeName.endsWith(PATH_STATE) || nodeName.endsWith("State") || nodeName.endsWith("state"))) {
            Tr.debug((TraceComponent)tc, (String)("NodeName=" + nodeName + ", Value=" + value), (Object[])new Object[0]);
        }
        if (client.exists(nodeName)) {
            boolean result = client.setData(nodeName, value);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Updated " + nodeName + " Result=" + result), (Object[])new Object[0]);
            }
            if (!result) {
                this.errorMessage = "Unable to update node (did not exist) " + nodeName;
            }
        } else {
            boolean result = client.create(nodeName, value);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Created " + nodeName + " Result=" + result), (Object[])new Object[0]);
            }
            if (!result) {
                this.errorMessage = "Unable to create node (already exists) " + nodeName;
            }
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class, IllegalStateException.class, IOException.class})
    private void doDelete(RepositoryConnectionFactory factory, @Sensitive Event publishEvent, String relativePath) {
        String serverPath = this.getServerPath();
        if (serverPath == null) {
            this.errorMessage = "Unable to compute server path, no operation was performed.";
        } else {
            String nodeName = serverPath + relativePath;
            RepositoryClient client = factory.obtainRepositoryClient();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempting to delete node " + nodeName), (Object[])new Object[0]);
                }
                this.removeFromPublishedData(nodeName);
                boolean result = client.delete(nodeName);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Deleted node " + nodeName + " Result=" + result), (Object[])new Object[0]);
                }
            }
            catch (IllegalArgumentException e) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("IllegalArgumentException while trying to delete " + nodeName + " Exception: " + e.getMessage()), (Object[])new Object[0]);
                }
                this.errorMessage = e.getMessage();
            }
            catch (IllegalStateException e) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("IllegalStateException because of de-activation while trying to update " + nodeName + " Exception: " + e.getMessage()), (Object[])new Object[0]);
                }
                this.errorMessage = e.getMessage();
            }
            catch (IOException e) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("IOException while trying to update " + nodeName + " Exception: " + e.getMessage()), (Object[])new Object[0]);
                }
                if (e.getCause() instanceof SocketException) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("SocketException while trying to update " + nodeName + ". Re-trying event."), (Object[])new Object[0]);
                    }
                    this.doRetry = true;
                }
                this.errorMessage = e.getMessage();
            }
        }
    }

    private boolean isRepublishable(String nodeName) {
        boolean result = false;
        if (nodeName != null && nodeName.contains("/WebSphere:service=com.ibm.websphere.application.ApplicationMBean,") && nodeName.contains("/attributes/State")) {
            result = true;
        }
        return result;
    }

    protected void addToPublishedData(String nodeName, @Sensitive Object value) {
        if (tc.isDebugEnabled() && (nodeName.endsWith(PATH_STATE) || nodeName.endsWith("State") || nodeName.endsWith("state"))) {
            Tr.debug((TraceComponent)tc, (String)("NodeName=" + nodeName + ", Value=" + value), (Object[])new Object[0]);
        }
        publishedData.put(nodeName, value);
        if (this.isRepublishable(nodeName)) {
            republishSet.add(nodeName);
        }
    }

    void removeFromPublishedData(String nodeName) {
        publishedData.remove(nodeName);
        if (this.isRepublishable(nodeName)) {
            republishSet.remove(nodeName);
        }
        String prefix = nodeName + "/";
        ArrayList<String> removeList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : publishedData.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            removeList.add(entry.getKey());
        }
        for (String key : removeList) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Deleting from publishedData: " + key), (Object[])new Object[0]);
            }
            publishedData.remove(key);
            if (!this.isRepublishable(key)) continue;
            republishSet.remove(key);
        }
    }

    private void doMBeanEvent(RepositoryConnectionFactory factory, @Sensitive Event publishEvent) {
        String objectName = (String)publishEvent.getProperty("mbeanObjectName");
        String attributeName = (String)publishEvent.getProperty("mbeanAttributeName");
        if (objectName == null) {
            this.errorMessage = "mbeanObjectName was not set.";
        }
        String relativePath = "sys.mbeans/" + objectName;
        if (attributeName != null) {
            relativePath = relativePath + "/attributes/" + attributeName;
        }
        if (this.errorMessage == null) {
            Object op = publishEvent.getProperty("operation");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("objectName: " + objectName + " attributeName: " + attributeName + " operation: " + op), (Object[])new Object[0]);
            }
            if (op == null || "UPDATE".equals(op) || "UPDATE_ONLY".equals(op)) {
                if (!publishEvent.containsProperty("mbeanAttributeValue")) {
                    this.errorMessage = "mbeanAttributeValue was not set.";
                }
                if (this.errorMessage == null) {
                    if ("UPDATE_ONLY".equals(op)) {
                        this.doUpdate(factory, publishEvent, relativePath, publishEvent.getProperty("mbeanAttributeValue"));
                    } else {
                        this.doUpdateOrCreate(factory, publishEvent, relativePath, publishEvent.getProperty("mbeanAttributeValue"));
                    }
                }
            } else if ("DELETE".equals(op)) {
                this.doDelete(factory, publishEvent, relativePath);
            } else {
                this.errorMessage = "Unknown operation: " + op.toString();
            }
        }
    }

    private void doDataEvent(RepositoryConnectionFactory factory, @Sensitive Event publishEvent) {
        String relativePath = null;
        Object dataName = publishEvent.getProperty("dataName");
        if (dataName == null) {
            this.errorMessage = "dataName was not set.";
        } else if (dataName instanceof String) {
            relativePath = (String)dataName;
            if (relativePath.startsWith("/")) {
                this.errorMessage = "dataName was not a relative path.";
            }
        } else {
            this.errorMessage = "dataName was not a String.";
        }
        if (this.errorMessage == null) {
            Object op = publishEvent.getProperty("operation");
            if (op == null || "UPDATE".equals(op) || "UPDATE_ONLY".equals(op)) {
                if (!publishEvent.containsProperty("dataValue")) {
                    this.errorMessage = "dataValue was not set.";
                }
                if (this.errorMessage == null) {
                    if ("UPDATE_ONLY".equals(op)) {
                        this.doUpdate(factory, publishEvent, relativePath, publishEvent.getProperty("dataValue"));
                    } else {
                        this.doUpdateOrCreate(factory, publishEvent, relativePath, publishEvent.getProperty("dataValue"));
                    }
                } else {
                    this.errorMessage = "Unable to update node (did not exist) " + relativePath;
                    if (tc.isDebugEnabled() && dataName.equals("sys.jmx.auth.info")) {
                        Map jmxAuthMap = (Map)publishEvent.getProperty("dataValue");
                        String host = (String)jmxAuthMap.get("jmxHost");
                        String port = (String)jmxAuthMap.get("jmxPort");
                        Tr.debug((TraceComponent)tc, (String)("Published JMX Auth info:  host [" + host + "] port [" + port + "]"), (Object[])new Object[0]);
                    }
                }
            } else if ("DELETE".equals(op)) {
                this.doDelete(factory, publishEvent, relativePath);
            } else {
                this.errorMessage = "Unknown operation: " + op.toString();
            }
        }
    }

    private void doRepublishEvent(RepositoryConnectionFactory factory) {
        for (String path : republishSet) {
            Object data = publishedData.get(path);
            if (data == null) continue;
            this.republishNode(factory, path, data);
        }
    }

    private void republishNode(RepositoryConnectionFactory factory, String path, Object data) {
        boolean allowNodeCreation = true;
        boolean allowRepublishing = true;
        this.doSetDataWithAbsolutePath(factory, null, path, data, allowNodeCreation, allowRepublishing);
    }

    @FFDCIgnore(value={InterruptedException.class})
    public synchronized void handleEvent(@Sensitive Event publishEvent) {
        block5: {
            if (publishEvent == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to complete handleEvent, Event is null.", (Object[])new Object[0]);
                }
                return;
            }
            if (!this.sawEvent && publishEvent.getProperty(IS_INTERNAL_STATE_EVENT) == null) {
                this.sawEvent = true;
            }
            try {
                this.eventQueue.put(publishEvent);
                this.debugEvent(publishEvent);
            }
            catch (InterruptedException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Unable to put the event in the queue: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    private boolean isNodePublished(String nodeName) {
        return publishedData.containsKey(nodeName);
    }

    protected int getPublishedDataSize() {
        return publishedData.size();
    }

    public void serverStopping() {
        this.serverStopping = true;
        this.shutdownQueueHandlerTask();
    }

    void debugEvent(@Sensitive Event publishEvent) {
        if (tc.isDebugEnabled()) {
            String topic = publishEvent.getTopic();
            Object objectName = publishEvent.getProperty("mbeanObjectName");
            Object mbeanAttrName = publishEvent.getProperty("mbeanAttributeName");
            Object dataName = publishEvent.getProperty("dataName");
            Tr.debug((TraceComponent)tc, (String)("Topic is" + topic), (Object[])new Object[0]);
            if (topic.endsWith("mbean")) {
                Tr.debug((TraceComponent)tc, (String)("MBean event for MBean=" + objectName + ", MBeanAttributeName=" + mbeanAttrName), (Object[])new Object[0]);
            }
            if (topic.endsWith("data")) {
                Tr.debug((TraceComponent)tc, (String)("Data event for DataName=" + dataName), (Object[])new Object[0]);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class QueueHandler
    implements Runnable {
        static final long serialVersionUID = 2004369044917446482L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        QueueHandler() {
        }

        @FFDCIgnore(value={InterruptedException.class})
        public void processEvent(@Sensitive Event publishEvent) {
            RepositoryPublisherImpl.this.debugEvent(publishEvent);
            int doRetryCounter = 0;
            RepositoryPublisherImpl.this.errorMessage = null;
            RepositoryConnectionFactory factory = (RepositoryConnectionFactory)RepositoryPublisherImpl.this.repositoryConnectionFactoryRef.getService();
            if (factory == null) {
                RepositoryPublisherImpl.this.errorMessage = "Unable to complete handleEvent, the RepositoryPublisher has been deactivated.";
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)RepositoryPublisherImpl.this.errorMessage, (Object[])new Object[0]);
                }
            }
            if (RepositoryPublisherImpl.this.errorMessage == null) {
                do {
                    RepositoryPublisherImpl.this.errorMessage = null;
                    RepositoryPublisherImpl.this.doRetry = false;
                    ++doRetryCounter;
                    String topic = publishEvent.getTopic();
                    if ("com/ibm/wsspi/collective/repository/publish/mbean".equals(topic)) {
                        RepositoryPublisherImpl.this.doMBeanEvent(factory, publishEvent);
                    } else if ("com/ibm/wsspi/collective/repository/publish/data".equals(topic)) {
                        RepositoryPublisherImpl.this.doDataEvent(factory, publishEvent);
                    } else if ("com/ibm/wsspi/collective/repository/publish/republish".equals(topic)) {
                        RepositoryPublisherImpl.this.doRepublishEvent(factory);
                    } else if (RepositoryPublisherImpl.INIT_EVENT_TOPIC.equals(topic)) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Initialization event received.", (Object[])new Object[0]);
                        }
                    } else if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Ignoring received event. Unrecognized topic '" + topic + "'"), (Object[])new Object[0]);
                    }
                    if (!RepositoryPublisherImpl.this.doRetry) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Exception caught while processing event queue. " + e.getMessage()), (Object[])new Object[0]);
                    }
                } while (RepositoryPublisherImpl.this.doRetry && doRetryCounter < 3);
            }
            if (RepositoryPublisherImpl.this.queueHandlerTask != null && !RepositoryPublisherImpl.this.queueHandlerTask.isCancelled()) {
                RepositoryPublisherImpl.this.logStateChangePublishOutcome(publishEvent);
            }
            RepositoryPublisherImpl.this.postOperationStatusEvent(publishEvent, RepositoryPublisherImpl.this.errorMessage);
        }

        @Override
        @FFDCIgnore(value={InterruptedException.class})
        public void run() {
            block5: {
                try {
                    while (true) {
                        Event publishEvent;
                        if ((publishEvent = (Event)RepositoryPublisherImpl.this.eventQueue.take()) == QUEUE_TERMINATOR) {
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug((TraceComponent)tc, (String)"Found terminator. Exiting.", (Object[])new Object[0]);
                            break;
                        }
                        if (Thread.interrupted()) {
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug((TraceComponent)tc, (String)"Thread was interrupted, exiting", (Object[])new Object[0]);
                            break;
                        }
                        this.processEvent(publishEvent);
                    }
                }
                catch (InterruptedException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("InterruptedException occurred in queueHandlerTask: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.member.internal.publisher.RepositoryPublisherImpl$QueueHandler", QueueHandler.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class RegisteredEventHandler
    implements Callable<Object> {
        final ComponentContext cc;
        final RepositoryPublisher publisher;
        static final long serialVersionUID = 1009238839440996745L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RegisteredEventHandler(ComponentContext cc, RepositoryPublisher publisher) {
            this.cc = cc;
            this.publisher = publisher;
        }

        private Event createInitializationEvent() {
            HashMap<String, String> eventProps = new HashMap<String, String>();
            eventProps.put("operation", RepositoryPublisherImpl.INIT_EVENT_TOPIC);
            Event registerEvent = new Event(RepositoryPublisherImpl.INIT_EVENT_TOPIC, eventProps);
            return registerEvent;
        }

        private void registerServiceUponInitEventHandled(EventAdmin eventAdmin) {
            int maxAttempts = 30;
            Event initEvent = this.createInitializationEvent();
            for (int numAttempts = 0; !RepositoryPublisherImpl.this.sawEvent && numAttempts < maxAttempts; ++numAttempts) {
                eventAdmin.sendEvent(initEvent);
            }
            if (RepositoryPublisherImpl.this.sawEvent) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("service.vendor", "IBM");
                RepositoryPublisherImpl.this.reg = this.cc.getBundleContext().registerService(RepositoryPublisher.class, (Object)this.publisher, props);
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The initialization event never reached us, something is horribly wrong!", (Object[])new Object[0]);
            }
        }

        @Override
        public Object call() {
            EventAdmin eventAdmin = (EventAdmin)RepositoryPublisherImpl.this.eventAdminRef.getService();
            if (eventAdmin != null) {
                this.registerServiceUponInitEventHandled(eventAdmin);
            } else if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("EventAdmin service is unavailable, will not try to register " + RepositoryPublisher.class.getCanonicalName() + " as a service."), (Object[])new Object[0]);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.member.internal.publisher.RepositoryPublisherImpl$RegisteredEventHandler", RegisteredEventHandler.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
        }
    }
}

