/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.publisher.RepositoryPublisher;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={EventHandler.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "event.topics=com/ibm/wsspi/collective/repository/publishStatus/data", "event.filter=(dataName=sys.paths/*)"})
public class ServerPathsPublisher
implements EventHandler {
    private static final TraceComponent tc = Tr.register(ServerPathsPublisher.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    static final String KEY_EVENT_ADMIN = "eventAdmin";
    static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private final AtomicServiceReference<EventAdmin> eventAdminRef = new AtomicServiceReference("eventAdmin");
    static final String SYS_PATHS_NODE = "sys.paths/";
    private final Map<String, String> symbolsToPublish = new HashMap<String, String>();
    private final Set<String> publishedSymbols = new HashSet<String>();
    static final long serialVersionUID = 6724471053266229835L;

    @Reference(name="locationAdmin", service=WsLocationAdmin.class)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    @Reference(name="eventAdmin", service=EventAdmin.class)
    protected void setEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.setReference(ref);
    }

    protected void unsetEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.unsetReference(ref);
    }

    @Reference(service=RepositoryPublisher.class)
    protected void setRepositoryPublisher(ServiceReference<RepositoryPublisher> ref) {
    }

    protected void unsetRepositoryPublisher(ServiceReference<RepositoryPublisher> ref) {
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.locationAdminRef.activate(cc);
        this.eventAdminRef.activate(cc);
        this.publishPaths();
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.locationAdminRef.deactivate(cc);
        this.eventAdminRef.deactivate(cc);
    }

    private void publishPath(EventAdmin eventAdmin, WsLocationAdmin locAdminSvc, String symbolPath, String symbol) {
        String symbolValue = locAdminSvc.resolveString(symbol);
        HashMap<String, String> eventProps = new HashMap<String, String>();
        eventProps.put("operation", "UPDATE");
        eventProps.put("sendStatusEvent", "true");
        eventProps.put("dataName", symbolPath);
        eventProps.put("dataValue", symbolValue);
        eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
    }

    private void publishPaths() {
        this.symbolsToPublish.put("sys.paths/wlp.install.dir", "${wlp.install.dir}/");
        this.symbolsToPublish.put("sys.paths/wlp.user.dir", "${wlp.user.dir}/");
        this.symbolsToPublish.put("sys.paths/server.config.dir", "${server.config.dir}/");
        this.symbolsToPublish.put("sys.paths/server.output.dir", "${server.output.dir}/");
        this.symbolsToPublish.put("sys.paths/shared.app.dir", "${shared.app.dir}/");
        this.symbolsToPublish.put("sys.paths/shared.config.dir", "${shared.config.dir}/");
        this.symbolsToPublish.put("sys.paths/shared.resource.dir", "${shared.resource.dir}/");
        EventAdmin eventAdmin = (EventAdmin)this.eventAdminRef.getService();
        WsLocationAdmin locAdminSvc = (WsLocationAdmin)this.locationAdminRef.getService();
        for (Map.Entry<String, String> entry : this.symbolsToPublish.entrySet()) {
            this.publishPath(eventAdmin, locAdminSvc, entry.getKey(), entry.getValue());
        }
    }

    private void handleOurStatusEvent(Event statusEvent, String publishedPath) {
        if (statusEvent.containsProperty("errorMessage")) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error during publishing " + publishedPath), (Object[])new Object[]{statusEvent.getProperty("errorMessage")});
            }
            Tr.error((TraceComponent)tc, (String)"PUBLISHED_SERVER_PATHS_ERROR", (Object[])new Object[]{statusEvent.getProperty("errorMessage")});
        } else {
            this.publishedSymbols.add(publishedPath);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Successfully published " + publishedPath), (Object[])new Object[0]);
            }
            if (this.publishedSymbols.size() == this.symbolsToPublish.size()) {
                Tr.info((TraceComponent)tc, (String)"PUBLISHED_SERVER_PATHS", (Object[])new Object[0]);
            }
        }
    }

    public void handleEvent(Event statusEvent) {
        if (statusEvent == null) {
            return;
        }
        Object dataName = statusEvent.getProperty("dataName");
        if (dataName instanceof String) {
            String publishedPath = (String)dataName;
            if (publishedPath.startsWith(SYS_PATHS_NODE)) {
                this.handleOurStatusEvent(statusEvent, publishedPath);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received unexpected event.", (Object[])new Object[]{statusEvent});
            }
        }
    }
}

