/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collective.singleton.internal.AbstractElector;
import com.ibm.ws.collective.singleton.internal.HostFollower;
import com.ibm.ws.collective.singleton.internal.HostLeader;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.extender.exceptions.ElectorException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HostSingletonElector
extends AbstractElector {
    private static final TraceComponent tc = Tr.register(HostSingletonElector.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
    private volatile boolean started = false;
    private final int port;
    private final ExecutorService executor;
    private Future<?> task;
    private HostLeader hostLeader;
    private HostFollower hostFollower;
    static final long serialVersionUID = 1138177497956778410L;

    HostSingletonElector(int port, ExecutorService executor) {
        if (port <= 0) {
            throw new IllegalArgumentException("Port must be greater than 0.  Value is " + port + ".");
        }
        if (executor == null) {
            throw new IllegalArgumentException("ExecutorService must not be null.");
        }
        this.port = port;
        this.executor = executor;
    }

    @Override
    public void candidateRegistered(ServiceEndpointIdentity candidate) throws ElectorException {
        super.candidateRegistered(candidate);
        this.start();
    }

    @Override
    public void candidateUnregistered(ServiceEndpointIdentity candidate) throws ElectorException {
        super.candidateUnregistered(candidate);
        this.stop();
    }

    @Override
    public synchronized void start() {
        if (!this.started && this.okToStart()) {
            this.started = true;
            this.task = this.executor.submit(new ElectorTask(this));
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"already started", (Object[])new Object[0]);
        }
    }

    private boolean okToStart() {
        return this.getLocalCandidate() != null || this.getLocalParticipant() != null;
    }

    @Override
    public synchronized void stop() {
        this.started = false;
        if (this.hostLeader != null) {
            this.hostLeader.stop();
        } else if (this.hostFollower != null) {
            this.hostFollower.stop();
        }
        this.task.cancel(true);
    }

    @Override
    public String getIdentity() {
        return ManagementFactory.getRuntimeMXBean().getName() + ":" + Integer.toString(this.port);
    }

    @FFDCIgnore(value={IOException.class})
    private boolean becomeLeader() {
        boolean isLeader = false;
        if (this.getLocalCandidate() != null) {
            try {
                this.getHostLeader();
                isLeader = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return isLeader;
    }

    private void lead() throws IOException {
        this.setLeader(this.getLocalCandidate());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Between setLeader and monitorMembers.  HostLeader is " + this.hostLeader), (Object[])new Object[0]);
        }
        this.hostLeader.monitorMembers();
    }

    private void follow() throws IOException {
        this.hostFollower = new HostFollower(this.port, this);
        this.hostFollower.connectToLeader();
    }

    protected synchronized void setHostLeader(HostLeader leader) {
        this.hostLeader = leader;
    }

    private HostLeader getHostLeader() throws IOException {
        if (this.hostLeader == null) {
            this.hostLeader = new HostLeader(this.port, this);
        }
        return this.hostLeader;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class ElectorTask
    implements Runnable {
        HostSingletonElector elector;
        static final long serialVersionUID = -4696858692140058683L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ElectorTask(HostSingletonElector elector) {
            this.elector = elector;
        }

        @Override
        @FFDCIgnore(value={IOException.class})
        public void run() {
            while (HostSingletonElector.this.started) {
                try {
                    if (HostSingletonElector.this.becomeLeader()) {
                        HostSingletonElector.this.lead();
                        continue;
                    }
                    HostSingletonElector.this.follow();
                }
                catch (IOException e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Caught exception in ElectorTask.run()", (Object[])new Object[]{e});
                }
                finally {
                    HostSingletonElector.this.hostLeader = null;
                    HostSingletonElector.this.hostFollower = null;
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.singleton.internal.HostSingletonElector$ElectorTask", ElectorTask.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
        }
    }
}

