/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.health.center.classloader;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.health.center.classloader.HCConnector;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={HCClassLoader.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class HCClassLoader {
    private static final TraceComponent tc = Tr.register(HCClassLoader.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
    private static final String MIN_AGENT_VERSION = "2.2.1";
    private static final String RECOMMENDED_AGENT_VERSION = "3.0.5";
    private WsLocationAdmin wsLocationAdmin;
    private static final String[] attachAgent_message_keys = new String[]{"AttachAgent.native.invresp", "AttachAgent.native.error", "AttachAgent.native.loaded", "AttachAgent.native.jvmtierr", "AttachAgent.native.mbeanerr", "AttachAgent.native.mbeanexc", null, null, null, null, null};
    private static final String HC_INTERFACE_IMPLEMENTATION_NAME = "com.ibm.ws.collector.manager.hcagent";
    private static final String HC_EMBEDDED_MONITORING_JAR_NAME = "com.ibm.ws.collector.manager.hcmonitoringjar";
    private static final String MONITORING_JRE_PATH = File.separator + "lib" + File.separator + "tools" + File.separator + "monitoring-api.jar";
    private HCConnector hcConnector;
    private boolean connected = false;
    static final long serialVersionUID = 8123175528307176799L;

    @Activate
    @FFDCIgnore(value={IOException.class, IndexOutOfBoundsException.class})
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        URL monitoringURL;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        if ((monitoringURL = this.getJavaMonitoringAPIURL()) == null) {
            Tr.event((TraceComponent)tc, (String)"No monitoring-api.jar found. Defaulting back to embedded jar.", (Object[])new Object[0]);
            monitoringURL = this.getEmbeddedMonitoringAPIURL();
        }
        final URL interfaceImplJar = this.getInterfaceImplementationURL();
        final URL[] urls = new URL[]{monitoringURL, interfaceImplJar};
        Tr.debug((TraceComponent)tc, (String)("Found monitoring-api.jar at " + monitoringURL), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("Found interface implementation jar at " + interfaceImplJar), (Object[])new Object[0]);
        try {
            this.hcConnector = AccessController.doPrivileged(new PrivilegedExceptionAction<HCConnector>(){
                static final long serialVersionUID = -6290053538066973990L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public HCConnector run() throws Exception {
                    URLClassLoader cl = new CustomClassLoader(urls, this.getClass().getClassLoader());
                    if (!HCClassLoader.this.checkNeededAPI(cl)) {
                        Tr.event((TraceComponent)tc, (String)"Incompatible monitoring-api.jar found. Defaulting back to embedded jar", (Object[])new Object[0]);
                        URL[] embeddedUrls = new URL[]{HCClassLoader.this.getEmbeddedMonitoringAPIURL(), interfaceImplJar};
                        cl = new URLClassLoader(embeddedUrls, this.getClass().getClassLoader());
                    }
                    Class<?> clazz = Class.forName("com.ibm.ws.health.center.proxy.HCConnectorImpl", false, cl);
                    return (HCConnector)clazz.newInstance();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
                }
            });
            String agentVersion = this.getAgentVersion();
            if (!agentVersion.equals("") && this.compareAgentVersion(agentVersion, MIN_AGENT_VERSION) >= 0) {
                if (this.compareAgentVersion(agentVersion, RECOMMENDED_AGENT_VERSION) >= 0) {
                    this.loadLibrary();
                    this.hcConnector.connect();
                } else {
                    this.hcConnector.connectWithProps();
                }
                this.connected = true;
            } else {
                Tr.warning((TraceComponent)tc, (String)"AGENT_VERSION_NOT_SUPPORTED_WARNING", (Object[])new Object[]{agentVersion});
            }
        }
        catch (IOException io) {
            Tr.warning((TraceComponent)tc, (String)"AGENT_NOT_FOUND_WARNING", (Object[])new Object[0]);
        }
        catch (IndexOutOfBoundsException iob) {
            Tr.warning((TraceComponent)tc, (String)"AGENT_NOT_STARTED_WARNING", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.health.center.classloader.HCClassLoader", (String)"187", (Object)this, (Object[])new Object[]{context, properties});
        }
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
        if (this.hcConnector != null) {
            this.hcConnector.shutdown(reason);
        }
    }

    public HCConnector getHCConnector() {
        if (this.connected) {
            return this.hcConnector;
        }
        return null;
    }

    private URL getLocalBundleURL(final String bundleName) {
        File dir;
        File[] hcFiles;
        WsResource resource = this.wsLocationAdmin.resolveResource("${wlp.install.dir}/lib/");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Looking at local lib dir" + resource.toExternalURI().toString()), (Object[])new Object[0]);
        }
        if ((hcFiles = (dir = resource.asFile()).listFiles(new FilenameFilter(){
            static final long serialVersionUID = -8680129090344569179L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @Trivial
            public boolean accept(File dir, String name) {
                return name.startsWith(bundleName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
            }
        })).length > 0) {
            try {
                return hcFiles[0].toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.health.center.classloader.HCClassLoader", (String)"237", (Object)this, (Object[])new Object[]{bundleName});
            }
        }
        return null;
    }

    private URL getInterfaceImplementationURL() {
        return this.getLocalBundleURL(HC_INTERFACE_IMPLEMENTATION_NAME);
    }

    private URL getEmbeddedMonitoringAPIURL() {
        return this.getLocalBundleURL(HC_EMBEDDED_MONITORING_JAR_NAME);
    }

    private URL getJavaMonitoringAPIURL() {
        URL monitoringURL = null;
        String javaHome = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 6073139798169479655L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("java.home");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
            }
        });
        File file = new File(javaHome + MONITORING_JRE_PATH);
        if (file.exists()) {
            try {
                monitoringURL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.health.center.classloader.HCClassLoader", (String)"283", (Object)this, (Object[])new Object[0]);
            }
        }
        if ((file = new File(javaHome + File.separator + "jre" + MONITORING_JRE_PATH)).exists()) {
            try {
                monitoringURL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.health.center.classloader.HCClassLoader", (String)"293", (Object)this, (Object[])new Object[0]);
            }
        }
        return monitoringURL;
    }

    @FFDCIgnore(value={InvocationTargetException.class, ClassNotFoundException.class})
    private void loadLibrary() throws Exception {
        block21: {
            List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : arguments) {
                if (!arg.startsWith("-Xhealthcenter")) continue;
                return;
            }
            String pid = null;
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            Bundle bundle = FrameworkUtil.getBundle(HCClassLoader.class);
            Class classVM = null;
            try {
                classVM = bundle.loadClass("com.ibm.tools.attach.VirtualMachine");
            }
            catch (ClassNotFoundException e) {
                try {
                    classVM = bundle.loadClass("com.sun.tools.attach.VirtualMachine");
                }
                catch (ClassNotFoundException e1) {
                    return;
                }
            }
            try {
                String isAgentRunning;
                Method methodAttach = classVM.getMethod("attach", String.class);
                Object virtualMachineRef = methodAttach.invoke(null, pid);
                Method methodSystemProps = classVM.getMethod("getSystemProperties", new Class[0]);
                Properties targetProps = (Properties)methodSystemProps.invoke(virtualMachineRef, new Object[0]);
                String string = isAgentRunning = targetProps != null ? targetProps.getProperty("com.ibm.java.diagnostics.healthcenter.running") : null;
                if (isAgentRunning != null && isAgentRunning.equals("true")) {
                    this.hcConnector.sendMessage("AttachAgent.native.loaded", new Object[0]);
                } else {
                    String hcOptions = "";
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){
                        static final long serialVersionUID = 3068799802905293405L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() {
                            System.setProperty("com.ibm.diagnostics.healthcenter.jmx", "off");
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(4.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
                        }
                    });
                    Method methodloadAgentLibrary = classVM.getMethod("loadAgentLibrary", String.class, String.class);
                    methodloadAgentLibrary.invoke(virtualMachineRef, "healthcenter", hcOptions);
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){
                        static final long serialVersionUID = -4365496629769488901L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() {
                            System.setProperty("com.ibm.java.diagnostics.healthcenter.running", "true");
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(5.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
                        }
                    });
                }
                Method methodDetach = classVM.getMethod("detach", new Class[0]);
                methodDetach.invoke(virtualMachineRef, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause == null) break block21;
                String className = cause.getClass().getName();
                if (className.equals("com.ibm.tools.attach.AttachNotSupportedException")) {
                    this.hcConnector.sendMessage("AttachAgent.vm.unsupported", new Object[0]);
                    Tr.warning((TraceComponent)tc, (String)"AGENT_NOT_SUPPORTED_LATEATTACH", (Object[])new Object[0]);
                }
                if (className.equals("java.io.IOException")) {
                    this.hcConnector.sendMessage("AttachAgent.error.io", cause.getMessage());
                }
                if (className.equals("com.ibm.tools.attach.AgentLoadException")) {
                    this.hcConnector.sendMessage("AttachAgent.error.load", new Object[0]);
                }
                if (!className.equals("com.ibm.tools.attach.AgentInitializationException")) break block21;
                try {
                    String message;
                    int rc_index;
                    Method methodReturnValue = cause.getClass().getMethod("returnValue", new Class[0]);
                    int rc = (Integer)methodReturnValue.invoke((Object)cause, new Object[0]);
                    if (0 == rc && (rc_index = (message = e.getMessage()).lastIndexOf("-")) >= 0) {
                        try {
                            rc = Integer.parseInt(message.substring(rc_index));
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.health.center.classloader.HCClassLoader", (String)"415", (Object)this, (Object[])new Object[0]);
                        }
                    }
                    this.hcConnector.sendMessage("AttachAgent.error.init", rc);
                    String messagekey = null;
                    try {
                        messagekey = attachAgent_message_keys[-rc];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        FFDCFilter.processException((Throwable)arrayIndexOutOfBoundsException, (String)"com.ibm.ws.health.center.classloader.HCClassLoader", (String)"430", (Object)this, (Object[])new Object[0]);
                    }
                    if (null == messagekey) {
                        messagekey = attachAgent_message_keys[0];
                    }
                    this.hcConnector.sendMessage(messagekey, new Object[0]);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.health.center.classloader.HCClassLoader", (String)"438", (Object)this, (Object[])new Object[0]);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.health.center.classloader.HCClassLoader", (String)"444", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    @FFDCIgnore(value={IOException.class})
    private String getAgentVersion() throws IOException {
        String[] tokens;
        InputStream in;
        String os = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -4141798799978737736L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("os.name", "unidentified");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(6.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
            }
        });
        boolean isZOS = os.toLowerCase().indexOf("z/os") >= 0;
        String charset = Charset.defaultCharset().name();
        if (isZOS) {
            charset = "Cp1047";
        }
        String javaHome = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 1515637941781831386L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("java.home");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(7.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
            }
        });
        String agentPath = javaHome + "/lib/ext/healthcenter.jar";
        URL url = new URL("jar:file:" + agentPath + "!/version.properties");
        try {
            in = url.openStream();
        }
        catch (IOException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("jar:file:" + agentPath + "!/version.properties was not found.Attempting to read jar:file:" + agentPath + "!/hcversion.properties"), (Object[])new Object[0]);
            }
            url = new URL("jar:file:" + agentPath + "!/hcversion.properties");
            in = url.openStream();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        String line = reader.readLine();
        reader.close();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Health center version info string : " + line), (Object[])new Object[0]);
        }
        String agentVersion = "";
        if (line != null && (tokens = line.split("=")).length == 2) {
            agentVersion = tokens[1].substring(0, tokens[1].length() - 9);
        }
        return agentVersion;
    }

    private Integer compareAgentVersion(String v1, String v2) {
        int diffIndex;
        String[] values1 = v1.split("\\.");
        String[] values2 = v2.split("\\.");
        for (diffIndex = 0; diffIndex < values1.length && diffIndex < values2.length && values1[diffIndex].equals(values2[diffIndex]); ++diffIndex) {
        }
        if (diffIndex < values1.length && diffIndex < values2.length) {
            int diff = Integer.valueOf(values1[diffIndex]) - Integer.valueOf(values2[diffIndex]);
            return Integer.signum(diff);
        }
        return Integer.signum(values1.length - values2.length);
    }

    @FFDCIgnore(value={ClassNotFoundException.class, NoSuchMethodException.class, SecurityException.class})
    private boolean checkNeededAPI(ClassLoader cl) {
        try {
            Class.forName("com.ibm.java.diagnostics.healthcenter.api.gc.GCEventListener", false, cl);
            Class<?> clazz = Class.forName("com.ibm.java.diagnostics.healthcenter.api.HealthCenter", false, cl);
            clazz.getMethod("setEventOnlyMode", Boolean.TYPE);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    @Reference
    protected void setWsLocationAdmin(WsLocationAdmin wsLocationAdmin) {
        this.wsLocationAdmin = wsLocationAdmin;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class CustomClassLoader
    extends URLClassLoader {
        static final long serialVersionUID = -1194919280095420976L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CustomClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection collection = super.getPermissions(codesource);
            collection.add(new AllPermission());
            return collection;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CustomClassLoader.class, (String)"collectorManagerHCClassloader", (String)"com.ibm.ws.health.center.classloader.internal.resources.LoggingMessages");
        }
    }
}

