/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.EnumValueDefinition;
import graphql.language.IgnoredChars;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.TypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class EnumTypeDefinition
extends AbstractNode<EnumTypeDefinition>
implements TypeDefinition<EnumTypeDefinition>,
DirectivesContainer<EnumTypeDefinition>,
NamedNode<EnumTypeDefinition> {
    private final String name;
    private final Description description;
    private final List<EnumValueDefinition> enumValueDefinitions;
    private final List<Directive> directives;
    public static final String CHILD_ENUM_VALUE_DEFINITIONS = "enumValueDefinitions";
    public static final String CHILD_DIRECTIVES = "directives";

    @Internal
    protected EnumTypeDefinition(String name, List<EnumValueDefinition> enumValueDefinitions, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData);
        this.name = name;
        this.description = description;
        this.directives = null == directives ? new ArrayList() : directives;
        this.enumValueDefinitions = enumValueDefinitions;
    }

    public EnumTypeDefinition(String name) {
        this(name, new ArrayList<EnumValueDefinition>(), new ArrayList<Directive>(), null, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    public List<EnumValueDefinition> getEnumValueDefinitions() {
        return new ArrayList<EnumValueDefinition>(this.enumValueDefinitions);
    }

    @Override
    public List<Directive> getDirectives() {
        return new ArrayList<Directive>(this.directives);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.enumValueDefinitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_ENUM_VALUE_DEFINITIONS, this.enumValueDefinitions).children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public EnumTypeDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.enumValueDefinitions(newChildren.getChildren(CHILD_ENUM_VALUE_DEFINITIONS)).directives(newChildren.getChildren(CHILD_DIRECTIVES)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypeDefinition that = (EnumTypeDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public EnumTypeDefinition deepCopy() {
        return new EnumTypeDefinition(this.name, this.deepCopy(this.enumValueDefinitions), this.deepCopy(this.directives), this.description, this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "EnumTypeDefinition{name='" + this.name + '\'' + ", enumValueDefinitions=" + this.enumValueDefinitions + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitEnumTypeDefinition(this, context);
    }

    public static Builder newEnumTypeDefinition() {
        return new Builder();
    }

    public EnumTypeDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private Description description;
        private List<EnumValueDefinition> enumValueDefinitions = new ArrayList<EnumValueDefinition>();
        private List<Directive> directives = new ArrayList<Directive>();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(EnumTypeDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = existing.getDirectives();
            this.enumValueDefinitions = existing.getEnumValueDefinitions();
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder enumValueDefinitions(List<EnumValueDefinition> enumValueDefinitions) {
            this.enumValueDefinitions = enumValueDefinitions;
            return this;
        }

        public Builder enumValueDefinition(EnumValueDefinition enumValueDefinition) {
            this.enumValueDefinitions.add(enumValueDefinition);
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder directive(Directive directive) {
            this.directives.add(directive);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public EnumTypeDefinition build() {
            return new EnumTypeDefinition(this.name, this.enumValueDefinitions, this.directives, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

