/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.EnumValueDefinition;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLEnumValueDefinition
implements GraphQLNamedSchemaElement,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Object value;
    private final String deprecationReason;
    private final List<GraphQLDirective> directives;
    private final EnumValueDefinition definition;
    public static final String CHILD_DIRECTIVES = "directives";

    @Internal
    @Deprecated
    public GraphQLEnumValueDefinition(String name, String description, Object value) {
        this(name, description, value, null, Collections.emptyList());
    }

    @Internal
    @Deprecated
    public GraphQLEnumValueDefinition(String name, String description, Object value, String deprecationReason) {
        this(name, description, value, deprecationReason, Collections.emptyList());
    }

    @Internal
    @Deprecated
    public GraphQLEnumValueDefinition(String name, String description, Object value, String deprecationReason, List<GraphQLDirective> directives) {
        this(name, description, value, deprecationReason, directives, null);
    }

    private GraphQLEnumValueDefinition(String name, String description, Object value, String deprecationReason, List<GraphQLDirective> directives, EnumValueDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.value = value;
        this.deprecationReason = deprecationReason;
        this.directives = directives;
        this.definition = definition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return DirectivesUtil.directivesByName(this.directives);
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public EnumValueDefinition getDefinition() {
        return this.definition;
    }

    public GraphQLEnumValueDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLEnumValueDefinition.newEnumValueDefinition(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLEnumValueDefinition(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        return new ArrayList<GraphQLSchemaElement>(this.directives);
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public GraphQLEnumValueDefinition withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceDirectives(newChildren.getChildren(CHILD_DIRECTIVES)));
    }

    public static Builder newEnumValueDefinition() {
        return new Builder();
    }

    public static Builder newEnumValueDefinition(GraphQLEnumValueDefinition existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private Object value;
        private String deprecationReason;
        private EnumValueDefinition definition;
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLEnumValueDefinition existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.value = existing.getValue();
            this.deprecationReason = existing.getDeprecationReason();
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder deprecationReason(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public Builder definition(EnumValueDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Assert.assertNotNull(directives, "directives can't be null", new Object[0]);
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            Assert.assertNotNull(directives, "directive can't be null", new Object[0]);
            this.directives.clear();
            for (GraphQLDirective directive : directives) {
                this.directives.put(directive.getName(), directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLEnumValueDefinition build() {
            return new GraphQLEnumValueDefinition(this.name, this.description, this.value, this.deprecationReason, FpKit.valuesToList(this.directives), this.definition);
        }
    }
}

