/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Directives;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparators;
import graphql.schema.SchemaUtil;
import graphql.schema.validation.InvalidSchemaException;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidator;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;

@PublicApi
public class GraphQLSchema {
    private final GraphQLObjectType queryType;
    private final GraphQLObjectType mutationType;
    private final GraphQLObjectType subscriptionType;
    private final Set<GraphQLType> additionalTypes = new LinkedHashSet<GraphQLType>();
    private final Set<GraphQLDirective> directives = new LinkedHashSet<GraphQLDirective>();
    private final Map<String, GraphQLDirective> schemaDirectives = new LinkedHashMap<String, GraphQLDirective>();
    private final SchemaDefinition definition;
    private final List<SchemaExtensionDefinition> extensionDefinitions;
    private final GraphQLCodeRegistry codeRegistry;
    private final Map<String, GraphQLNamedType> typeMap;
    private final Map<String, List<GraphQLObjectType>> byInterface;

    @Internal
    @Deprecated
    public GraphQLSchema(GraphQLObjectType queryType) {
        this(queryType, null, Collections.emptySet());
    }

    @Internal
    @Deprecated
    public GraphQLSchema(GraphQLObjectType queryType, GraphQLObjectType mutationType, Set<GraphQLType> additionalTypes) {
        this(queryType, mutationType, null, additionalTypes);
    }

    @Internal
    @Deprecated
    public GraphQLSchema(GraphQLObjectType queryType, GraphQLObjectType mutationType, GraphQLObjectType subscriptionType, Set<GraphQLType> additionalTypes) {
        this(GraphQLSchema.newSchema().query(queryType).mutation(mutationType).subscription(subscriptionType).additionalTypes(additionalTypes), false);
    }

    @Internal
    private GraphQLSchema(Builder builder, boolean afterTransform) {
        Assert.assertNotNull(builder.additionalTypes, "additionalTypes can't be null", new Object[0]);
        Assert.assertNotNull(builder.queryType, "queryType can't be null", new Object[0]);
        Assert.assertNotNull(builder.additionalDirectives, "directives can't be null", new Object[0]);
        Assert.assertNotNull(builder.codeRegistry, "codeRegistry can't be null", new Object[0]);
        this.queryType = builder.queryType;
        this.mutationType = builder.mutationType;
        this.subscriptionType = builder.subscriptionType;
        this.additionalTypes.addAll(builder.additionalTypes);
        this.directives.addAll(builder.additionalDirectives);
        this.schemaDirectives.putAll(builder.schemaDirectives);
        this.definition = builder.definition;
        this.extensionDefinitions = builder.extensionDefinitions == null ? Collections.emptyList() : builder.extensionDefinitions;
        this.codeRegistry = builder.codeRegistry;
        SchemaUtil schemaUtil = new SchemaUtil();
        this.typeMap = new TreeMap<String, GraphQLNamedType>(schemaUtil.allTypes(this, this.additionalTypes, afterTransform));
        this.byInterface = new TreeMap<String, List<GraphQLObjectType>>(schemaUtil.groupImplementations(this));
    }

    @Internal
    private GraphQLSchema(GraphQLSchema otherSchema, GraphQLCodeRegistry codeRegistry) {
        this.queryType = otherSchema.queryType;
        this.mutationType = otherSchema.mutationType;
        this.subscriptionType = otherSchema.subscriptionType;
        this.additionalTypes.addAll(otherSchema.additionalTypes);
        this.directives.addAll(otherSchema.directives);
        this.schemaDirectives.putAll(otherSchema.schemaDirectives);
        this.definition = otherSchema.definition;
        this.extensionDefinitions = otherSchema.extensionDefinitions == null ? Collections.emptyList() : otherSchema.extensionDefinitions;
        this.codeRegistry = codeRegistry;
        this.typeMap = otherSchema.typeMap;
        this.byInterface = otherSchema.byInterface;
    }

    public GraphQLCodeRegistry getCodeRegistry() {
        return this.codeRegistry;
    }

    public Set<GraphQLType> getAdditionalTypes() {
        return this.additionalTypes;
    }

    public GraphQLType getType(String typeName) {
        return this.typeMap.get(typeName);
    }

    public GraphQLObjectType getObjectType(String typeName) {
        GraphQLType graphQLType = this.typeMap.get(typeName);
        if (graphQLType != null) {
            Assert.assertTrue(graphQLType instanceof GraphQLObjectType, "You have asked for named object type '%s' but its not an object type but rather a '%s'", typeName, graphQLType.getClass().getName());
        }
        return (GraphQLObjectType)graphQLType;
    }

    public Map<String, GraphQLNamedType> getTypeMap() {
        return Collections.unmodifiableMap(this.typeMap);
    }

    public List<GraphQLNamedType> getAllTypesAsList() {
        return GraphqlTypeComparators.sortTypes(GraphqlTypeComparators.byNameAsc(), this.typeMap.values());
    }

    public List<GraphQLObjectType> getImplementations(GraphQLInterfaceType type) {
        List<GraphQLObjectType> implementations = this.byInterface.get(type.getName());
        return implementations == null ? Collections.emptyList() : Collections.unmodifiableList(GraphqlTypeComparators.sortTypes(GraphqlTypeComparators.byNameAsc(), implementations));
    }

    public boolean isPossibleType(GraphQLNamedType abstractType, GraphQLObjectType concreteType) {
        if (abstractType instanceof GraphQLInterfaceType) {
            return this.getImplementations((GraphQLInterfaceType)abstractType).stream().map(GraphQLObjectType::getName).anyMatch(name -> concreteType.getName().equals(name));
        }
        if (abstractType instanceof GraphQLUnionType) {
            return ((GraphQLUnionType)abstractType).getTypes().stream().map(GraphQLNamedSchemaElement::getName).anyMatch(name -> concreteType.getName().equals(name));
        }
        return (Boolean)Assert.assertShouldNeverHappen("Unsupported abstract type %s. Abstract types supported are Union and Interface.", abstractType.getName());
    }

    public GraphQLObjectType getQueryType() {
        return this.queryType;
    }

    public GraphQLObjectType getMutationType() {
        return this.mutationType;
    }

    public GraphQLObjectType getSubscriptionType() {
        return this.subscriptionType;
    }

    @Deprecated
    public GraphqlFieldVisibility getFieldVisibility() {
        return this.codeRegistry.getFieldVisibility();
    }

    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public Map<String, GraphQLDirective> getDirectiveByName() {
        return DirectivesUtil.directivesByName(this.getDirectives());
    }

    public GraphQLDirective getDirective(String name) {
        for (GraphQLDirective directive : this.getDirectives()) {
            if (!directive.getName().equals(name)) continue;
            return directive;
        }
        return null;
    }

    public List<GraphQLDirective> getSchemaDirectives() {
        return new ArrayList<GraphQLDirective>(this.schemaDirectives.values());
    }

    public Map<String, GraphQLDirective> getSchemaDirectiveByName() {
        return DirectivesUtil.directivesByName(this.getSchemaDirectives());
    }

    public GraphQLDirective getSchemaDirective(String name) {
        return this.schemaDirectives.get(name);
    }

    public SchemaDefinition getDefinition() {
        return this.definition;
    }

    public List<SchemaExtensionDefinition> getExtensionDefinitions() {
        return new ArrayList<SchemaExtensionDefinition>(this.extensionDefinitions);
    }

    public boolean isSupportingMutations() {
        return this.mutationType != null;
    }

    public boolean isSupportingSubscriptions() {
        return this.subscriptionType != null;
    }

    public GraphQLSchema transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLSchema.newSchema(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newSchema() {
        return new Builder();
    }

    public static Builder newSchema(GraphQLSchema existingSchema) {
        return new Builder().query(existingSchema.getQueryType()).mutation(existingSchema.getMutationType()).subscription(existingSchema.getSubscriptionType()).codeRegistry(existingSchema.getCodeRegistry()).clearAdditionalTypes().clearDirectives().additionalDirectives(existingSchema.directives).clearSchemaDirectives().withSchemaDirectives(GraphQLSchema.schemaDirectivesArray(existingSchema)).additionalTypes(existingSchema.additionalTypes);
    }

    private static GraphQLDirective[] schemaDirectivesArray(GraphQLSchema existingSchema) {
        return existingSchema.schemaDirectives.values().toArray(new GraphQLDirective[0]);
    }

    public static class Builder {
        private GraphQLObjectType queryType;
        private GraphQLObjectType mutationType;
        private GraphQLObjectType subscriptionType;
        private GraphQLCodeRegistry codeRegistry = GraphQLCodeRegistry.newCodeRegistry().build();
        private Set<GraphQLType> additionalTypes = new LinkedHashSet<GraphQLType>();
        private SchemaDefinition definition;
        private List<SchemaExtensionDefinition> extensionDefinitions;
        private Set<GraphQLDirective> additionalDirectives = new LinkedHashSet<GraphQLDirective>(Arrays.asList(Directives.IncludeDirective, Directives.SkipDirective));
        private Map<String, GraphQLDirective> schemaDirectives = new LinkedHashMap<String, GraphQLDirective>();
        private SchemaUtil schemaUtil = new SchemaUtil();

        public Builder query(GraphQLObjectType.Builder builder) {
            return this.query(builder.build());
        }

        public Builder query(GraphQLObjectType queryType) {
            this.queryType = queryType;
            return this;
        }

        public Builder mutation(GraphQLObjectType.Builder builder) {
            return this.mutation(builder.build());
        }

        public Builder mutation(GraphQLObjectType mutationType) {
            this.mutationType = mutationType;
            return this;
        }

        public Builder subscription(GraphQLObjectType.Builder builder) {
            return this.subscription(builder.build());
        }

        public Builder subscription(GraphQLObjectType subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Deprecated
        public Builder fieldVisibility(GraphqlFieldVisibility fieldVisibility) {
            this.codeRegistry = this.codeRegistry.transform(builder -> builder.fieldVisibility(fieldVisibility));
            return this;
        }

        public Builder codeRegistry(GraphQLCodeRegistry codeRegistry) {
            this.codeRegistry = codeRegistry;
            return this;
        }

        public Builder additionalTypes(Set<GraphQLType> additionalTypes) {
            this.additionalTypes.addAll(additionalTypes);
            return this;
        }

        public Builder additionalType(GraphQLType additionalType) {
            this.additionalTypes.add(additionalType);
            return this;
        }

        public Builder clearAdditionalTypes() {
            this.additionalTypes.clear();
            return this;
        }

        public Builder additionalDirectives(Set<GraphQLDirective> additionalDirectives) {
            this.additionalDirectives.addAll(additionalDirectives);
            return this;
        }

        public Builder additionalDirective(GraphQLDirective additionalDirective) {
            this.additionalDirectives.add(additionalDirective);
            return this;
        }

        public Builder clearDirectives() {
            this.additionalDirectives.clear();
            return this;
        }

        public Builder withSchemaDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withSchemaDirective(directive);
            }
            return this;
        }

        public Builder withSchemaDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.schemaDirectives.put(directive.getName(), directive);
            return this;
        }

        public Builder withSchemaDirective(GraphQLDirective.Builder builder) {
            return this.withSchemaDirective(builder.build());
        }

        public Builder clearSchemaDirectives() {
            this.schemaDirectives.clear();
            return this;
        }

        public Builder definition(SchemaDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<SchemaExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        @Deprecated
        public GraphQLSchema build(Set<GraphQLType> additionalTypes) {
            return this.additionalTypes(additionalTypes).build();
        }

        @Deprecated
        public GraphQLSchema build(Set<GraphQLType> additionalTypes, Set<GraphQLDirective> additionalDirectives) {
            return this.additionalTypes(additionalTypes).additionalDirectives(additionalDirectives).build();
        }

        public GraphQLSchema build() {
            return this.buildImpl(false);
        }

        GraphQLSchema buildImpl(boolean afterTransform) {
            Assert.assertNotNull(this.additionalTypes, "additionalTypes can't be null", new Object[0]);
            Assert.assertNotNull(this.additionalDirectives, "additionalDirectives can't be null", new Object[0]);
            if (this.additionalDirectives.stream().noneMatch(d -> d.getName().equals(Directives.DeprecatedDirective.getName()))) {
                this.additionalDirectives.add(Directives.DeprecatedDirective);
            }
            GraphQLSchema tempSchema = new GraphQLSchema(this, afterTransform);
            this.codeRegistry = this.codeRegistry.transform(codeRegistryBuilder -> this.schemaUtil.extractCodeFromTypes((GraphQLCodeRegistry.Builder)codeRegistryBuilder, tempSchema));
            GraphQLSchema graphQLSchema = new GraphQLSchema(tempSchema, this.codeRegistry);
            this.schemaUtil.replaceTypeReferences(graphQLSchema);
            Set<SchemaValidationError> errors = new SchemaValidator().validateSchema(graphQLSchema);
            if (errors.size() > 0) {
                throw new InvalidSchemaException(errors);
            }
            return graphQLSchema;
        }
    }
}

