/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Internal;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.validation.AbstractRule;
import graphql.validation.DocumentVisitor;
import graphql.validation.LanguageTraversal;
import graphql.validation.ValidationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class RulesVisitor
implements DocumentVisitor {
    private final List<AbstractRule> rules = new ArrayList<AbstractRule>();
    private final ValidationContext validationContext;
    private boolean subVisitor;
    private final List<AbstractRule> rulesVisitingFragmentSpreads = new ArrayList<AbstractRule>();
    private final Map<Node, List<AbstractRule>> rulesToSkipByUntilNode = new IdentityHashMap<Node, List<AbstractRule>>();
    private final Set<AbstractRule> rulesToSkip = new LinkedHashSet<AbstractRule>();

    public RulesVisitor(ValidationContext validationContext, List<AbstractRule> rules) {
        this(validationContext, rules, false);
    }

    public RulesVisitor(ValidationContext validationContext, List<AbstractRule> rules, boolean subVisitor) {
        this.validationContext = validationContext;
        this.subVisitor = subVisitor;
        this.rules.addAll(rules);
        this.subVisitor = subVisitor;
        this.findRulesVisitingFragmentSpreads();
    }

    private void findRulesVisitingFragmentSpreads() {
        for (AbstractRule rule : this.rules) {
            if (!rule.isVisitFragmentSpreads()) continue;
            this.rulesVisitingFragmentSpreads.add(rule);
        }
    }

    @Override
    public void enter(Node node, List<Node> ancestors) {
        this.validationContext.getTraversalContext().enter(node, ancestors);
        LinkedHashSet<AbstractRule> tmpRulesSet = new LinkedHashSet<AbstractRule>(this.rules);
        tmpRulesSet.removeAll(this.rulesToSkip);
        ArrayList<AbstractRule> rulesToConsider = new ArrayList<AbstractRule>(tmpRulesSet);
        if (node instanceof Document) {
            this.checkDocument((Document)node, rulesToConsider);
        } else if (node instanceof Argument) {
            this.checkArgument((Argument)node, rulesToConsider);
        } else if (node instanceof TypeName) {
            this.checkTypeName((TypeName)node, rulesToConsider);
        } else if (node instanceof VariableDefinition) {
            this.checkVariableDefinition((VariableDefinition)node, rulesToConsider);
        } else if (node instanceof Field) {
            this.checkField((Field)node, rulesToConsider);
        } else if (node instanceof InlineFragment) {
            this.checkInlineFragment((InlineFragment)node, rulesToConsider);
        } else if (node instanceof Directive) {
            this.checkDirective((Directive)node, ancestors, rulesToConsider);
        } else if (node instanceof FragmentSpread) {
            this.checkFragmentSpread((FragmentSpread)node, rulesToConsider, ancestors);
        } else if (node instanceof FragmentDefinition) {
            this.checkFragmentDefinition((FragmentDefinition)node, rulesToConsider);
        } else if (node instanceof OperationDefinition) {
            this.checkOperationDefinition((OperationDefinition)node, rulesToConsider);
        } else if (node instanceof VariableReference) {
            this.checkVariable((VariableReference)node, rulesToConsider);
        } else if (node instanceof SelectionSet) {
            this.checkSelectionSet((SelectionSet)node, rulesToConsider);
        }
    }

    private void checkDocument(Document node, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkDocument(node);
        }
    }

    private void checkArgument(Argument node, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkArgument(node);
        }
    }

    private void checkTypeName(TypeName node, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkTypeName(node);
        }
    }

    private void checkVariableDefinition(VariableDefinition variableDefinition, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkVariableDefinition(variableDefinition);
        }
    }

    private void checkField(Field field, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkField(field);
        }
    }

    private void checkInlineFragment(InlineFragment inlineFragment, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkInlineFragment(inlineFragment);
        }
    }

    private void checkDirective(Directive directive, List<Node> ancestors, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkDirective(directive, ancestors);
        }
    }

    private void checkFragmentSpread(FragmentSpread fragmentSpread, List<AbstractRule> rules, List<Node> ancestors) {
        FragmentDefinition fragment;
        for (AbstractRule rule : rules) {
            rule.checkFragmentSpread(fragmentSpread);
        }
        List<AbstractRule> rulesVisitingFragmentSpreads = this.getRulesVisitingFragmentSpreads(rules);
        if (rulesVisitingFragmentSpreads.size() > 0 && (fragment = this.validationContext.getFragment(fragmentSpread.getName())) != null && !ancestors.contains(fragment)) {
            new LanguageTraversal(ancestors).traverse(fragment, new RulesVisitor(this.validationContext, rulesVisitingFragmentSpreads, true));
        }
    }

    private List<AbstractRule> getRulesVisitingFragmentSpreads(List<AbstractRule> rules) {
        ArrayList<AbstractRule> result = new ArrayList<AbstractRule>();
        for (AbstractRule rule : rules) {
            if (!rule.isVisitFragmentSpreads()) continue;
            result.add(rule);
        }
        return result;
    }

    private void checkFragmentDefinition(FragmentDefinition fragmentDefinition, List<AbstractRule> rules) {
        if (!this.subVisitor) {
            this.rulesToSkipByUntilNode.put(fragmentDefinition, new ArrayList<AbstractRule>(this.rulesVisitingFragmentSpreads));
            this.rulesToSkip.addAll(this.rulesVisitingFragmentSpreads);
        }
        for (AbstractRule rule : rules) {
            if (!this.subVisitor && rule.isVisitFragmentSpreads()) continue;
            rule.checkFragmentDefinition(fragmentDefinition);
        }
    }

    private void checkOperationDefinition(OperationDefinition operationDefinition, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkOperationDefinition(operationDefinition);
        }
    }

    private void checkSelectionSet(SelectionSet selectionSet, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkSelectionSet(selectionSet);
        }
    }

    private void checkVariable(VariableReference variableReference, List<AbstractRule> rules) {
        for (AbstractRule rule : rules) {
            rule.checkVariable(variableReference);
        }
    }

    @Override
    public void leave(Node node, List<Node> ancestors) {
        this.validationContext.getTraversalContext().leave(node, ancestors);
        if (node instanceof Document) {
            this.documentFinished((Document)node);
        } else if (node instanceof OperationDefinition) {
            this.leaveOperationDefinition((OperationDefinition)node);
        } else if (node instanceof SelectionSet) {
            this.leaveSelectionSet((SelectionSet)node);
        }
        if (this.rulesToSkipByUntilNode.containsKey(node)) {
            this.rulesToSkip.removeAll((Collection)this.rulesToSkipByUntilNode.get(node));
            this.rulesToSkipByUntilNode.remove(node);
        }
    }

    private void leaveSelectionSet(SelectionSet selectionSet) {
        for (AbstractRule rule : this.rules) {
            rule.leaveSelectionSet(selectionSet);
        }
    }

    private void leaveOperationDefinition(OperationDefinition operationDefinition) {
        for (AbstractRule rule : this.rules) {
            rule.leaveOperationDefinition(operationDefinition);
        }
    }

    private void documentFinished(Document document) {
        for (AbstractRule rule : this.rules) {
            rule.documentFinished(document);
        }
    }
}

