/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.concurrent.persistent.TaskState;
import com.ibm.websphere.ras.annotation.Trivial;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.TimeZone;

@Trivial
public class Utils {
    private static final String EOLN = String.format("%n", new Object[0]);

    public static final StringBuilder appendDate(StringBuilder sb, Long millis) {
        if (millis == null) {
            return sb.append((Object)null);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        TimeZone zone = cal.getTimeZone();
        sb.append(cal.get(1)).append('/');
        int m = cal.get(2);
        if (++m < 10) {
            sb.append('0');
        }
        sb.append(m).append('/');
        int d = cal.get(5);
        if (d < 10) {
            sb.append('0');
        }
        sb.append(d).append('-');
        int h = cal.get(11);
        if (h < 10) {
            sb.append('0');
        }
        sb.append(h).append(':');
        m = cal.get(12);
        if (m < 10) {
            sb.append('0');
        }
        sb.append(m).append(':');
        int s = cal.get(13);
        if (s < 10) {
            sb.append('0');
        }
        sb.append(s).append('.');
        int ms = cal.get(14);
        if (ms < 100) {
            sb.append('0');
        }
        if (ms < 10) {
            sb.append('0');
        }
        sb.append(ms).append('-');
        sb.append(zone.getDisplayName(zone.inDaylightTime(cal.getTime()), 0));
        sb.append('[').append(millis).append(']');
        return sb;
    }

    public static final void appendState(StringBuilder sb, short bits) {
        if ((bits & TaskState.SCHEDULED.bit) != 0) {
            sb.append(TaskState.SCHEDULED.name()).append(',');
        }
        if ((bits & TaskState.ENDED.bit) != 0) {
            sb.append(TaskState.ENDED.name()).append(',');
        }
        if ((bits & TaskState.SUSPENDED.bit) != 0) {
            sb.append(TaskState.SUSPENDED.name()).append(',');
        }
        if ((bits & TaskState.UNATTEMPTED.bit) != 0) {
            sb.append(TaskState.UNATTEMPTED.name()).append(',');
        }
        if ((bits & TaskState.SKIPPED.bit) != 0) {
            sb.append(TaskState.SKIPPED.name()).append(',');
        }
        if ((bits & TaskState.SKIPRUN_FAILED.bit) != 0) {
            sb.append(TaskState.SKIPRUN_FAILED.name()).append(',');
        }
        if ((bits & TaskState.FAILURE_LIMIT_REACHED.bit) != 0) {
            sb.append(TaskState.FAILURE_LIMIT_REACHED.name()).append(',');
        }
        if ((bits & TaskState.CANCELED.bit) != 0) {
            sb.append(TaskState.CANCELED.name()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    @Trivial
    public static final String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        String result = obj.toString();
        if (result.indexOf(64) > 0 && result.contains(obj.getClass().getSimpleName())) {
            return result;
        }
        return obj.getClass().getName() + '@' + Integer.toHexString(obj.hashCode()) + ": " + result;
    }

    @Trivial
    public static final String normalizeString(String str) {
        return str == null || str.length() == 0 ? " " : str;
    }

    public static String stackTraceToString(Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (int depth = 0; depth < 10 && th != null; ++depth) {
            th.printStackTrace(pw);
            Throwable cause = th.getCause();
            if (cause != null && cause != th) {
                pw.append("-------- chained exception -------").append(EOLN);
            }
            th = cause;
        }
        return sw.toString();
    }
}

