/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.PolicyTaskCallback;
import com.ibm.ws.threading.PolicyTaskFuture;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import javax.enterprise.concurrent.AbortedException;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedTask;
import javax.enterprise.concurrent.ManagedTaskListener;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TaskLifeCycleCallback
extends PolicyTaskCallback {
    private static final TraceComponent tc = Tr.register(TaskLifeCycleCallback.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private final ManagedExecutorServiceImpl managedExecutor;
    final PolicyExecutor policyExecutor;
    private final ThreadContextDescriptor threadContextDescriptor;
    static final long serialVersionUID = 746483365021764042L;

    TaskLifeCycleCallback(ManagedExecutorServiceImpl managedExecutor, ThreadContextDescriptor threadContextDescriptor) {
        this.managedExecutor = managedExecutor;
        this.threadContextDescriptor = threadContextDescriptor;
        Map execProps = threadContextDescriptor.getExecutionProperties();
        String longRunning = (String)execProps.get("jakarta.enterprise.concurrent.LONGRUNNING_HINT");
        if (longRunning == null) {
            longRunning = (String)execProps.get("javax.enterprise.concurrent.LONGRUNNING_HINT");
        }
        PolicyExecutor executor = Boolean.parseBoolean(longRunning) ? managedExecutor.longRunningPolicyExecutorRef.get() : null;
        this.policyExecutor = executor == null ? managedExecutor.policyExecutor : executor;
    }

    public final PolicyExecutor getExecutor(PolicyExecutor executor) {
        return this.policyExecutor;
    }

    @Trivial
    public String getIdentifier(String identifier) {
        return this.managedExecutor.getIdentifier(identifier);
    }

    @Trivial
    public final String getName(Object task) {
        String taskName;
        Map execProps = this.threadContextDescriptor.getExecutionProperties();
        if (execProps == null) {
            taskName = null;
        } else {
            taskName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
            if (taskName == null) {
                taskName = (String)execProps.get("javax.enterprise.concurrent.IDENTITY_NAME");
            }
        }
        return taskName == null ? task.toString() : taskName;
    }

    @Trivial
    public final long getStartTimeout(long defaultStartTimeoutNS) {
        Map execProps = this.threadContextDescriptor.getExecutionProperties();
        String value = execProps == null ? null : (String)execProps.get("com.ibm.ws.concurrent.START_TIMEOUT_NANOS");
        try {
            long ns;
            long l = ns = value == null ? defaultStartTimeoutNS : Long.parseLong(value);
            if (ns < -1L) {
                throw new IllegalArgumentException("com.ibm.ws.concurrent.START_TIMEOUT_NANOS: " + value);
            }
            return ns;
        }
        catch (NumberFormatException ns) {
            FFDCFilter.processException((Throwable)ns, (String)"com.ibm.ws.concurrent.internal.TaskLifeCycleCallback", (String)"131", (Object)((Object)this), (Object[])new Object[]{defaultStartTimeoutNS});
            throw new IllegalArgumentException("com.ibm.ws.concurrent.START_TIMEOUT_NANOS: " + value);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={Error.class, RuntimeException.class})
    public void onCancel(Object task, PolicyTaskFuture<?> future, boolean whileRunning) {
        if (whileRunning) return;
        if (!(task instanceof ManagedTask)) return;
        ManagedTaskListener listener = ((ManagedTask)task).getManagedTaskListener();
        if (listener == null) return;
        Throwable failure = null;
        ThreadContext tranContextRestorer = this.managedExecutor.suspendTransaction();
        try {
            CancellationException x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(task), this.managedExecutor.name}));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecutor, task, x});
            }
            listener.taskAborted(future, (ManagedExecutorService)this.managedExecutor, task, (Throwable)x);
        }
        catch (Error x7) {
            try {
                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x7});
                failure = x7;
                throw x7;
                catch (RuntimeException x2) {
                    Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x2});
                    failure = x2;
                    throw x2;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecutor, task, failure});
                    }
                    listener.taskDone(future, (ManagedExecutorService)this.managedExecutor, task, failure);
                    throw throwable;
                }
                catch (Error x3) {
                    Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x3});
                    throw x3;
                }
                catch (RuntimeException x4) {
                    Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x4});
                    throw x4;
                }
                finally {
                    if (tranContextRestorer != null) {
                        tranContextRestorer.taskStopping();
                    }
                }
            }
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecutor, task, failure});
            }
            listener.taskDone(future, (ManagedExecutorService)this.managedExecutor, task, failure);
            return;
        }
        catch (Error x5) {
            Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x5});
            throw x5;
        }
        catch (RuntimeException x6) {
            Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x6});
            throw x6;
        }
        finally {
            if (tranContextRestorer != null) {
                tranContextRestorer.taskStopping();
            }
        }
    }

    @FFDCIgnore(value={Throwable.class})
    public void onEnd(Object task, PolicyTaskFuture<?> future, Object startObj, boolean aborted, int pending, Throwable failure) {
        ManagedTaskListener listener;
        if (pending >= 0 && task instanceof ManagedTask && (listener = ((ManagedTask)task).getManagedTaskListener()) != null) {
            block9: {
                try {
                    boolean canceled = future.isCancelled();
                    if (canceled || aborted) {
                        Object x = failure instanceof CancellationException ? failure : (canceled ? new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(task), this.managedExecutor.name})) : (aborted ? new AbortedException(failure) : failure));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecutor, task, x});
                        }
                        listener.taskAborted(future, (ManagedExecutorService)this.managedExecutor, task, (Throwable)x);
                    }
                }
                catch (Throwable x) {
                    Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x});
                    if (failure != null) break block9;
                    failure = x;
                }
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{this.managedExecutor, task, failure});
                }
                listener.taskDone(future, (ManagedExecutorService)this.managedExecutor, task, failure);
            }
            catch (Throwable x) {
                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x});
            }
        }
        if (pending <= 0 && startObj != null) {
            ArrayList contextAppliedToThread = (ArrayList)startObj;
            this.threadContextDescriptor.taskStopping(contextAppliedToThread);
        }
    }

    @FFDCIgnore(value={Error.class, RuntimeException.class})
    public Object onStart(Object task, PolicyTaskFuture<?> future) {
        ManagedTaskListener listener;
        ArrayList contextAppliedToThread = this.threadContextDescriptor.taskStarting();
        if (task instanceof ManagedTask && (listener = ((ManagedTask)task).getManagedTaskListener()) != null) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"taskStarting", (Object[])new Object[]{this.managedExecutor, task});
                }
                listener.taskStarting(future, (ManagedExecutorService)this.managedExecutor, task);
            }
            catch (Error x) {
                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x});
                this.threadContextDescriptor.taskStopping(contextAppliedToThread);
                throw x;
            }
            catch (RuntimeException x) {
                Tr.error((TraceComponent)tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(task), this.managedExecutor.name, x});
                this.threadContextDescriptor.taskStopping(contextAppliedToThread);
                throw x;
            }
        }
        return contextAppliedToThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubmit(Object task, PolicyTaskFuture<?> future, int invokeAnyCount) {
        ManagedTaskListener listener;
        if (task instanceof ManagedTask && (listener = ((ManagedTask)task).getManagedTaskListener()) != null) {
            ThreadContext tranContextRestorer = this.managedExecutor.suspendTransaction();
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"taskSubmitted", (Object[])new Object[]{this.managedExecutor, task});
                }
                listener.taskSubmitted(future, (ManagedExecutorService)this.managedExecutor, task);
            }
            finally {
                if (tranContextRestorer != null) {
                    tranContextRestorer.taskStopping();
                }
            }
            if (invokeAnyCount <= 1 && future.isCancelled()) {
                if (invokeAnyCount == 1) {
                    throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1112.all.tasks.canceled", (Object[])new Object[0]));
                }
                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(task), this.managedExecutor.name}));
            }
        }
    }

    public void raiseAbortedException(Throwable x) throws ExecutionException {
        throw new AbortedException(x);
    }

    public void resolveDeadlockOnFutureGet() throws InterruptedException {
        throw new InterruptedException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1120.future.get.rejected", (Object[])new Object[0]));
    }
}

