/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.naming;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Arrays;
import java.util.Comparator;

public interface NamingConstants {
    public static final String JNDI_NAME_KEY = "jndi-name";
    public static final String RES_REF_AUTH = "res-ref-auth";
    public static final String RES_REF_SHARING = "res-ref-sharing";
    public static final String JAVA_NS = "java:";

    public static enum JavaColonNamespace {
        COMP("comp"),
        COMP_ENV("comp/env"),
        COMP_WS("comp/websphere"),
        GLOBAL("global"),
        APP("app"),
        MODULE("module");

        private static final JavaColonNamespace[] VALUES_SORTED_BY_PREFIX;
        private final String name;
        private final String prefix;

        public static JavaColonNamespace match(String name) {
            for (JavaColonNamespace namespace : VALUES_SORTED_BY_PREFIX) {
                if (!name.startsWith(namespace.prefix())) continue;
                return namespace;
            }
            return null;
        }

        public static JavaColonNamespace fromName(String name) {
            for (JavaColonNamespace namespace : VALUES_SORTED_BY_PREFIX) {
                if (!namespace.qualifiedName().equals(name)) continue;
                return namespace;
            }
            return null;
        }

        private JavaColonNamespace(String name) {
            this.name = NamingConstants.JAVA_NS + name;
            this.prefix = this.name + '/';
        }

        public String toString() {
            return this.name;
        }

        @Trivial
        public String qualifiedName() {
            return this.name;
        }

        @Trivial
        public String prefix() {
            return this.prefix;
        }

        public String unprefix(String name) {
            if (!name.startsWith(this.prefix)) {
                throw new IllegalArgumentException("name=" + name);
            }
            return name.substring(this.prefix.length());
        }

        public boolean isComp() {
            return this == COMP || this == COMP_ENV || this == COMP_WS;
        }

        static {
            VALUES_SORTED_BY_PREFIX = JavaColonNamespace.values();
            Arrays.sort(VALUES_SORTED_BY_PREFIX, new Comparator<JavaColonNamespace>(){
                static final long serialVersionUID = -2657928918644004857L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int compare(JavaColonNamespace namespace1, JavaColonNamespace namespace2) {
                    String prefix2;
                    String prefix1 = namespace1.prefix();
                    if (prefix1.startsWith(prefix2 = namespace2.prefix())) {
                        return -1;
                    }
                    if (prefix2.startsWith(prefix1)) {
                        return 1;
                    }
                    return prefix1.compareTo(prefix2);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.naming.NamingConstants$JavaColonNamespace$1", 1.class, (String)"Naming", null);
                }
            });
        }
    }
}

