/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.metadata;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.MetaDataSlotImpl;
import com.ibm.ws.runtime.metadata.MethodMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import java.util.Arrays;

public abstract class MetaDataImpl
implements MetaData {
    private static final TraceComponent tc = Tr.register(MetaDataImpl.class, (String)"Runtime");
    private static final int NUM_STATIC_SLOTS = 4;
    static final int ID_UNINITIALIZED = -1;
    int id = -1;
    private final Class<? extends MetaData> metaDataInterface;
    private final Object[] staticSlots = new Object[4];
    private Object[] dynamicSlots;

    public MetaDataImpl(int slotCnt) {
        if (this instanceof ApplicationMetaData) {
            this.metaDataInterface = ApplicationMetaData.class;
        } else if (this instanceof ModuleMetaData) {
            this.metaDataInterface = ModuleMetaData.class;
        } else if (this instanceof ComponentMetaData) {
            this.metaDataInterface = ComponentMetaData.class;
        } else if (this instanceof MethodMetaData) {
            this.metaDataInterface = MethodMetaData.class;
        } else {
            throw new IllegalStateException("invalid metadata type");
        }
    }

    public String toString() {
        String string = super.toString();
        if (this.metaDataInterface == ApplicationMetaData.class) {
            string = string + "[" + ((ApplicationMetaData)((Object)this)).getJ2EEName() + ']';
        } else if (this.metaDataInterface == ModuleMetaData.class) {
            string = string + "[" + ((ModuleMetaData)((Object)this)).getJ2EEName() + ']';
        } else if (this.metaDataInterface == ComponentMetaData.class) {
            string = string + "[" + ((ComponentMetaData)((Object)this)).getJ2EEName() + ']';
        } else if (this.metaDataInterface == MethodMetaData.class) {
            MethodMetaData thisMethod = (MethodMetaData)((Object)this);
            ComponentMetaData cmd = thisMethod.getComponentMetaData();
            string = string + "[" + (cmd == null ? null : cmd.getJ2EEName()) + ", " + thisMethod.getName() + ']';
        }
        return string;
    }

    private MetaDataSlotImpl getMetaDataSlotImpl(MetaDataSlot slot) {
        MetaDataSlotImpl slotImpl = (MetaDataSlotImpl)slot;
        Class<? extends MetaData> slotInterface = slotImpl.metadataIntf;
        if (slotInterface != this.metaDataInterface) {
            IllegalArgumentException iae = new IllegalArgumentException(slotInterface + " slot for " + this.metaDataInterface + ": " + this.getClass().getName());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkSlotAccess", (Object[])new Object[]{iae});
            }
            throw iae;
        }
        return slotImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetaData(MetaDataSlot slot, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMetaData(this=" + this + ", slot=" + slot + ", metadata=" + Util.identity(value) + ")"), (Object[])new Object[0]);
        }
        MetaDataSlotImpl slotImpl = this.getMetaDataSlotImpl(slot);
        MetaDataSlot metaDataSlot = slot;
        synchronized (metaDataSlot) {
            if (slotImpl.destroyed) {
                throw new IllegalStateException();
            }
            this.setMetaData(slotImpl, value, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setMetaData(MetaDataSlotImpl slotImpl, Object value, boolean destroy) {
        int slotId = slotImpl.id;
        if (slotId < 4) {
            this.staticSlots[slotId] = value;
            return;
        }
        int dynamicSlotId = slotId - 4;
        Object[] objectArray = this.staticSlots;
        synchronized (this.staticSlots) {
            Object[] dynamicSlots = this.dynamicSlots;
            if (dynamicSlots == null) {
                if (destroy) return;
                this.dynamicSlots = dynamicSlots = new Object[Math.max(MetaDataImpl.roundUpPowerOfTwo(dynamicSlotId), 4)];
                dynamicSlots[dynamicSlotId] = value;
            } else if (dynamicSlotId >= dynamicSlots.length) {
                if (destroy) return;
                this.dynamicSlots = dynamicSlots = Arrays.copyOf(dynamicSlots, MetaDataImpl.roundUpPowerOfTwo(dynamicSlotId));
                dynamicSlots[dynamicSlotId] = value;
            } else {
                dynamicSlots[dynamicSlotId] = value;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    private static int roundUpPowerOfTwo(int n) {
        return Integer.highestOneBit(n) << 1;
    }

    @Override
    public Object getMetaData(MetaDataSlot slot) {
        Object value = this.getMetaData(this.getMetaDataSlotImpl(slot));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getMetaData(this=" + this + ", slot=" + slot + ") --> " + value), (Object[])new Object[0]);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Object getMetaData(MetaDataSlotImpl slot) {
        Object value;
        int slotId = slot.id;
        if (slotId < 4) {
            value = this.staticSlots[slotId];
        } else {
            int dynamicSlotId = slotId - 4;
            Object[] objectArray = this.staticSlots;
            // MONITORENTER : this.staticSlots
            value = this.dynamicSlots == null || dynamicSlotId >= this.dynamicSlots.length ? null : this.dynamicSlots[dynamicSlotId];
            // MONITOREXIT : objectArray
        }
        if (!slot.destroyed) return value;
        throw new IllegalStateException();
    }

    @Override
    public void release() {
    }
}

