/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.NonSyncHashtable;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TimeLimitDaemon
extends RealTimeDaemon {
    private static TraceComponent tc = Tr.register(TimeLimitDaemon.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final boolean UNIT_TEST_INACTIVITY = false;
    private static final boolean IS_UNIT_TEST = false;
    private static final int DEFAULT_SIZE_FOR_MEM = 1024;
    private static final int DEFAULT_SIZE_FOR_MEM_DISK = 20480;
    private InvalidationTaskPool taskPool = new InvalidationTaskPool(100);
    private ConcurrentHashMap<DCache, ExpirationMetaData> cacheInstancesTable = new ConcurrentHashMap(10, 2.0f, 2);
    private long lastTimeReleaseDiskCachePool = 0L;
    private long lastTimeoutCheckedTime = 0L;
    private int timeoutTriggerTime = 0;
    private int lruToDiskTriggerTime = 0;
    private boolean isLruToDiskRunnning = false;

    public TimeLimitDaemon(int timeGranularityInSeconds, int lruToDiskTriggerTime) {
        super(lruToDiskTriggerTime);
        this.lruToDiskTriggerTime = lruToDiskTriggerTime;
        this.timeoutTriggerTime = timeGranularityInSeconds * 1000;
        this.isLruToDiskRunnning = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating TimeLimitDaemon - set time granularity to " + timeGranularityInSeconds + " lruToDiskTriggerTime=" + this.lruToDiskTriggerTime), (Object[])new Object[0]);
        }
        this.lastTimeReleaseDiskCachePool = System.currentTimeMillis();
        if (timeGranularityInSeconds <= 0) {
            throw new IllegalArgumentException("timeGranularityInSeconds must be positive");
        }
    }

    @Override
    public void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeUp(long startDaemonTime, long startWakeUpTime) {
        block14: {
            boolean bTimeOutChecked = false;
            try {
                if (this.lruToDiskTriggerTime != this.timeoutTriggerTime && startWakeUpTime - this.lastTimeoutCheckedTime < (long)this.timeoutTriggerTime) break block14;
                this.lastTimeoutCheckedTime = startWakeUpTime;
                ArrayList<InvalidationData> invalidateIds = new ArrayList<InvalidationData>();
                for (Map.Entry<DCache, ExpirationMetaData> entry : this.cacheInstancesTable.entrySet()) {
                    ExpirationMetaData expirationMetaData;
                    DCache cache = entry.getKey();
                    ExpirationMetaData expirationMetaData2 = expirationMetaData = entry.getValue();
                    synchronized (expirationMetaData2) {
                        InvalidationTask currentTask = expirationMetaData.timeLimitHeap.minimum();
                        while (currentTask != null) {
                            if (currentTask.expirationTime <= startWakeUpTime) {
                                currentTask = expirationMetaData.timeLimitHeap.deleteMin();
                                expirationMetaData.expirationTable.remove(currentTask.id);
                                invalidateIds.add(new InvalidationData(currentTask.id, currentTask.isInactivityTimeOut));
                                currentTask.reset();
                                this.taskPool.add(currentTask);
                                currentTask = expirationMetaData.timeLimitHeap.minimum();
                                continue;
                            }
                            currentTask = null;
                        }
                    }
                    if (invalidateIds.size() <= 0) continue;
                    for (InvalidationData idata : invalidateIds) {
                        cache.invalidateById(idata.id, idata.isInactivityTimeOut ? 6 : 3, false);
                    }
                    invalidateIds.clear();
                }
                this.diskCacheHouseKeeping();
                bTimeOutChecked = true;
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.TimeLimitDaemon.wakeUp", (String)"152", (Object)this);
            }
            finally {
                if (!this.isLruToDiskRunnning) {
                    this.isLruToDiskRunnning = true;
                    Map caches = ServerCache.getCacheInstances();
                    for (DCache cache : caches.values()) {
                        if (cache == null || !cache.getCacheConfig().isDefaultCacheProvider() || !bTimeOutChecked && cache.getCacheConfig().getLruToDiskTriggerPercent() <= 0 && !cache.isCacheSizeInMBEnabled()) continue;
                        cache.trimCache();
                    }
                    this.isLruToDiskRunnning = false;
                }
            }
        }
    }

    private void diskCacheHouseKeeping() {
        boolean bReleaseDiskCachePool = false;
        if (System.currentTimeMillis() - this.lastTimeReleaseDiskCachePool > 3600000L) {
            bReleaseDiskCachePool = true;
            this.lastTimeReleaseDiskCachePool = System.currentTimeMillis();
        }
        String cacheName2 = null;
        DCache ci = null;
        for (String cacheName2 : ServerCache.getCacheInstances().keySet()) {
            ci = ServerCache.getCache(cacheName2);
            if (ci == null || !ci.getCacheConfig().isDefaultCacheProvider()) continue;
            if (ci.isDiskInvalidationBufferFull()) {
                ci.invokeDiskCleanup(false);
            }
            if (!bReleaseDiskCachePool) continue;
            ci.releaseDiskCacheUnusedPools();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueHasChanged(DCache cache, Object id, long expirationTime, int inactivity) {
        ExpirationMetaData expirationMetaData;
        long adjustedExpirationTime;
        if (expirationTime <= 0L && inactivity <= 0) {
            throw new IllegalArgumentException("expirationTime or inactivity must be positive");
        }
        boolean isInactivityTimeOut = false;
        if (inactivity > 0 && ((adjustedExpirationTime = System.currentTimeMillis() + (long)(inactivity * 1000)) < expirationTime || expirationTime <= 0L)) {
            expirationTime = adjustedExpirationTime;
            isInactivityTimeOut = true;
        }
        if ((expirationMetaData = this.cacheInstancesTable.get(cache)) == null) {
            return;
        }
        ExpirationMetaData expirationMetaData2 = expirationMetaData;
        synchronized (expirationMetaData2) {
            InvalidationTask it = (InvalidationTask)expirationMetaData.expirationTable.get(id);
            if (it == null) {
                it = (InvalidationTask)this.taskPool.remove();
                it.id = id;
                expirationMetaData.expirationTable.put(id, it);
            } else {
                expirationMetaData.timeLimitHeap.delete(it);
            }
            it.expirationTime = expirationTime;
            it.isInactivityTimeOut = isInactivityTimeOut;
            expirationMetaData.timeLimitHeap.insert(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueWasRemoved(DCache cache, Object id) {
        ExpirationMetaData expirationMetaData = this.cacheInstancesTable.get(cache);
        if (expirationMetaData == null) {
            return;
        }
        ExpirationMetaData expirationMetaData2 = expirationMetaData;
        synchronized (expirationMetaData2) {
            InvalidationTask it = (InvalidationTask)expirationMetaData.expirationTable.remove(id);
            if (it != null) {
                expirationMetaData.timeLimitHeap.delete(it);
                it.reset();
                this.taskPool.add(it);
            }
        }
    }

    public void valueWasAccessed(DCache cache, Object id, long expirationTime, int inactivity) {
        this.valueHasChanged(cache, id, expirationTime, inactivity);
    }

    public void createExpirationMetaData(DCache cache) {
        ExpirationMetaData expirationMetaData = this.cacheInstancesTable.get(cache);
        if (expirationMetaData == null) {
            int initialTableSize = 1024;
            if (cache.getSwapToDisk() && cache.getCacheConfig().getDiskCachePerformanceLevel() == 3) {
                initialTableSize = 20480;
            }
            expirationMetaData = new ExpirationMetaData(initialTableSize);
            this.cacheInstancesTable.put(cache, expirationMetaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheCleared(DCache cache) {
        String methodName = "cacheCleared()";
        ExpirationMetaData expirationMetaData = this.cacheInstancesTable.get(cache);
        if (expirationMetaData == null) {
            return;
        }
        ExpirationMetaData expirationMetaData2 = expirationMetaData;
        synchronized (expirationMetaData2) {
            if (!expirationMetaData.expirationTable.isEmpty()) {
                Enumeration e = expirationMetaData.expirationTable.elements();
                while (e.hasMoreElements()) {
                    InvalidationTask it = (InvalidationTask)e.nextElement();
                    it.reset();
                    this.taskPool.add(it);
                }
                expirationMetaData.expirationTable.clear();
                expirationMetaData.timeLimitHeap.clear();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cacheCleared()" + cache.getCacheName() + " expirationTable=" + expirationMetaData.expirationTable.size()), (Object[])new Object[0]);
                }
            }
        }
    }

    public static class BinaryHeap {
        private InvalidationTask[] heapArray;
        private int heapSize;

        public BinaryHeap(int size) {
            this.heapArray = new InvalidationTask[size];
            InvalidationTask negInfinity = new InvalidationTask();
            negInfinity.expirationTime = Long.MIN_VALUE;
            negInfinity.index = 0;
            this.heapArray[0] = negInfinity;
            this.heapSize = 0;
        }

        public synchronized void insert(InvalidationTask el) {
            int i = ++this.heapSize;
            this.growIfNec();
            while (el.lessThan(this.heapArray[BinaryHeap.parent(i)])) {
                this.heapArray[i] = this.heapArray[BinaryHeap.parent(i)];
                this.heapArray[i].index = i;
                i = BinaryHeap.parent(i);
            }
            this.heapArray[i] = el;
            this.heapArray[i].index = i;
        }

        public final InvalidationTask minimum() {
            if (this.isEmpty()) {
                return null;
            }
            return this.heapArray[1];
        }

        public final synchronized InvalidationTask deleteMin() {
            InvalidationTask min;
            if (this.isEmpty()) {
                min = null;
            } else {
                InvalidationTask last = this.heapArray[this.heapSize];
                this.heapArray[this.heapSize--] = null;
                if (this.isEmpty()) {
                    min = last;
                } else {
                    min = this.heapArray[1];
                    this.heapArray[1] = last;
                    this.heapArray[1].index = 1;
                    this.heapify(1);
                }
            }
            return min;
        }

        public synchronized void delete(InvalidationTask el) {
            int i = this.findKey(el);
            if (i == -1) {
                throw new IllegalArgumentException();
            }
            this.heapArray[i] = this.heapArray[0];
            this.heapArray[i].index = i;
            this.percolateUp(i);
            this.deleteMin();
            this.heapArray[0].index = 0;
        }

        private int findKey(InvalidationTask c) {
            return c.index;
        }

        private void percolateUp(int i) {
            while (this.heapArray[i].lessThan(this.heapArray[BinaryHeap.parent(i)])) {
                int j = BinaryHeap.parent(i);
                InvalidationTask c = this.heapArray[j];
                this.heapArray[j] = this.heapArray[i];
                this.heapArray[j].index = j;
                this.heapArray[i] = c;
                this.heapArray[i].index = i;
                int prev = i;
                i = j;
                this.heapify(prev);
            }
        }

        private final void heapify(int i) {
            InvalidationTask tmp = this.heapArray[i];
            while (BinaryHeap.left(i) <= this.heapSize) {
                int l = BinaryHeap.left(i);
                if (l < this.heapSize && this.heapArray[BinaryHeap.right(i)].lessThan(this.heapArray[l])) {
                    ++l;
                }
                if (!this.heapArray[l].lessThan(tmp)) break;
                this.heapArray[i] = this.heapArray[l];
                this.heapArray[i].index = i;
                i = l;
            }
            this.heapArray[i] = tmp;
            this.heapArray[i].index = i;
        }

        public final boolean isEmpty() {
            return this.heapSize == 0;
        }

        public final int size() {
            return this.heapSize;
        }

        public final void clear() {
            for (int i = 1; i <= this.heapSize; ++i) {
                this.heapArray[i] = null;
            }
            this.heapSize = 0;
        }

        private static final int parent(int i) {
            return i / 2;
        }

        private static final int left(int i) {
            return 2 * i;
        }

        private static final int right(int i) {
            return 2 * i + 1;
        }

        private void growIfNec() {
            if (this.heapSize + 1 == this.heapArray.length) {
                InvalidationTask[] oldHeap = this.heapArray;
                this.heapArray = new InvalidationTask[this.heapSize * 2];
                System.arraycopy(oldHeap, 0, this.heapArray, 0, oldHeap.length);
            }
        }
    }

    static class InvalidationTaskPool
    extends ObjectPool {
        public InvalidationTaskPool(int size) {
            super("InvalidationTaskPool", size);
        }

        protected Object createObject() {
            return new InvalidationTask();
        }
    }

    public static class InvalidationTask {
        public Object id;
        public long expirationTime;
        public boolean isInactivityTimeOut = false;
        public int index;

        public final boolean lessThan(InvalidationTask other) {
            return this.expirationTime < other.expirationTime;
        }

        public final boolean equals(InvalidationTask other) {
            return this.expirationTime == other.expirationTime;
        }

        public final boolean lessThanOrEquals(InvalidationTask other) {
            return this.expirationTime <= other.expirationTime;
        }

        public final void reset() {
            this.id = null;
            this.expirationTime = -1L;
            this.isInactivityTimeOut = false;
            this.index = -1;
        }
    }

    public static class InvalidationData {
        public Object id;
        public boolean isInactivityTimeOut;

        public InvalidationData(Object id, boolean isInactivityTimeOut) {
            this.id = id;
            this.isInactivityTimeOut = isInactivityTimeOut;
        }
    }

    public static class ExpirationMetaData {
        public NonSyncHashtable expirationTable;
        public BinaryHeap timeLimitHeap;

        public ExpirationMetaData(int initialTableSize) {
            this.expirationTable = new NonSyncHashtable(initialTableSize);
            this.timeLimitHeap = new BinaryHeap(initialTableSize);
        }
    }
}

