/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cache;

import com.ibm.ws.cache.intf.DCache;
import com.ibm.wsspi.cache.CacheEntry;
import com.ibm.wsspi.cache.CacheStatisticsListener;
import java.util.Collection;
import java.util.Enumeration;

public class Cache {
    private DCache cacheInstance = null;

    public Cache(com.ibm.websphere.cache.Cache ci) {
        this.cacheInstance = (DCache)ci;
    }

    public void refreshEntry(CacheEntry ce) {
        this.cacheInstance.refreshEntry(ce.cacheEntry);
    }

    public boolean getSwapToDisk() {
        return this.cacheInstance.getSwapToDisk();
    }

    public CacheEntry getEntryDisk(Object cacheId) {
        CacheEntry cacheEntry = new CacheEntry(this.cacheInstance.getEntryDisk(cacheId));
        return cacheEntry;
    }

    public void clearDisk() {
        this.cacheInstance.clearDisk();
    }

    public Collection getIdsByRangeDisk(int index, int length) {
        return this.cacheInstance.getIdsByRangeDisk(index, length);
    }

    public Collection getTemplatesByRangeDisk(int index, int length) {
        return this.cacheInstance.getTemplatesByRangeDisk(index, length);
    }

    public CacheStatisticsListener getCacheStatisticsListener() {
        return new CacheStatisticsListener(this.cacheInstance.getCacheStatisticsListener());
    }

    public CacheEntry getEntry(Object cacheId) {
        CacheEntry cacheEntry = new CacheEntry(this.cacheInstance.getEntry(cacheId));
        return cacheEntry;
    }

    public void invalidateById(String id, boolean waitOnInvalidation) {
        this.cacheInstance.invalidateById(id, waitOnInvalidation);
    }

    public void invalidateByTemplate(String template, boolean waitOnInvalidation) {
        this.cacheInstance.invalidateByTemplate(template, waitOnInvalidation);
    }

    public void clear() {
        this.cacheInstance.clear();
    }

    public Enumeration getAllIds() {
        return this.cacheInstance.getAllIds();
    }

    public int getMaxNumberCacheEntries() {
        return (int)this.cacheInstance.getCacheConfig().getMaxCacheSize();
    }

    public int getNumberCacheEntries() {
        return this.cacheInstance.getNumberCacheEntries();
    }

    public int getMaxCacheSizeInMB() {
        return (int)this.cacheInstance.getCacheConfig().getMaxCacheSizeInMB();
    }

    public float getMemoryCacheSizeInMB() {
        return this.cacheInstance.getCurrentMemoryCacheSizeInMB();
    }

    public int getDefaultPriority() {
        return this.cacheInstance.getCacheConfig().getCachePriority();
    }

    public Collection getAllDependencyIds() {
        return this.cacheInstance.getAllDependencyIds();
    }

    public Collection getCacheIdsByDependency(String dependency) {
        return this.cacheInstance.getCacheIdsByDependency(dependency);
    }

    public Collection getCacheIdsByTemplate(String template) {
        return this.cacheInstance.getCacheIdsByTemplate(template);
    }

    public int getTemplatesSizeDisk() {
        return this.cacheInstance.getTemplatesSizeDisk();
    }

    public Collection getTemplateValueDisk(String template) {
        return this.cacheInstance.getCacheIdsByTemplateDisk(template);
    }

    public int getIdsSizeDisk() {
        return this.cacheInstance.getIdsSizeDisk();
    }

    public int getDepIdsSizeDisk() {
        return this.cacheInstance.getDepIdsSizeDisk();
    }

    public Collection getDepIdsByRangeDisk(int index, int length) {
        return this.cacheInstance.getDepIdsByRangeDisk(index, length);
    }

    public Collection getDepIdValueDisk(Object depId) {
        return this.cacheInstance.getCacheIdsByDependencyDisk(depId);
    }

    public long getDiskCacheSizeLimit() {
        return this.cacheInstance.getCacheConfig().getDiskCacheSize();
    }

    public long getDiskCacheSizeInGBLimit() {
        return this.cacheInstance.getCacheConfig().getDiskCacheSizeInGB();
    }

    public long getDiskCacheEntrySizeInMBLimit() {
        return this.cacheInstance.getCacheConfig().getDiskCacheEntrySizeInMB();
    }

    public boolean getFlushToDiskOnStop() {
        return this.cacheInstance.getCacheConfig().isFlushToDiskOnStop();
    }

    public int getDiskCachePerformanceLevel() {
        return this.cacheInstance.getCacheConfig().getDiskCachePerformanceLevel();
    }

    public long getCleanupFrequency() {
        return this.cacheInstance.getCacheConfig().getCleanupFrequency();
    }

    public boolean getDelayOffload() {
        return this.cacheInstance.getCacheConfig().isDelayOffload();
    }

    public long getDelayOffloadEntriesLimit() {
        return this.cacheInstance.getCacheConfig().getDelayOffloadEntriesLimit();
    }

    public long getDelayOffloadDepIdBuckets() {
        return this.cacheInstance.getCacheConfig().getDelayOffloadDepIdBuckets();
    }

    public long getDelayOffloadTemplateBuckets() {
        return this.cacheInstance.getCacheConfig().getDelayOffloadTemplateBuckets();
    }

    public int getDiskCacheEvictionPolicy() {
        return this.cacheInstance.getCacheConfig().getDiskCacheEvictionPolicy();
    }

    public int getDiskCacheHighThreshold() {
        return this.cacheInstance.getCacheConfig().getDiskCacheHighThreshold();
    }

    public int getDiskCacheLowThreshold() {
        return this.cacheInstance.getCacheConfig().getDiskCacheLowThreshold();
    }

    public float getDiskCacheSizeInMBs() {
        return this.cacheInstance.getDiskCacheSizeInMBs();
    }
}

