/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.app.integration.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.feature.ApiRegion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true)
public class MainTracker {
    private static final String APP_IMPORT_SVC = "Application-ImportService";
    private static final String APP_EXPORT_SVC = "Application-ExportService";
    private static final String LOCAL_BINDING_REGION = "liberty.osgi.apps.local.binding.region";
    RegionDigraph _digraph = null;
    Region _localBindingRegion = null;
    ServiceTracker<Object, Object> _svcTracker;
    static final TraceComponent _tc = Tr.register(MainTracker.class);

    @Reference(name="digraph", service=RegionDigraph.class)
    protected synchronized void setDigraph(RegionDigraph digraph) {
        this._digraph = digraph;
    }

    @Activate
    protected void init(ComponentContext componentContext, Map<String, Object> properties) throws BundleException, IOException, InvalidSyntaxException {
        if (this._localBindingRegion == null) {
            this._localBindingRegion = this._digraph.getRegion(LOCAL_BINDING_REGION);
            if (this._localBindingRegion == null) {
                this._localBindingRegion = this._digraph.createRegion(LOCAL_BINDING_REGION);
            }
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
            manifest.getMainAttributes().putValue("Bundle-SymbolicName", "local.binding.region.diagnostics");
            manifest.getMainAttributes().putValue("Bundle-Version", "1.0");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JarOutputStream jos = new JarOutputStream((OutputStream)baos, manifest);
            jos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            Bundle b = this._localBindingRegion.installBundleAtLocation("com.ibm.ws.eba.app.integration.local.binding.region", (InputStream)bais);
            BundleStartLevel startLevel = (BundleStartLevel)b.adapt(BundleStartLevel.class);
            startLevel.setStartLevel(1);
            b.start(3);
            Filter f = FrameworkUtil.createFilter((String)"(objectClass=*)");
            this._svcTracker = new ServiceTracker(b.getBundleContext(), f, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

                public Object addingService(ServiceReference<Object> sr) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("binding region adding " + sr.toString()), (Object[])new Object[0]);
                    }
                    return sr;
                }

                public void modifiedService(ServiceReference<Object> sr, Object o) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"binding region modified service ref `{0}`  object `{1}`", (Object[])new Object[]{sr, o});
                    }
                }

                public void removedService(ServiceReference<Object> sr, Object o) {
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"binding region removed service ref `{0}`  object `{1}`", (Object[])new Object[]{sr, o});
                    }
                }
            });
            this._svcTracker.open();
        }
    }

    @Deactivate
    protected void shutdown() {
        if (this._svcTracker != null) {
            this._svcTracker.close();
        }
    }

    @Reference(name="ss", service=Subsystem.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void setSubsystem(Subsystem ss) throws InvalidSyntaxException, BundleException {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("MainTracker.setSubsystem: " + ss.getSymbolicName()), (Object[])new Object[0]);
        }
        Map headers = ss.getSubsystemHeaders(null);
        String appImportService = (String)headers.get(APP_IMPORT_SVC);
        String appExportService = (String)headers.get(APP_EXPORT_SVC);
        RegionFilterBuilder importFilterBuilder = this.createFilterBuilder(APP_IMPORT_SVC, appImportService);
        RegionFilterBuilder exportFilterBuilder = this.createFilterBuilder(APP_EXPORT_SVC, appExportService);
        this.connectToLocalBinding(ss, importFilterBuilder, exportFilterBuilder);
    }

    private void connectToLocalBinding(final Subsystem ss, final RegionFilterBuilder importFilterBuilder, final RegionFilterBuilder exportFilterBuilder) throws BundleException {
        if (importFilterBuilder == null && exportFilterBuilder == null) {
            return;
        }
        ApiRegion.update((RegionDigraph)this._digraph, (Callable)new Callable<RegionDigraph>(){

            @Override
            public RegionDigraph call() throws Exception {
                Region original = MainTracker.this.getRegion(ss);
                if (original == null) {
                    throw new BundleException("Something removed the application region!  Did the application get uninstalled?");
                }
                RegionDigraph copy = MainTracker.this._digraph.copy();
                Region subsystemRegion = copy.getRegion(original.getName());
                if (subsystemRegion == null) {
                    throw new BundleException("Something removed the application region!  Did the application get uninstalled?");
                }
                Region localBindingRegion = copy.getRegion(MainTracker.this._localBindingRegion.getName());
                if (importFilterBuilder != null) {
                    RegionFilter importFilter = importFilterBuilder.build();
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Connect services from localBindingRegion to " + subsystemRegion.getName() + " with filter " + importFilter.toString()), (Object[])new Object[0]);
                    }
                    subsystemRegion.connectRegion(localBindingRegion, importFilter);
                }
                if (exportFilterBuilder != null) {
                    RegionFilter exportFilter = exportFilterBuilder.build();
                    if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Connect services into localBindingRegion from " + subsystemRegion.getName() + " with filter " + exportFilter.toString()), (Object[])new Object[0]);
                    }
                    localBindingRegion.connectRegion(subsystemRegion, exportFilter);
                }
                return copy;
            }
        });
    }

    private RegionFilterBuilder createFilterBuilder(String appServiceHeaderName, String appServiceHeaderValue) throws InvalidSyntaxException {
        String filter;
        if (appServiceHeaderValue == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(appServiceHeaderName + ": " + appServiceHeaderValue), (Object[])new Object[0]);
        }
        if ((filter = MainTracker.buildFilterString(appServiceHeaderValue)) == null) {
            return null;
        }
        RegionFilterBuilder filterBuilder = this._digraph.createRegionFilterBuilder();
        filterBuilder.allow("org.eclipse.equinox.allow.service", filter);
        return filterBuilder;
    }

    private Region getRegion(Subsystem ss) {
        Bundle regionContextBundle = ss.getBundleContext().getBundle();
        return this._digraph.getRegion(regionContextBundle);
    }

    protected void unsetSubsystem(Subsystem ss) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("subsystem leaving: " + ss.getSymbolicName()), (Object[])new Object[0]);
        }
    }

    static String buildFilterString(String header) throws InvalidSyntaxException {
        if (header.isEmpty()) {
            return null;
        }
        String[] entries = header.split(",");
        List<String> filteredEntries = MainTracker.stripDirectives(entries);
        if (filteredEntries.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder("(|");
        for (String s : filteredEntries) {
            boolean partHasFilter;
            List parts = ManifestHeaderProcessor.split((String)s, (String)";");
            if (parts.isEmpty()) continue;
            boolean bl = partHasFilter = parts.size() > 1;
            if (partHasFilter) {
                result.append("(&");
            }
            result.append("(");
            result.append("objectClass");
            result.append("=");
            result.append((String)parts.get(0));
            result.append(")");
            if (!partHasFilter) continue;
            boolean foundFilter = false;
            for (int i = 1; i < parts.size() && !foundFilter; ++i) {
                String filterSuspect;
                List subParts = ManifestHeaderProcessor.split((String)((String)parts.get(i)), (String)"=");
                if (subParts.size() != 2 || !((String)subParts.get(0)).equals("filter") || !(filterSuspect = (String)subParts.get(1)).startsWith("\"") || !filterSuspect.endsWith("\"")) continue;
                foundFilter = true;
                result.append(filterSuspect.substring(1, filterSuspect.length() - 1) + ")");
            }
        }
        result.append(")");
        return result.toString();
    }

    static List<String> stripDirectives(String[] entries) {
        ArrayList<String> result = new ArrayList<String>();
        for (String entry : entries) {
            boolean foundLocalBinding = false;
            StringBuilder thisEntry = new StringBuilder();
            List elements = ManifestHeaderProcessor.split((String)entry, (String)";");
            for (String e : elements) {
                List subElements = ManifestHeaderProcessor.split((String)e, (String)":=");
                if (subElements.size() == 1) {
                    thisEntry.append((String)subElements.get(0) + ";");
                    continue;
                }
                if (!((String)subElements.get(0)).equals("binding") || !((String)subElements.get(1)).equals("local")) continue;
                foundLocalBinding = true;
            }
            if (!foundLocalBinding) continue;
            result.add(thisEntry.toString());
        }
        return result;
    }
}

