/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.bundle.repository.internal.AbstractFileRepository;
import com.ibm.ws.eba.bundle.repository.internal.EmptyRepository;
import com.ibm.ws.eba.bundle.repository.internal.ProtocolResolver;
import com.ibm.ws.eba.bundle.repository.internal.RepositoryID;
import com.ibm.ws.eba.bundle.repository.internal.ResourceResolver;
import com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory;
import com.ibm.ws.eba.bundle.repository.internal.Services;
import com.ibm.ws.eba.bundle.repository.internal.Utils;
import com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.aries.subsystem.util.felix.FelixRepositoryAdapter;
import org.apache.aries.subsystem.util.felix.FelixResourceAdapter;
import org.apache.aries.util.filesystem.IFile;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.cm.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LocalCacheRepository
extends AbstractFileRepository
implements org.osgi.service.repository.Repository {
    private static final Resource[] NO_RESOURCES;
    private Lock obrXmlLock = new ReentrantLock();
    private final ServiceRegistration<org.osgi.service.repository.Repository> registration;
    private volatile RepositoryID repoID = null;
    private volatile RepositoryID pendingRepoID = null;
    private volatile WsResource obrXml = null;
    private FelixRepositoryAdapter remoteRepo = null;
    private Repository remoteFelixRepo = null;
    private final BundleContext ctx;
    private final ConcurrentMap<Resource, RunnableFuture<WsResource>> expectedResources = new ConcurrentHashMap<Resource, RunnableFuture<WsResource>>();
    static final long serialVersionUID = -1226400786205616611L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LocalCacheRepository(BundleContext ctx, Services services) {
        super(services);
        this.registration = ctx.registerService(org.osgi.service.repository.Repository.class, (Object)this, null);
        this.ctx = ctx;
    }

    @Override
    public void setXMLLock(Lock lock) {
        this.obrXmlLock = lock;
    }

    @Override
    public String getName() {
        if (this.repoID == null) {
            return "LocalCacheRepository";
        }
        return this.repoID.url.toString();
    }

    protected Properties getRepositoryProperties() {
        Properties props;
        block4: {
            props = new Properties();
            WsLocationAdmin svc = this.services.getLocationService();
            if (svc == null) {
                Tr.warning((TraceComponent)tc, (String)"warn.missing.service", (Object[])new Object[]{"Location service"});
                return props;
            }
            ResourceResolver resolver = ResourceResolverFactory.createConfigResolver(svc);
            WsResource resource = resolver.getResource(this.repoID.id);
            if (resource.exists()) {
                try {
                    props.load(resource.get());
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"129", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isWarningEnabled()) break block4;
                    Tr.warning((TraceComponent)tc, (String)"warn.properties.load", (Object[])new Object[]{resource});
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRepositoryProperties(Properties props) {
        WsLocationAdmin svc = this.services.getLocationService();
        if (svc == null) {
            Tr.warning((TraceComponent)tc, (String)"warn.missing.service", (Object[])new Object[]{"Location service"});
            return;
        }
        ResourceResolver resolver = ResourceResolverFactory.createConfigResolver(svc);
        WsResource resource = resolver.getResource(this.repoID.id);
        if (resource.exists()) {
            resource.delete();
        }
        OutputStream out = null;
        try {
            out = resource.putStream();
            props.store(out, "");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"153", (Object)this, (Object[])new Object[]{props});
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"warn.properties.save", (Object[])new Object[]{resource});
            }
        }
        finally {
            Utils.close(out);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void validateConfig(Dictionary<String, Object> properties) throws ConfigurationException {
        String location = properties.get("location").toString();
        WsLocationAdmin svc = this.services.getLocationService();
        if (svc == null) {
            Tr.warning((TraceComponent)tc, (String)"warn.missing.service", (Object[])new Object[]{"Location service"});
            return;
        }
        WsResource configDir = svc.resolveResource("${server.config.dir}");
        RepositoryID repoid = new RepositoryID(location, configDir.toExternalURI());
        if (repoid.url.getProtocol().equalsIgnoreCase("file")) {
            try {
                WsResource resource = svc.resolveResource(repoid.uri);
                if (resource == null) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"warn.validation.fileresolve", (Object[])new Object[]{location});
                    throw new ConfigurationException("location", msg);
                }
                if (!resource.isType(WsResource.Type.FILE)) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"warn.validation.fileonly", (Object[])new Object[]{location});
                    throw new ConfigurationException("location", msg);
                }
            }
            catch (Exception resource) {
                void e;
                FFDCFilter.processException((Throwable)resource, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"190", (Object)this, (Object[])new Object[]{properties});
                throw new ConfigurationException("location", e.getLocalizedMessage());
            }
        }
        this.pendingRepoID = repoid;
    }

    @Override
    public void updateConfig(Dictionary<String, Object> properties) {
        Properties props;
        this.obrXmlLock.lock();
        try {
            if (this.pendingRepoID == null) {
                try {
                    this.validateConfig(properties);
                }
                catch (ConfigurationException configurationException) {
                    FFDCFilter.processException((Throwable)configurationException, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"211", (Object)this, (Object[])new Object[]{properties});
                    this.obrXmlLock.unlock();
                    return;
                }
            }
            if (!this.pendingRepoID.equals(this.repoID) && this.obrXml != null) {
                this.obrXml.delete();
                this.obrXml = null;
            }
            this.repoID = this.pendingRepoID;
            this.pendingRepoID = null;
        }
        finally {
            this.obrXmlLock.unlock();
        }
        if (tc.isAuditEnabled()) {
            Tr.audit((TraceComponent)tc, (String)"audit.http.url", (Object[])new Object[]{this.repoID.url.toString()});
        }
        if ((props = this.getRepositoryProperties()).isEmpty()) {
            props.setProperty("url", this.repoID.url.toString());
            props.setProperty("id", this.repoID.id);
            this.setRepositoryProperties(props);
        }
    }

    @Override
    public void delete() {
        this.obrXmlLock.lock();
        try {
            if (this.registration != null) {
                this.registration.unregister();
            }
        }
        finally {
            this.obrXmlLock.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The LocalCacheRepository was removed", (Object[])new Object[]{this.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        List<RunnableFuture<WsResource>> futures;
        ExecutorService executor = this.services.getExecutorService();
        if (executor == null) {
            return Collections.emptyMap();
        }
        this.obrXmlLock.lock();
        try {
            Resource[] remoteResources = this.getMatchingResources(requirements);
            if (remoteResources == NO_RESOURCES) {
                Map<Requirement, Collection<Capability>> map = Collections.emptyMap();
                return map;
            }
            futures = this.queueForDownload(executor, remoteResources);
        }
        finally {
            this.obrXmlLock.unlock();
        }
        if (futures == null || futures.size() == 0) {
            return Collections.emptyMap();
        }
        org.osgi.service.repository.Repository repo = this.waitForDownloads(futures);
        Map matches = repo.findProviders(requirements);
        return matches;
    }

    private Resource[] getMatchingResources(Collection<? extends Requirement> requirements) {
        ConcurrentHashMap<Requirement, Collection<Capability>> capabilities = new ConcurrentHashMap<Requirement, Collection<Capability>>();
        try {
            WsLocationAdmin svc = this.services.getLocationService();
            if (svc == null) {
                Tr.warning((TraceComponent)tc, (String)"warn.missing.service", (Object[])new Object[]{"Location service"});
                return NO_RESOURCES;
            }
            ResourceResolver resolver = ResourceResolverFactory.createOBRXMLResolver(svc);
            ProtocolResolver.Protocol protocol = ProtocolResolver.getProtocol(this.repoID.url);
            WsResource xml = protocol.getResource(this.repoID.url, resolver, this.services);
            if (xml != null && !xml.equals(this.obrXml)) {
                this.resolveURLs(xml);
                this.remoteFelixRepo = this.createRepository(xml);
                this.remoteRepo = new FelixRepositoryAdapter(this.remoteFelixRepo);
                if (this.obrXml != null) {
                    this.obrXml.delete();
                }
                this.obrXml = xml;
            }
            capabilities.putAll(this.remoteRepo.findProviders(requirements));
            if (capabilities.isEmpty()) {
                return NO_RESOURCES;
            }
            return this.getResources(capabilities);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"331", (Object)this, (Object[])new Object[]{requirements});
            return NO_RESOURCES;
        }
    }

    private Resource[] getResources(Map<Requirement, Collection<Capability>> capabilities) {
        Resource[] matches = new Resource[this.remoteFelixRepo.getResources().length];
        FelixResourceAdapter[] candidates = new FelixResourceAdapter[matches.length];
        for (int i = 0; i < candidates.length; ++i) {
            candidates[i] = new FelixResourceAdapter(this.remoteFelixRepo.getResources()[i]);
        }
        for (Map.Entry<Requirement, Collection<Capability>> entry : capabilities.entrySet()) {
            for (Capability c : entry.getValue()) {
                for (int i = 0; i < candidates.length; ++i) {
                    if (candidates[i] == null || !candidates[i].equals((Object)c.getResource())) continue;
                    matches[i] = this.remoteFelixRepo.getResources()[i];
                    candidates[i] = null;
                }
            }
        }
        return matches;
    }

    private List<RunnableFuture<WsResource>> queueForDownload(ExecutorService executor, Resource[] remoteResources) {
        ArrayList<RunnableFuture<WsResource>> futures = new ArrayList<RunnableFuture<WsResource>>();
        for (final Resource resource : remoteResources) {
            if (resource == null) continue;
            try {
                final RemoteResourceLocation location = new RemoteResourceLocation(resource);
                FutureTask<WsResource> future = new FutureTask<WsResource>(new Callable<WsResource>(){
                    static final long serialVersionUID = -6555266761400144199L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public WsResource call() throws Exception {
                        ProtocolResolver.Protocol protocol = ProtocolResolver.getProtocol(location.getURL());
                        ResourceResolver resolver = location.getResolver();
                        if (resolver == null) {
                            return null;
                        }
                        WsResource localResource = protocol.getResource(location.getURL(), resolver, LocalCacheRepository.this.services);
                        return localResource;
                    }

                    public boolean equals(Object o) {
                        return resource.equals(o);
                    }

                    public int hashCode() {
                        return resource.hashCode();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository$1", 1.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
                    }
                });
                FutureTask<WsResource> task = this.expectedResources.putIfAbsent(resource, future);
                if (task == null) {
                    task = future;
                }
                futures.add(task);
                executor.execute(task);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"408", (Object)this, (Object[])new Object[]{executor, remoteResources});
            }
            catch (URISyntaxException uRISyntaxException) {
                FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"409", (Object)this, (Object[])new Object[]{executor, remoteResources});
            }
        }
        return futures;
    }

    @FFDCIgnore(value={InterruptedException.class})
    private org.osgi.service.repository.Repository waitForDownloads(List<RunnableFuture<WsResource>> futures) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting on pending futures", (Object[])new Object[]{futures});
        }
        ArrayList<WsResource> resources = new ArrayList<WsResource>();
        for (Future future : futures) {
            try {
                WsResource result = (WsResource)future.get();
                if (result == null) continue;
                resources.add(result);
            }
            catch (InterruptedException e) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){
                    static final long serialVersionUID = -7962214060635357523L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() {
                        Thread.currentThread().interrupt();
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository$2", 2.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
                    }
                });
            }
            catch (ExecutionException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"438", (Object)this, (Object[])new Object[]{futures});
                if (!tc.isWarningEnabled()) continue;
                Tr.warning((TraceComponent)tc, (String)"warn.resource.download", (Object[])new Object[0]);
            }
        }
        org.osgi.service.repository.Repository repo = this.createCacheRepository(resources);
        return repo;
    }

    private void resolveURLs(WsResource file) {
        Document doc = this.loadXML(file);
        if (doc == null) {
            if (tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"warn.validation.urlresolve", (Object[])new Object[]{file});
            }
            return;
        }
        boolean dirty = false;
        NodeList resources = doc.getElementsByTagName("resource");
        for (int i = 0; i < resources.getLength(); ++i) {
            NamedNodeMap attribs = resources.item(i).getAttributes();
            Node node = attribs.getNamedItem("uri");
            if (node == null) continue;
            try {
                URI uri = new URI(node.getNodeValue());
                if (uri.isAbsolute()) continue;
                dirty = true;
                node.setNodeValue(this.repoID.uri.resolve(uri).toString());
                continue;
            }
            catch (URISyntaxException uri) {
                FFDCFilter.processException((Throwable)uri, (String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", (String)"481", (Object)this, (Object[])new Object[]{file});
                if (!tc.isWarningEnabled()) continue;
                Tr.warning((TraceComponent)tc, (String)"warn.validation.uriresovle", (Object[])new Object[]{file});
            }
        }
        if (dirty) {
            this.saveXML(file, doc);
        }
    }

    @Override
    public String getID() {
        if (this.repoID != null) {
            return this.repoID.id;
        }
        if (this.pendingRepoID != null) {
            return this.pendingRepoID.id;
        }
        return this.toString();
    }

    @Override
    public String getLocation() {
        if (this.repoID != null) {
            return this.repoID.url.toString();
        }
        if (this.pendingRepoID != null) {
            return this.pendingRepoID.url.toString();
        }
        return "";
    }

    @Override
    public byte[] getOBRXML() {
        this.obrXmlLock.lock();
        try {
            if (this.obrXml == null) {
                byte[] byArray = NO_BYTES_VALUE_SET;
                return byArray;
            }
            byte[] byArray = Utils.getContents(this.obrXml);
            return byArray;
        }
        finally {
            this.obrXmlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.osgi.service.repository.Repository createCacheRepository(List<WsResource> wsresources) {
        ArrayList<File> files = new ArrayList<File>();
        for (WsResource resource : wsresources) {
            files.add(resource.asFile());
        }
        Collection<IFile> ifiles = Utils.convertFilesetToIFiles(files);
        Object repositoryGenerator = this.services.getRepoGenerator();
        if (repositoryGenerator != null) {
            WsResource xml = null;
            try {
                xml = ResourceModellingUtils.createOBR(ifiles, this.ctx, this.services.getLocationService(), repositoryGenerator, tc);
                if (xml == null) {
                    EmptyRepository emptyRepository = new EmptyRepository();
                    return emptyRepository;
                }
                Repository repo = this.createRepository(xml);
                FelixRepositoryAdapter felixRepositoryAdapter = new FelixRepositoryAdapter(repo);
                return felixRepositoryAdapter;
            }
            finally {
                if (xml != null && xml.exists()) {
                    xml.delete();
                }
            }
        }
        return Utils.createRepository(ifiles);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository", LocalCacheRepository.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
        NO_RESOURCES = new Resource[0];
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class RemoteResourceLocation {
        private final URL url;
        private final ResourceResolver resolver;
        static final long serialVersionUID = 2166433410330652212L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RemoteResourceLocation(Resource resource) throws URISyntaxException, MalformedURLException {
            WsLocationAdmin svc = LocalCacheRepository.this.services.getLocationService();
            if (svc == null) {
                Tr.warning((TraceComponent)AbstractFileRepository.tc, (String)"warn.missing.service", (Object[])new Object[]{"Location service"});
                this.resolver = null;
            } else {
                this.resolver = ResourceResolverFactory.createCacheResolver(svc, ((LocalCacheRepository)LocalCacheRepository.this).repoID.id);
            }
            URI uri = new URI(resource.getURI());
            if (uri.isAbsolute()) {
                this.url = uri.toURL();
            } else {
                URI base = new URI(LocalCacheRepository.this.remoteFelixRepo.getURI());
                this.url = base.resolve(uri).toURL();
            }
        }

        URL getURL() {
            return this.url;
        }

        ResourceResolver getResolver() {
            return this.resolver;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.LocalCacheRepository$RemoteResourceLocation", RemoteResourceLocation.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
        }
    }
}

