/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.bundle.repository.internal.HTTPRemoteRepository;
import com.ibm.ws.eba.bundle.repository.internal.ResourceResolver;
import com.ibm.ws.eba.bundle.repository.internal.Services;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.osgi.service.cm.ConfigurationException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ProtocolResolver {
    private static final TraceComponent tc = Tr.register(ProtocolResolver.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
    static final long serialVersionUID = 8726583235305503883L;

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalArgumentException.class})
    public static Protocol getProtocol(String location) throws ConfigurationException {
        if (location != null) {
            URI uri;
            try {
                uri = new URI(location);
            }
            catch (URISyntaxException uRISyntaxException) {
                void e1;
                FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.eba.bundle.repository.internal.ProtocolResolver", (String)"40", null, (Object[])new Object[]{location});
                throw new ConfigurationException(location, e1.getLocalizedMessage(), (Throwable)e1);
            }
            String type = uri.isAbsolute() ? uri.getScheme().toLowerCase() : "file";
            try {
                return Protocol.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                Tr.warning((TraceComponent)tc, (String)"warn.protocol.invalid", (Object[])new Object[]{type.toUpperCase(), uri});
            }
        }
        return Protocol.notsupported;
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static Protocol getProtocol(URL url) throws ConfigurationException {
        if (url != null) {
            try {
                return Protocol.valueOf(url.getProtocol().toLowerCase());
            }
            catch (IllegalArgumentException e) {
                Tr.warning((TraceComponent)tc, (String)"warn.protocol.notsupported", (Object[])new Object[]{url.getProtocol().toUpperCase(), url});
            }
        }
        return Protocol.notsupported;
    }

    public static enum Protocol {
        notsupported,
        http{

            @Override
            public WsResource getResource(URL resurl, ResourceResolver resolver, Services services) throws IOException {
                return HTTPRemoteRepository.getRemoteResource(resurl, resolver);
            }

            @Override
            public void clean(Services services) {
                WsLocationAdmin svc = services.getLocationService();
                if (svc != null) {
                    HTTPRemoteRepository.clean(svc);
                }
            }
        }
        ,
        https{

            @Override
            public WsResource getResource(URL resurl, ResourceResolver resolver, Services services) throws IOException {
                return HTTPRemoteRepository.getRemoteResource(resurl, resolver);
            }

            @Override
            public void clean(Services services) {
                WsLocationAdmin svc = services.getLocationService();
                if (svc != null) {
                    HTTPRemoteRepository.clean(svc);
                }
            }
        }
        ,
        file{

            @Override
            public WsResource getResource(URL resurl, ResourceResolver resolver, Services services) throws IOException {
                WsLocationAdmin admin = services.getLocationService();
                if (admin != null) {
                    try {
                        return admin.resolveResource(resurl.toURI());
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                }
                return null;
            }

            @Override
            public void clean(Services services) {
            }
        };


        public WsResource getResource(URL resurl, ResourceResolver resolver, Services services) throws IOException {
            return null;
        }

        public void clean(Services services) {
        }
    }
}

