/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal.blueprint;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.bundle.repository.internal.blueprint.RepositoryGeneratorReady;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={})
public class RepositoryGeneratorReadyManager
implements ServiceTrackerCustomizer<Object, RepositoryGeneratorReady> {
    private static final String REPOSITORY_GENERATOR_CLASS = "org.apache.aries.application.management.spi.repository.RepositoryGenerator";
    private RepositoryGeneratorReady noGeneratorAvailableReady;
    private ServiceTracker<Object, RepositoryGeneratorReady> repositoryGeneratorTracker = null;
    private volatile BundleContext context;
    static final long serialVersionUID = 96474742304732242L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(BundleContext context) {
        this.context = context;
        this.registerRepositoryGeneratorReady();
    }

    @Deactivate
    protected void deactivate() {
        if (this.noGeneratorAvailableReady != null) {
            this.noGeneratorAvailableReady.unregister();
        }
        if (this.repositoryGeneratorTracker != null) {
            this.repositoryGeneratorTracker.close();
        }
    }

    private void registerRepositoryGeneratorReady() {
        if (!this.isRepositoryGeneratorInstalled()) {
            this.noGeneratorAvailableReady = new RepositoryGeneratorReady(null);
            this.noGeneratorAvailableReady.register(this.context);
        } else {
            this.repositoryGeneratorTracker = new ServiceTracker(this.context, REPOSITORY_GENERATOR_CLASS, (ServiceTrackerCustomizer)this);
            this.repositoryGeneratorTracker.open();
        }
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private boolean isRepositoryGeneratorInstalled() {
        try {
            Class.forName(REPOSITORY_GENERATOR_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public RepositoryGeneratorReady addingService(ServiceReference<Object> reference) {
        return new RepositoryGeneratorReady(this.context.getService(reference)).register(this.context);
    }

    public void modifiedService(ServiceReference<Object> reference, RepositoryGeneratorReady ready) {
    }

    public void removedService(ServiceReference<Object> reference, RepositoryGeneratorReady ready) {
        ready.unregister();
        this.context.ungetService(reference);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.RepositoryGeneratorReadyManager", RepositoryGeneratorReadyManager.class, null, null);
    }
}

