/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.fidelity;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.eba.wab.integrator.EbaProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FidelityBundleActivator
implements BundleActivator {
    private static final TraceComponent tc = Tr.register(FidelityBundleActivator.class, (String[])new String[]{"webcontainer", "applications"}, (String)"com.ibm.ws.eba.fidelity.resources.Messages", (String)"com.ibm.ws.eba.fidelity.FidelityBundleActivator");
    private static final HashMap<String, Version> packageHash = new HashMap();
    private static final String activeSubsystemFilter = "(&(objectClass=" + Subsystem.class.getName() + ")(" + "subsystem.state" + "=" + Subsystem.State.ACTIVE + ")(!(" + "subsystem.id" + "=0)))";
    private ServiceTracker<EbaProvider, EbaProvider> ebaProviderTracker;
    private ServiceTracker<Subsystem, Subsystem> subsystems;
    static final long serialVersionUID = 8133904068112255185L;

    public void start(final BundleContext context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Fidelity bundle started.", (Object[])new Object[]{context});
        }
        this.ebaProviderTracker = new ServiceTracker(context, EbaProvider.class, null);
        this.ebaProviderTracker.open();
        this.subsystems = new ServiceTracker(FidelityBundleActivator.getSystemBundleContext(context), context.createFilter(activeSubsystemFilter), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Subsystem, Subsystem>(){
            static final long serialVersionUID = 4352032827758043733L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Subsystem addingService(ServiceReference<Subsystem> reference) {
                ApplicationInfo appInfo;
                EbaProvider ebaProvider = (EbaProvider)FidelityBundleActivator.this.ebaProviderTracker.getService();
                if (ebaProvider == null) {
                    return null;
                }
                Subsystem subsystem = (Subsystem)context.getService(reference);
                BundleContext subsystemContext = subsystem == null ? null : subsystem.getBundleContext();
                Bundle contextBundle = subsystemContext == null ? null : subsystemContext.getBundle();
                ApplicationInfo applicationInfo = appInfo = contextBundle == null ? null : ebaProvider.getApplicationInfo(contextBundle);
                if (appInfo == null) {
                    return null;
                }
                Bundle[] subsystemBundles = subsystemContext.getBundles();
                HashSet<String> blameBundles = new HashSet<String>();
                HashSet<String> blamePackages = new HashSet<String>();
                if (subsystemBundles != null) {
                    for (Bundle bundle : subsystemBundles) {
                        FidelityBundleActivator.this.checkBundle(bundle, blameBundles, blamePackages);
                    }
                    if (!blamePackages.isEmpty()) {
                        FidelityBundleActivator.this.logFidelityMessage(appInfo.getName(), blameBundles, blamePackages);
                    }
                }
                return null;
            }

            public void modifiedService(ServiceReference<Subsystem> reference, Subsystem service) {
            }

            public void removedService(ServiceReference<Subsystem> reference, Subsystem service) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"webcontainer", "applications"}, (String)"com.ibm.ws.eba.fidelity.resources.Messages", (String)"com.ibm.ws.eba.fidelity.FidelityBundleActivator$1");
            }
        });
        this.subsystems.open();
    }

    private static BundleContext getSystemBundleContext(BundleContext ctx) {
        Bundle systemBundle = ctx.getBundle("System Bundle");
        if (systemBundle == null) {
            return ctx;
        }
        return systemBundle.getBundleContext();
    }

    public void stop(BundleContext context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Fidelity bundle stopped", (Object[])new Object[]{context});
        }
        if (this.subsystems != null) {
            this.subsystems.close();
        }
    }

    void checkBundle(Bundle bundle, Set<String> blameBundles, Set<String> blamePackages) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            for (BundleWire packageWire : wiring.getRequiredWires("osgi.wiring.package")) {
                FidelityBundleActivator.checkFidelityErrors(packageWire, blameBundles, blamePackages);
            }
        }
    }

    private void logFidelityMessage(String appName, Set<String> blameBundles, Set<String> blamePackages) {
        Tr.audit((TraceComponent)tc, (String)"fidelity.warning", (Object[])new Object[]{appName, blameBundles.toString(), blamePackages.toString()});
    }

    private static void checkFidelityErrors(BundleWire packageWire, Set<String> blameBundles, Set<String> blamePackages) {
        String blameBundle = packageWire.getRequirement().getRevision().getSymbolicName();
        BundleCapability c = packageWire.getCapability();
        Map cAttrs = c.getAttributes();
        String blamePackage = (String)cAttrs.get("osgi.wiring.package");
        Map m = packageWire.getRequirement().getDirectives();
        Version maxVersion = packageHash.get(blamePackage);
        if (maxVersion == null) {
            return;
        }
        if (maxVersion == Version.emptyVersion) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Requirement rejected by fidelity resolver hook.", (Object[])new Object[]{blamePackage});
            }
            blameBundles.add(blameBundle);
            blamePackages.add(blamePackage);
            return;
        }
        try {
            String requirementFilter = (String)m.get("filter");
            Filter f = FrameworkUtil.createFilter((String)requirementFilter);
            HashMap<String, Version> tempAttrs = new HashMap<String, Version>(cAttrs);
            tempAttrs.put("version", maxVersion);
            if (!f.matches(tempAttrs)) {
                blameBundles.add(blameBundle);
                blamePackages.add(blamePackage);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.eba.fidelity.FidelityBundleActivator", (String)"215", null, (Object[])new Object[]{packageWire, blameBundles, blamePackages});
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        packageHash.put("org.osgi.framework", Version.parseVersion((String)"1.5"));
        packageHash.put("org.osgi.framework.hooks.service", Version.parseVersion((String)"1.0"));
        packageHash.put("org.osgi.service.condpermadmin", Version.parseVersion((String)"1.1"));
        packageHash.put("org.osgi.util.tracker", Version.parseVersion((String)"1.4"));
        packageHash.put("org.osgi.framework.hooks.bundle", Version.emptyVersion);
        packageHash.put("org.osgi.framework.hooks.resolver", Version.emptyVersion);
        packageHash.put("org.osgi.framework.hooks.weaving", Version.emptyVersion);
        packageHash.put("org.osgi.framework.namespace", Version.emptyVersion);
        packageHash.put("org.osgi.framework.startlevel", Version.emptyVersion);
        packageHash.put("org.osgi.framework.wiring", Version.emptyVersion);
        packageHash.put("org.osgi.resource", Version.emptyVersion);
        packageHash.put("org.osgi.service.framework", Version.emptyVersion);
    }
}

