/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.fidelity;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={}, immediate=true)
public class SubsystemStartupClean {
    private static final List<String> BSNs;
    static final long serialVersionUID = 6129565727951959024L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(BundleContext bc) {
        Bundle[] bundles = bc.getBundles();
        block0: for (String bsn : BSNs) {
            for (Bundle bndl : bundles) {
                if (!bndl.getSymbolicName().startsWith(bsn)) continue;
                this.removeDataDirectoryContents(bndl);
                continue block0;
            }
        }
    }

    private void removeDataDirectoryContents(Bundle bndl) {
        final Path data = bndl.getDataFile("").toPath();
        try {
            Files.walkFileTree(data, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                static final long serialVersionUID = 904009462391629401L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public FileVisitResult postVisitDirectory(Path p, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    if (!p.equals(data)) {
                        Files.delete(p);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes ba) throws IOException {
                    Files.delete(p);
                    return FileVisitResult.CONTINUE;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"webcontainer", "applications"}, (String)"com.ibm.ws.eba.fidelity.resources.Messages", (String)"com.ibm.ws.eba.fidelity.SubsystemStartupClean$1");
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.fidelity.SubsystemStartupClean", (String)"81", (Object)this, (Object[])new Object[]{bndl});
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SubsystemStartupClean.class, (String[])new String[]{"webcontainer", "applications"}, (String)"com.ibm.ws.eba.fidelity.resources.Messages", (String)"com.ibm.ws.eba.fidelity.SubsystemStartupClean");
        BSNs = Collections.unmodifiableList(Arrays.asList("com.ibm.ws.org.apache.aries.subsystem.core.", "com.ibm.ws.org.apache.aries.blueprint."));
    }
}

