/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.blueprint.xml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.blueprint.transform.BlueprintXml;
import com.ibm.ws.eba.jpa.annotation.scanning.AnnotationSource;
import com.ibm.ws.eba.jpa.blueprint.xml.BluePrintHandler;
import com.ibm.ws.eba.jpa.blueprint.xml.EnhancementResult;
import com.ibm.ws.eba.jpa.blueprint.xml.JPAAnnotationHandlerException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.aries.util.io.IOUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BluePrintAnnotationEnhancer {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private final AnnotationSource annotationSource;
    private SAXParser parser = null;
    private static final TraceComponent tc = Tr.register(BluePrintAnnotationEnhancer.class, (String)"Aries.jpa", (String)"com.ibm.ws.eba.jpa.nls.CWSAFAnnotationMessages");

    public BluePrintAnnotationEnhancer(AnnotationSource annotationSource) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BluePrintAnnotationEnhancer", (Object[])new Object[]{annotationSource});
        }
        this.annotationSource = annotationSource;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BluePrintAnnotationEnhancer", (Object)this);
        }
    }

    private void initParser() throws JPAAnnotationHandlerException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initParser", (Object[])new Object[0]);
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.parser = factory.newSAXParser();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.jpa.impl.sax.BluePrintAnnotationEnhancer.initParser", (String)"696", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initParser", (Object)"JPAAnnotationHandlerException");
            }
            throw new JPAAnnotationHandlerException(e, "SAX_PARSER_EXCEPTION_CWSAF0004E", new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initParser");
        }
    }

    private EnhancementResult enhance(InputStream xmlDocument) throws JPAAnnotationHandlerException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enhance", (Object[])new Object[]{xmlDocument});
        }
        if (this.parser == null) {
            this.initParser();
        }
        BluePrintHandler handler = new BluePrintHandler(this.annotationSource);
        try {
            this.parser.parse(xmlDocument, (DefaultHandler)handler);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.jpa.impl.sax.BluePrintAnnotationEnhancer.enhance", (String)"723", (Object)this);
            JPAAnnotationHandlerException jahe = new JPAAnnotationHandlerException(e, "BLUEPRINT_READ_EXCEPTION_CWSAF0005E", xmlDocument, e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enhance", (Object)jahe);
            }
            throw jahe;
        }
        catch (SAXException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.jpa.impl.sax.BluePrintAnnotationEnhancer.enhance", (String)"729", (Object)this);
            JPAAnnotationHandlerException jahe = new JPAAnnotationHandlerException(e, "BLUEPRINT_PARSE_EXCEPTION_CWSAF0006E", xmlDocument, e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"enhance", (Object)jahe);
            }
            throw jahe;
        }
        EnhancementResult result = new EnhancementResult();
        result.element = handler.getDocumentElement();
        result.changed = handler.isChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enhance", (Object)result);
        }
        return result;
    }

    public void enhanceAll(Collection<? extends BlueprintXml> configDocs) throws JPAAnnotationHandlerException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enhanceAll", (Object[])new Object[]{configDocs});
        }
        LinkedHashMap results = new LinkedHashMap();
        for (BlueprintXml blueprintXml : configDocs) {
            InputStream in = null;
            try {
                in = blueprintXml.getInputStream();
                EnhancementResult res = this.enhance(in);
                if (!res.changed) continue;
                OutputStreamWriter writer = new OutputStreamWriter(blueprintXml.getOutputStream());
                writer.write(XML_HEADER);
                writer.write(res.element.toString());
                writer.close();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.jpa.impl.sax.BluePrintAnnotationEnhancer.enhanceAll", (String)"769", (Object)this);
                JPAAnnotationHandlerException jahe = new JPAAnnotationHandlerException(e, "BLUEPRINT_READ_EXCEPTION_CWSAF0005E", blueprintXml);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"enhanceAll", (Object)jahe);
                }
                throw jahe;
            }
            finally {
                IOUtils.close((Closeable)in);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enhanceAll", results);
        }
    }
}

