/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.blueprint.xml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.jpa.blueprint.xml.BluePrintAttribute;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BluePrintElement {
    private String uri;
    private String localName;
    private String qName;
    private LinkedList<Object> content;
    private StringBuffer header;
    private List<BluePrintAttribute> attributes;
    private Map<String, BluePrintAttribute> attributeMap;
    private Map<String, String> namespaces;
    private BluePrintElement parent;
    private static final TraceComponent tc = Tr.register(BluePrintElement.class, (String)"Aries.jpa", (String)"com.ibm.ws.eba.jpa.nls.CWSAFAnnotationMessages");

    public BluePrintElement getParent() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getParent", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getParent", (Object)this.parent);
        }
        return this.parent;
    }

    public BluePrintElement(BluePrintElement parent, String uri, String localName, String qName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"BluePrintElement", (Object[])new Object[]{parent, uri, localName, qName});
        }
        this.parent = parent;
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        this.content = new LinkedList();
        this.content.add(new StringBuffer());
        this.header = new StringBuffer();
        this.header.append("<");
        this.header.append(qName);
        this.namespaces = parent != null ? new LinkedHashMap<String, String>(parent.getNamespaces()) : new LinkedHashMap<String, String>();
        this.attributes = new LinkedList<BluePrintAttribute>();
        this.attributeMap = new LinkedHashMap<String, BluePrintAttribute>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"BluePrintElement", (Object)this);
        }
    }

    private StringBuffer getContentAppender() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getContentAppender", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getContentAppender");
        }
        return (StringBuffer)this.content.getLast();
    }

    public void addText(char[] ch, int start, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addText", (Object[])new Object[0]);
        }
        this.getContentAppender().append(ch, start, length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addText");
        }
    }

    public void addText(String s) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addText", (Object[])new Object[]{s});
        }
        this.getContentAppender().append(s);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addText");
        }
    }

    public void newLine() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"newLine", (Object[])new Object[0]);
        }
        this.addText("\n");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"newLine");
        }
    }

    public void addElement(BluePrintElement child) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addElement", (Object[])new Object[]{child});
        }
        List<Object> childContent = child.getContents();
        this.getContentAppender().append(childContent.remove(0));
        this.content.addAll(childContent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addElement");
        }
    }

    public void setAttribute(String uri, String localName, String qName, Object value) {
        BluePrintAttribute attr;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAttribute", (Object[])new Object[]{uri, localName, qName, value});
        }
        if (this.attributeMap.containsKey(this.attributeHash(uri, localName))) {
            attr = this.attributeMap.get(this.attributeHash(uri, localName));
        } else if (this.uri.equals(uri) && this.attributeMap.containsKey(this.attributeHash("", localName))) {
            attr = this.attributeMap.get(this.attributeHash("", localName));
        } else {
            attr = new BluePrintAttribute(uri, localName, qName, value);
            this.attributes.add(attr);
            this.attributeMap.put(this.attributeHash(uri, localName), attr);
        }
        attr.setValue(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttribute");
        }
    }

    public void setAttributeInDefaultNS(String localName, Object value) {
        this.setAttribute("", localName, localName, value);
    }

    public String getAttribute(String uri, String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttribute", (Object[])new Object[]{uri, name});
        }
        String result = this.getAttribute(uri, name, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttribute", (Object)result);
        }
        return result;
    }

    public String getAttribute(String uri, String name, boolean acceptNoNs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttribute", (Object[])new Object[]{uri, name, acceptNoNs});
        }
        BluePrintAttribute attr = this.attributeMap.get(this.attributeHash(uri, name));
        String result = null;
        if (attr != null) {
            result = String.valueOf(attr.getValue());
        } else if ((this.uri.equals(uri) || acceptNoNs && this.uri.equals("")) && (attr = this.attributeMap.get(this.attributeHash("", name))) != null) {
            result = String.valueOf(attr.getValue());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttribute", (Object)result);
        }
        return result;
    }

    private String attributeHash(String uri, String localName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"attributeHash", (Object[])new Object[]{uri, localName});
        }
        String result = uri != null ? uri + "#" + localName : localName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"attributeHash", (Object)result);
        }
        return result;
    }

    public void addNamespace(String prefix, String uri, boolean force) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNamespace", (Object[])new Object[]{prefix, uri, force});
        }
        if (!force && this.namespaces.containsKey(prefix) && this.namespaces.get(prefix).equals(uri)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addNamespace");
            }
            return;
        }
        this.header.append(" xmlns");
        if (!prefix.equals("")) {
            this.header.append(":");
            this.header.append(prefix);
        }
        this.header.append("=\"");
        this.header.append(uri);
        this.header.append("\"");
        this.namespaces.put(prefix, uri);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNamespace");
        }
    }

    public void addNamespace(String prefix, String uri) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNamespace", (Object[])new Object[]{prefix, uri});
        }
        this.addNamespace(prefix, uri, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNamespace");
        }
    }

    public boolean hasAttribute(String uri, String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"hasAttribute", (Object[])new Object[]{uri, name});
        }
        boolean result = this.attributeMap.containsKey(this.attributeHash(uri, name));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"hasAttribute", (Object)result);
        }
        return result;
    }

    public List<Object> getContents() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getContents", (Object[])new Object[0]);
        }
        LinkedList<Object> result = new LinkedList<Object>();
        StringBuffer buf = new StringBuffer(this.header);
        for (BluePrintAttribute bluePrintAttribute : this.attributes) {
            buf.append(" ");
            buf.append(bluePrintAttribute.getQName());
            buf.append("=\"");
            if (bluePrintAttribute.getValue() instanceof String) {
                buf.append(bluePrintAttribute.getValue());
            } else {
                result.add(buf);
                result.add(bluePrintAttribute.getValue());
                buf = new StringBuffer();
            }
            buf.append("\"");
        }
        if (this.content.size() == 1 && ((StringBuffer)this.content.getFirst()).length() == 0) {
            buf.append("/>");
        } else {
            buf.append(">");
            for (BluePrintAttribute bluePrintAttribute : this.content) {
                if (bluePrintAttribute instanceof StringBuffer) {
                    buf.append(bluePrintAttribute);
                    continue;
                }
                result.add(buf);
                result.add(bluePrintAttribute);
                buf = new StringBuffer();
            }
            buf.append("</");
            buf.append(this.qName);
            buf.append(">");
        }
        result.add(buf);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getContents", result);
        }
        return result;
    }

    public String toString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toString", (Object[])new Object[0]);
        }
        StringBuffer result = new StringBuffer();
        for (Object o : this.getContents()) {
            result.append(o.toString());
        }
        String resStr = result.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toString", (Object)resStr);
        }
        return resStr;
    }

    public String getUri() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUri", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUri", (Object)this.uri);
        }
        return this.uri;
    }

    public String getLocalName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalName", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalName", (Object)this.localName);
        }
        return this.localName;
    }

    public String getQName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getQName", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getQName", (Object)this.qName);
        }
        return this.qName;
    }

    public Map<String, String> getNamespaces() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNamespaces", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNamespaces", this.namespaces);
        }
        return this.namespaces;
    }
}

