/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.blueprint.xml;

import com.ibm.ws.eba.jpa.blueprint.xml.BluePrintElement;
import java.util.ArrayList;
import java.util.List;

class BluePrintElementFactory {
    private BluePrintElement componentsElement;
    private List<BluePrintElement> newElements = new ArrayList<BluePrintElement>();

    BluePrintElementFactory() {
    }

    public FlowElement newTopLevelElement(String uri, String tag) {
        FlowElement result = new FlowElement(new BluePrintElement(this.componentsElement, uri, tag, tag)).namespace("", uri);
        this.newElements.add(result.getTarget());
        return result;
    }

    public FlowElement newChildElement(BluePrintElement parent, String uri, String tag) {
        FlowElement parentWrapper = new FlowElement(parent);
        return parentWrapper.element(uri, tag);
    }

    public List<BluePrintElement> getNewElements() {
        return this.newElements;
    }

    public void setComponentsElement(BluePrintElement componentsElement) {
        this.componentsElement = componentsElement;
    }

    public BluePrintElement getComponentsElement() {
        return this.componentsElement;
    }

    public class FlowElement {
        private BluePrintElement target;
        private FlowElement parent;
        private boolean firstElement = true;

        private FlowElement(BluePrintElement target) {
            this.target = target;
            this.parent = null;
        }

        private FlowElement(FlowElement parent, String tag) {
            this.target = new BluePrintElement(parent.getTarget(), parent.getTarget().getNamespaces().get(""), tag, tag);
            this.parent = parent;
        }

        private FlowElement(FlowElement parent, String uri, String tag) {
            this.target = new BluePrintElement(parent.getTarget(), uri, tag, tag);
            this.target.addNamespace("", uri);
            this.parent = parent;
        }

        public FlowElement namespace(String prefix, String uri) {
            this.target.addNamespace(prefix, uri);
            return this;
        }

        public FlowElement attribute(String name, Object value) {
            if (value != null) {
                this.target.setAttributeInDefaultNS(name, value);
            }
            return this;
        }

        public FlowElement element(String tag) {
            return new FlowElement(this, tag);
        }

        public FlowElement element(String uri, String tag) {
            return new FlowElement(this, uri, tag);
        }

        public void finish() {
            if (this.parent != null) {
                this.parent.addFinishedElement(this.target);
            }
        }

        private BluePrintElement getTarget() {
            return this.target;
        }

        private void addFinishedElement(BluePrintElement e) {
            if (this.firstElement) {
                this.firstElement = false;
                this.target.newLine();
            }
            this.target.addElement(e);
            this.target.newLine();
        }
    }
}

