/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.jpa.blueprint.xml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.jpa.annotation.scanning.AnnotationSource;
import com.ibm.ws.eba.jpa.blueprint.xml.BluePrintElement;
import com.ibm.ws.eba.jpa.blueprint.xml.JPAAnnotationHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class BluePrintHandler
extends DefaultHandler {
    private Stack<BluePrintElement> elements;
    private BluePrintElement documentElement;
    private Map<String, String> newNamespaces;
    private JPAAnnotationHandler handler;
    private static final TraceComponent tc = Tr.register(BluePrintHandler.class, (String)"Aries.jpa", (String)"com.ibm.ws.eba.jpa.nls.CWSAFAnnotationMessages");

    public BluePrintHandler(AnnotationSource source) {
        this.handler = new JPAAnnotationHandler(source, this);
    }

    public boolean isChanged() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isChanged", (Object[])new Object[0]);
        }
        boolean changed = this.handler.isChanged();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isChanged", (Object)changed);
        }
        return changed;
    }

    public BluePrintElement getDocumentElement() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDocumentElement", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDocumentElement", (Object)this.documentElement);
        }
        return this.documentElement;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startElement", (Object[])new Object[]{uri, localName, qName, attr});
        }
        BluePrintElement parent = null;
        if (!this.elements.isEmpty()) {
            parent = this.elements.peek();
        }
        BluePrintElement element = new BluePrintElement(parent, uri, localName, qName);
        this.elements.push(element);
        if (!this.newNamespaces.isEmpty()) {
            for (Map.Entry<String, String> newNs : this.newNamespaces.entrySet()) {
                element.addNamespace(newNs.getKey(), newNs.getValue(), true);
            }
            this.newNamespaces.clear();
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            element.setAttribute(attr.getURI(i), attr.getLocalName(i), attr.getQName(i), attr.getValue(i));
        }
        this.handler.startElement(element);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startElement");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endElement", (Object[])new Object[]{uri, localName, qName});
        }
        BluePrintElement element = this.elements.pop();
        if (this.elements.isEmpty()) {
            this.documentElement = element;
        } else {
            this.elements.peek().addElement(element);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endElement");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"characters", (Object[])new Object[0]);
        }
        if (!this.elements.isEmpty()) {
            this.elements.peek().addText(ch, start, length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"characters");
        }
    }

    @Override
    public void startDocument() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startDocument", (Object[])new Object[0]);
        }
        this.elements = new Stack();
        this.documentElement = null;
        this.newNamespaces = new LinkedHashMap<String, String>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startDocument");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startPrefixMapping", (Object[])new Object[]{prefix, uri});
        }
        this.newNamespaces.put(prefix, uri);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startPrefixMapping");
        }
    }
}

